---
generated_at: 2026-01-22 22:47:00
metrics:
  claims_total: 13
  claims_with_evidence: 8
  claims_without_evidence: 5
confidence_derived: 0.62
---

# 根拠レポート：3-kf5-notifyconfig

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.62**
  - 根拠あり：8 / 13、根拠なし：5
- 優先レビュー（高）
  1. **ビルドスクリプト不完全**：kf5-notificationsと同様の問題を持つ
  2. **Qt5/KF5依存関係**：必要な依存ライブラリのRedox移植状況が不明
  3. **kf5-notificationsとの関係**：依存関係の明示がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `recipes/wip/libs/kf5/kf5-notifyconfig/recipe.toml`（行1-20）
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv`（行4）
- E-03: `recipes/wip/libs/kf5/kf5-notifications/recipe.toml`（行1-20）
- E-04: KDE Frameworks公式ドキュメント（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KNotifyConfigはKDE Frameworks 5用通知設定ライブラリである | E-01, E-02 | ○ |
| C-02 | ソースはKDEサーバーからダウンロードされる | E-01（行3） | ○ |
| C-03 | バージョン5.112.0を使用 | E-01（行3） | ○ |
| C-04 | CMakeビルドシステムを使用 | E-01（行7） | ○ |
| C-05 | WIP状態でビルドスクリプトが不完全 | E-02（備考列）, E-01（行1コメント） | ○ |
| C-06 | kf5-notificationsと同一構造のビルドスクリプト | E-01, E-03（比較） | ○ |
| C-07 | cookbook_configureの呼び出しがある | E-01（行19） | ○ |
| C-08 | KNotificationsとの組み合わせで使用される | E-04 | ○ |
| C-09 | .notifyrcファイルで通知イベント定義を読み込む | **根拠なし**（外部仕様） | △ |
| C-10 | ユーザー設定は~/.config/下に保存される | **根拠なし**（外部仕様） | △ |
| C-11 | 設定UIはダイアログウィジェットとして提供される | **根拠なし**（外部仕様） | △ |
| C-12 | Qt5およびKF5コアライブラリが必要 | **根拠なし**（依存関係未記載） | △ |
| C-13 | kf5-notificationsへの依存がある | **根拠なし**（依存関係未記載） | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド完了までの手順（cookbook_make, cookbook_install等）が記載されていない
  - 候補：他のKF5レシピを参照 / KDE公式ビルドドキュメント
- kf5-notificationsへの依存関係が明示されていない
  - 候補：recipe.tomlのdependenciesセクション追加
- KF5/Qt5依存ライブラリのRedox移植状況が不明
  - 候補：recipes/wip/libs/kf5/配下の各recipe.toml

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: ビルドスクリプトが不完全であり、ビルド自体が成功しない可能性が高い
- **リスク2（高）**: 依存ライブラリ（Qt5, KF5 Core, kf5-notifications）の移植状況が不明
- **リスク1（中）**: WIP状態であり、実際の動作検証ができていない

## 6) レビュアーチェックリスト（最小）
- [ ] ビルドスクリプトにcookbook_make/cookbook_install追加の必要性確認
- [ ] kf5-notificationsへの依存関係の明示
- [ ] Qt5レシピの存在確認と移植状況の把握
- [ ] KF5 Coreライブラリレシピの確認
- [ ] 他のKF5レシピとの整合性確認
