---
generated_at: 2026-01-22 22:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：4-startup-notification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **X11/XCB依存**：Redox OSでのX11互換レイヤーの実装状況
  2. **freedesktop.org仕様準拠の詳細**：プロトコル仕様との整合性
  3. **依存ライブラリの移植状況**：libice, libx11, xcb-utilの状態

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `recipes/wip/x11/startup-notification/recipe.toml`（行1-19）
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv`（行5）
- E-03: freedesktop.org Startup Notification Protocol仕様（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | startup-notificationはX11アプリケーション起動通知ライブラリである | E-01, E-02 | ○ |
| C-02 | ソースはfreedesktop.orgからダウンロードされる | E-01（行2） | ○ |
| C-03 | バージョン0.12を使用 | E-01（行2） | ○ |
| C-04 | blake3でチェックサム検証を行う | E-01（行3） | ○ |
| C-05 | libice、libx11、xcb-utilに依存している | E-01（行10-14） | ○ |
| C-06 | autotoolsビルドシステムを使用 | E-01（行6） | ○ |
| C-07 | template="custom"でカスタムビルドを使用 | E-01（行15） | ○ |
| C-08 | lf_cv_sane_realloc=yesの設定が必要 | E-01（行18） | ○ |
| C-09 | WIP状態である | E-02（備考列） | ○ |
| C-10 | DYNAMIC_INITマクロを使用 | E-01（行6, 17） | ○ |
| C-11 | autotools_recursive_regenerateを実行 | E-01（行7） | ○ |
| C-12 | freedesktop.org Startup Notification Protocol準拠 | **根拠なし**（外部仕様） | △ |
| C-13 | _NET_STARTUP_INFO_BEGINメッセージを使用 | **根拠なし**（外部仕様） | △ |
| C-14 | DESKTOP_STARTUP_ID環境変数で起動IDを伝達 | **根拠なし**（外部仕様） | △ |

## 4) 不足情報（Unknown / Missing）
- freedesktop.org Startup Notification Protocolの詳細仕様
  - 候補：freedesktop.org公式ドキュメント
- libice, libx11, xcb-utilのRedox移植状況
  - 候補：recipes/wip/x11/配下の各recipe.toml
- Redox OSでのX11互換レイヤーの実装状況
  - 候補：Redox OS公式ドキュメント / Orbital関連実装

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: X11/XCB依存であり、Redox OSでの動作にはX11互換レイヤーが必要
- **リスク1（中）**: 依存ライブラリ（libice, libx11, xcb-util）の移植状況が未確認
- **リスク0（低）**: WIP状態だが、レシピの記述は比較的完全

## 6) レビュアーチェックリスト（最小）
- [ ] libiceレシピの存在確認と移植状況の把握
- [ ] libx11レシピの存在確認と移植状況の把握
- [ ] xcb-utilレシピの存在確認と移植状況の把握
- [ ] Redox OSでのX11/Wayland対応状況の確認
- [ ] autotoolsクロスコンパイルの動作確認
