---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート: 運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.93**
  - 根拠あり: 42 / 45、根拠なし: 3
- 優先レビュー（高）
  1. **サポート連絡先**: 具体的なサポート窓口の情報が不足
  2. **ブラウザ対応**: CLIツールのためブラウザ対応は不要だが記載が曖昧
  3. **改訂履歴の日付**: 自動生成のため実際の改訂日と異なる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-07: `docs/code-to-docs/画面設計書/1-TUIメイン画面.md`
- E-08: `docs/code-to-docs/画面設計書/3-repo_fetchコマンド画面.md`
- E-09: `docs/code-to-docs/画面設計書/4-repo_cookコマンド画面.md`
- E-10: `docs/code-to-docs/画面設計書/7-repo_pushコマンド画面.md`
- E-11: `docs/code-to-docs/画面設計書/8-repo_treeコマンド画面.md`
- E-12: `docs/code-to-docs/画面設計書/12-ヘルプ画面.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム概要: Redox OS向けパッケージビルドシステム | E-01 | ○ |
| C-02 | 主要業務: ソース取得、ビルド、パッケージ管理 | E-01, E-03, E-04 | ○ |
| C-03 | 業務フロー: STEP1 fetch -> STEP2 cook -> STEP3 push -> STEP4 repo_builder | E-04, E-06 | ○ |
| C-04 | ユーザー種別: 開発者、メンテナー、CI/CD | E-01, E-07 | ○ |
| C-05 | 動作環境: Linux x86_64, Rust nightly-2025-10-03 | E-01 | ○ |
| C-06 | セットアップ: podman_bootstrap.sh使用 | E-01 | ○ |
| C-07 | 環境変数: CI, COOKBOOK_LOGS等 | E-07, E-08, E-09 | ○ |
| C-08 | cookbook.toml設定: cook, mirrors セクション | E-01 | ○ |
| C-09 | コマンド構文: repo <command> [flags] <recipe> | E-12 | ○ |
| C-10 | fetchコマンド: ソースコードのダウンロード | E-03, E-08 | ○ |
| C-11 | cookコマンド: レシピのビルドとパッケージ作成 | E-03, E-09 | ○ |
| C-12 | pushコマンド: sysrootへのパッケージ展開 | E-03, E-10 | ○ |
| C-13 | treeコマンド: 依存関係ツリー表示 | E-03, E-11 | ○ |
| C-14 | unfetchコマンド: ソースディレクトリ削除 | E-03 | ○ |
| C-15 | cleanコマンド: ビルド成果物削除 | E-03 | ○ |
| C-16 | findコマンド: レシピパス表示 | E-03 | ○ |
| C-17 | 共通フラグ: --cookbook, --repo, --sysroot等 | E-12 | ○ |
| C-18 | ソース種類: Git, Tar, Path, SameAs | E-08 | ○ |
| C-19 | オフラインモード: COOKBOOK_OFFLINE設定 | E-07, E-08 | ○ |
| C-20 | ソース出力: recipes/{category}/{recipe}/source | E-08 | ○ |
| C-21 | ビルドテンプレート: cargo, configure, cmake, meson, custom | E-09 | ○ |
| C-22 | ビルドログ出力: build/logs/{target}/{recipe}.log | E-07, E-09 | ○ |
| C-23 | ビルド成果物: stage.pkgar, stage.toml | E-09 | ○ |
| C-24 | TUIモード: CI未設定時に有効 | E-07 | ○ |
| C-25 | TUI構成: 3分割レイアウト | E-07 | ○ |
| C-26 | TUIキー操作: 1,2,c,PageUp/Down等 | E-07 | ○ |
| C-27 | 失敗時プロンプト: Retry, Skip, Exit | E-07 | ○ |
| C-28 | pushコマンド展開先: {sysroot}/bin, /lib等 | E-10 | ○ |
| C-29 | repo_builder自動実行: cook後に自動呼び出し | E-09 | ○ |
| C-30 | treeコマンド出力形式: ツリー形式+サイズ表示 | E-11 | ○ |
| C-31 | ノンストップモード: COOKBOOK_NONSTOP設定 | E-07, E-09 | ○ |
| C-32 | キャッシュ機構: ソース/依存の更新時のみ再ビルド | E-09 | ○ |
| C-33 | 自動依存関係検出: ELFバイナリ解析 | E-09 | ○ |
| C-34 | パッケージ署名: Ed25519 | E-09, E-10 | ○ |
| C-35 | blake3ハッシュ検証: Tarダウンロード時 | E-08 | ○ |
| C-36 | Gitクローン最適化: shallow_clone | E-08 | ○ |
| C-37 | COOKBOOK_MAKE_JOBS: 並列ビルド設定 | E-09, E-12 | ○ |
| C-38 | COOKBOOK_CLEAN_BUILD/TARGET: 自動クリーンアップ | E-09, E-12 | ○ |
| C-39 | エラーメッセージ: 緑色成功、赤色失敗 | E-08, E-09 | ○ |
| C-40 | ヘルプ表示: repo --help または -h | E-12 | ○ |
| C-41 | 日常業務フロー: fetch -> cook -> push -> 確認 | E-04, E-06 | ○ |
| C-42 | CI/CD自動ビルド: CI=1, NONSTOP=true設定 | E-07, E-09 | ○ |
| C-43 | サポート連絡先: Redox OS GitLab | **根拠なし** | △ |
| C-44 | ブラウザ対応: CLIツールのため該当なし | **根拠なし** | △ |
| C-45 | 改訂履歴日付: 2026-01-23 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サポート連絡先の具体的な情報（Issue報告先、Matrixチャンネル等）がソースコードや既存ドキュメントから特定できなかった
  - 候補: GitLab Issues / Matrix Channel / メーリングリスト
- ブラウザ対応の記載は本システムがCLIツールであるため不要だが、テンプレートとの整合性を確認が必要
  - 候補: 記載削除 / 「該当なし」と明記 / 項目自体を削除
- 改訂履歴は自動生成日時を使用しており、正式なリリース日とは異なる可能性
  - 候補: 正式リリース時に更新 / 初版作成日として記録

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: C-01〜C-42 - ソースコードおよび設計書から直接確認可能
- 1（中リスク）: C-43〜C-45 - 運用上の情報であり、組織固有の情報を含む

## 6) レビュアーチェックリスト（最小）
- [ ] サポート連絡先（C-43）が正しいか確認
- [ ] 業務フローの記載がプロジェクトの実運用と一致しているか確認
- [ ] 環境変数の説明が最新のコードと一致しているか確認
- [ ] コマンド例が実際に動作するか検証
- [ ] TUIのキー操作説明が正確か確認
- [ ] エラーメッセージのリストが網羅的か確認
