# Redox OS Build System 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [環境設定と起動](#2-環境設定と起動)
3. [コマンド体系](#3-コマンド体系)

**【業務フローに沿った機能】**
4. [【STEP1】ソースコード取得（fetch）](#4-step1ソースコード取得fetch)
5. [【STEP2】パッケージビルド（cook）](#5-step2パッケージビルドcook)
6. [【STEP3】パッケージ展開（push）](#6-step3パッケージ展開push)
7. [【STEP4-5】リポジトリ公開と確認](#7-step4-5リポジトリ公開と確認)

**【サポート機能】**
8. [依存関係の確認（tree）](#8-依存関係の確認tree)
9. [クリーンアップ機能](#9-クリーンアップ機能)
10. [TUIモードの操作](#10-tuiモードの操作)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Redox OS Build Systemとは

Redox OS Build System（cookbook）は、Redox OS向けのパッケージビルドシステムです。各種ソフトウェアのソースコードを取得し、Redox OS向けにクロスコンパイルを行い、pkgar形式のパッケージを生成します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します:

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ソース取得** | Gitリポジトリ、Tarアーカイブからのソースダウンロード、パッチ適用 |
| **パッケージビルド** | Cargo/Configure/CMake/Meson/Customテンプレートでのビルド実行 |
| **パッケージ管理** | pkgarアーカイブの作成、署名、リポジトリへの公開 |
| **依存関係管理** | ビルド依存関係の解決、自動依存関係検出、sysroot構築 |
| **進捗監視** | TUIによる並列ビルドの可視化、ログ管理 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します:

```
+-------------------------------------------------------------------+
|                        業務フロー                                  |
+-------------------------------------------------------------------+
|                                                                   |
|  【STEP 1】ソースコード取得（fetch）                               |
|      - Gitリポジトリのクローン、Tarアーカイブのダウンロード          |
|      - パッチファイルの適用                                        |
|      |                                                            |
|      v                                                            |
|  【STEP 2】パッケージビルド（cook）                                 |
|      - 依存関係の解決、sysroot/toolchainの構築                     |
|      - ビルドスクリプトの実行、パッケージング                       |
|      |                                                            |
|      v                                                            |
|  【STEP 3】パッケージ展開（push）                                   |
|      - sysrootへのパッケージ展開                                   |
|      - 動作確認、テスト                                            |
|      |                                                            |
|      v                                                            |
|  【STEP 4】リポジトリ公開（repo_builder）                           |
|      - パッケージのリポジトリへの配置                               |
|      - repo.tomlの生成                                            |
|      |                                                            |
|      v                                                            |
|  【STEP 5】確認・クリーンアップ                                     |
|      - 依存関係ツリーの確認                                        |
|      - 不要なソース/ビルド成果物の削除                              |
|                                                                   |
+-------------------------------------------------------------------+
```

**役割別の業務概要:**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | レシピの作成、パッケージのビルド・テスト、リポジトリへの公開 |
| **メンテナー** | 依存関係の管理、ビルド失敗時の対応、リポジトリの保守 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| fetch | ソースコードの取得、パッチ適用 | STEP 1 |
| cook | ビルド実行、パッケージ作成 | STEP 2 |
| push | sysrootへのパッケージ展開 | STEP 3 |
| repo_builder | リポジトリへの公開 | STEP 4 |
| tree | 依存関係ツリーの表示 | STEP 5（確認） |
| clean/unfetch | 成果物・ソースの削除 | STEP 5（クリーンアップ） |
| find | レシピパスの検索 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります:

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者 | パッケージのビルドとテストを行う |
| メンテナー | リポジトリの管理とビルドシステムの保守を行う |
| CI/CD | 自動ビルドパイプラインでの利用（CLIモード） |

### 1.6 動作環境

**対応プラットフォーム:**
- Linux（x86_64推奨）
- Podmanコンテナ環境（推奨）

**必要なツール:**
- Rust nightly-2025-10-03
- curl
- Podman（コンテナビルド時）

---

## 2. 環境設定と起動

### 2.1 初期セットアップ（Podmanビルド推奨）

1. ブートストラップスクリプトをダウンロードします

```bash
curl -sf https://gitlab.redox-os.org/redox-os/redox/raw/master/podman_bootstrap.sh -o podman_bootstrap.sh
```

2. セットアップを実行します

```bash
time bash -e podman_bootstrap.sh
```

### 2.2 ネイティブビルド環境

Podmanを使用しない場合は、以下を実行します:

```bash
bash native_bootstrap.sh
```

### 2.3 環境変数の設定

ビルド動作をカスタマイズするための環境変数:

| 変数名 | デフォルト | 説明 |
|--------|----------|------|
| CI | 未設定 | 設定するとTUIを無効化してCLIモードで動作 |
| COOKBOOK_LOGS | !CI | ビルドログをファイルに保存するか |
| COOKBOOK_OFFLINE | false | オフラインモード（fetchでは無視される） |
| COOKBOOK_NONSTOP | false | ビルドエラー時も継続するか |
| COOKBOOK_VERBOSE | true | 成功/失敗メッセージを表示するか |
| COOKBOOK_CLEAN_BUILD | false | ビルド前にbuildディレクトリを削除 |
| COOKBOOK_CLEAN_TARGET | false | ビルド後にtargetディレクトリを削除 |
| COOKBOOK_MAKE_JOBS | nproc | 並列ビルドジョブ数 |

### 2.4 cookbook.tomlの設定

プロジェクトルートの`cookbook.toml`で追加設定が可能です:

```toml
[cook]
offline = false      # オフラインモード
jobs = 8             # 並列ジョブ数
tui = true           # TUI表示
logs = true          # ログ出力
nonstop = false      # エラーを無視して継続
verbose = true       # 詳細ログ

[mirrors]
"ftp.gnu.org/gnu" = "mirrors.ocf.berkeley.edu/gnu"
```

---

## 3. コマンド体系

### 3.1 基本コマンド構文

```
repo <command> [flags] <recipe1> <recipe2> ...
```

### 3.2 コマンド一覧

| コマンド | 説明 |
|---------|------|
| fetch | レシピのソースコードをダウンロード |
| cook | レシピをビルドしてパッケージを作成 |
| unfetch | レシピのソースディレクトリを削除 |
| clean | レシピのビルド成果物を削除 |
| push | パッケージをsysrootに展開 |
| find | レシピのパスを表示 |
| tree | 依存関係ツリーを表示 |

### 3.3 共通フラグ

| フラグ | 説明 |
|-------|------|
| --cookbook=<path> | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --repo=<path> | repoフォルダのパス（デフォルト: $PWD/repo） |
| --sysroot=<path> | pushコマンドのインストール先 |
| --with-package-deps | パッケージ依存関係を含める |
| --all | 全レシピを対象 |
| --category=<category> | 指定カテゴリ内の全レシピを対象 |
| --filesystem=<path> | インストーラファイルでレシピ設定を上書き |
| --repo-binary | バイナリパッケージを使用 |

### 3.4 ヘルプの表示

```bash
repo --help
repo -h
```

---

## 4. 【STEP1】ソースコード取得（fetch）

> **業務フローでの位置**: ソースコードの取得はビルドの最初のステップです。Git、Tar、ローカルパスなど様々なソースから取得できます。

### 4.1 基本的なソース取得

**やるべきこと:**
- ビルドしたいパッケージのソースコードを取得する
- 必要なパッチが自動的に適用される

**操作手順:**

1. ターミナルを開きます
2. プロジェクトルートに移動します
3. 以下のコマンドを実行します:

```bash
repo fetch <レシピ名>
```

**例:**
```bash
repo fetch vim              # vimのソースを取得
repo fetch vim nano git     # 複数レシピを同時に取得
repo fetch --category=core  # coreカテゴリの全レシピを取得
```

### 4.2 ソース取得の種類

| ソースタイプ | 説明 | recipe.tomlでの指定 |
|-------------|------|-------------------|
| Git | Gitリポジトリからクローン | `[source.git]` |
| Tar | Tarアーカイブをダウンロード | `[source.tar]` |
| Path | ローカルパスからコピー | `[source.path]` |
| SameAs | 別レシピのソースを参照 | `same_as = "other"` |

### 4.3 オフラインモードでの取得

ネットワークアクセスなしでビルドする場合:

```bash
COOKBOOK_OFFLINE=true repo cook <レシピ名>
```

**注意:** fetchコマンドではCOOKBOOK_OFFLINEは無視され、常にネットワークアクセスを試行します。

### 4.4 関連する出力

| 出力 | パス |
|------|------|
| ソースディレクトリ | recipes/{category}/{recipe}/source |
| Tarアーカイブ | recipes/{category}/{recipe}/source.tar |

---

## 5. 【STEP2】パッケージビルド（cook）

> **業務フローでの位置**: ソース取得後、ビルドを実行してpkgar形式のパッケージを生成します。

### 5.1 基本的なビルド

**やるべきこと:**
- レシピをビルドしてインストール可能なパッケージを作成する
- 依存関係は自動的に解決される

**操作手順:**

1. ターミナルを開きます
2. 以下のコマンドを実行します:

```bash
repo cook <レシピ名>
```

**例:**
```bash
repo cook vim                         # vimをビルド
repo cook vim nano git                # 複数レシピをビルド
repo cook --with-package-deps vim     # 依存関係も含めてビルド
```

### 5.2 TUIモードとCLIモード

**TUIモード（デフォルト）:**
- 環境変数`CI`が未設定の場合に有効
- 3分割画面でビルド進捗を可視化
- キーボードで操作可能

**CLIモード:**
- `CI=1`を設定するとTUIを無効化
- 自動ビルド環境に適している

```bash
CI=1 repo cook vim  # CLIモードでビルド
```

### 5.3 ビルドテンプレート

recipe.tomlで指定するビルドテンプレート:

| テンプレート | 用途 |
|-------------|------|
| cargo | Rustプロジェクト |
| configure | autotoolsプロジェクト |
| cmake | CMakeプロジェクト |
| meson | Mesonプロジェクト |
| custom | カスタムスクリプト |

### 5.4 ビルドログの確認

ビルドログは以下に保存されます:

```
build/logs/{target}/{recipe}.log
```

### 5.5 関連する出力

| 出力 | パス |
|------|------|
| ステージディレクトリ | recipes/{category}/{recipe}/target/{target}/stage |
| pkgarファイル | recipes/{category}/{recipe}/target/{target}/stage.pkgar |
| メタデータ | recipes/{category}/{recipe}/target/{target}/stage.toml |

---

## 6. 【STEP3】パッケージ展開（push）

> **業務フローでの位置**: ビルドしたパッケージをsysrootに展開し、動作確認を行います。

### 6.1 基本的な展開

**やるべきこと:**
- ビルド済みパッケージをテスト環境に展開する
- 依存関係も含めて展開する場合がある

**操作手順:**

1. ターミナルを開きます
2. 以下のコマンドを実行します:

```bash
repo push <レシピ名>
```

**例:**
```bash
repo push vim                         # vimを展開
repo push --with-package-deps vim     # 依存関係も含めて展開
repo push --sysroot=/path/to/test vim # 展開先を指定
```

### 6.2 展開先ディレクトリ

| パス | 説明 |
|------|------|
| {sysroot}/bin | 実行ファイル |
| {sysroot}/lib | ライブラリ |
| {sysroot}/usr/bin | ユーザー実行ファイル |
| {sysroot}/usr/lib | ユーザーライブラリ |
| {sysroot}/usr/include | ヘッダファイル |

### 6.3 展開結果の確認

展開完了時にサマリーが表示されます:

```
Pushed 4.03 MiB of 4 packages
```

---

## 7. 【STEP4-5】リポジトリ公開と確認

> **業務フローでの位置**: ビルドしたパッケージをリポジトリに公開し、他の開発者が利用できるようにします。

### 7.1 リポジトリへの公開

`repo cook`コマンドは、ビルド完了後に自動的に`repo_builder`を呼び出してリポジトリを更新します。

**自動的に行われる処理:**
1. パッケージをリポジトリディレクトリにコピー
2. repo.tomlの生成（パッケージ一覧）
3. AppStreamカタログの生成（オプション）

### 7.2 リポジトリ構造

```
repo/
  {target}/
    {package}.pkgar      # パッケージアーカイブ
    {package}.toml       # パッケージメタデータ
    repo.toml            # リポジトリインデックス
```

### 7.3 依存関係の確認

リポジトリ公開前に依存関係を確認:

```bash
repo tree vim
```

**出力例:**
```
+-- vim [1.23 MiB]
|   +-- ncurses [0.50 MiB]
|   +-- libiconv [0.30 MiB]
+-- (total) 2.03 MiB of 3 packages
```

---

## 8. 依存関係の確認（tree）

### 8.1 依存関係ツリーの表示

**やるべきこと:**
- パッケージの依存関係を視覚的に確認する
- イメージサイズを見積もる

**操作手順:**

```bash
repo tree <レシピ名>
```

**出力の見方:**

| 表示 | 意味 |
|------|------|
| [X.XX MiB] | ビルド済みパッケージのサイズ |
| (not built) | パッケージが未ビルド |
| (dependency info missing) | 依存情報が見つからない |

### 8.2 複数パッケージの確認

```bash
repo tree vim nano git
```

---

## 9. クリーンアップ機能

### 9.1 ソースディレクトリの削除（unfetch）

ダウンロードしたソースコードを削除:

```bash
repo unfetch vim              # vimのソースを削除
repo unfetch --all            # 全ソースを削除
repo unfetch --category=core  # coreカテゴリのソースを削除
```

### 9.2 ビルド成果物の削除（clean）

ビルドの中間ファイルを削除:

```bash
repo clean vim              # vimのtargetを削除
repo clean --all            # 全targetを削除
repo clean --category=core  # coreカテゴリのtargetを削除
```

### 9.3 環境変数による自動クリーンアップ

| 変数 | 説明 |
|------|------|
| COOKBOOK_CLEAN_BUILD=true | ビルド前にbuildディレクトリを削除 |
| COOKBOOK_CLEAN_TARGET=true | ビルド後にtargetディレクトリを削除 |

---

## 10. TUIモードの操作

### 10.1 TUI画面構成

TUIは3分割レイアウトで構成されています:

| パネル | 位置 | 内容 |
|--------|------|------|
| Fetch Queue | 左 | ソース取得の進捗 |
| Cook Queue | 中央 | ビルドの進捗 |
| Log | 右 | 現在のログ出力 |

### 10.2 キーボード操作

| キー | 操作 |
|------|------|
| 1 | Fetch Logを表示 |
| 2 | Cook Logを表示 |
| c | ビルドを停止 |
| PageUp | ログを20行上にスクロール |
| PageDown | ログを20行下にスクロール |
| Up/Down | ログを1行スクロール |
| End | ログ末尾を追従 |
| Home | ログ先頭に移動 |

### 10.3 失敗時の操作

ビルドが失敗すると、プロンプトダイアログが表示されます:

| 選択肢 | 動作 |
|--------|------|
| Retry | 失敗したレシピを再試行 |
| Skip | スキップして次のレシピへ |
| Exit | ビルドを終了 |

**ノンストップモード:**
`COOKBOOK_NONSTOP=true`を設定すると、失敗時に自動的にスキップします。

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
=========================================================
【STEP 1】ソースコード取得（fetch） -> 4章参照
    |
【STEP 2】パッケージビルド（cook） -> 5章参照
    |
【STEP 3】パッケージ展開・テスト（push） -> 6章参照
    |
【STEP 4】リポジトリ公開 -> 7章参照
    |
【STEP 5】確認・クリーンアップ -> 7-9章参照
=========================================================
```

### 11.1 【開発者】新規パッケージのビルド

新しいパッケージをビルドする場合の手順:

1. **レシピの作成**: recipes/{category}/{name}/recipe.toml を作成
2. **ソース取得**: `repo fetch {name}`
3. **ビルド**: `repo cook {name}`
4. **テスト**: `repo push {name}` でsysrootに展開してテスト
5. **確認**: `repo tree {name}` で依存関係を確認

### 11.2 【開発者】既存パッケージの更新

パッケージを更新する場合:

1. **クリーン**: `repo clean {name}` で古いビルドを削除
2. **unfetch**: `repo unfetch {name}` で古いソースを削除（必要に応じて）
3. **fetch**: `repo fetch {name}` で新しいソースを取得
4. **cook**: `repo cook {name}` で再ビルド
5. **テスト**: `repo push {name}` でテスト

### 11.3 【CI/CD】自動ビルド

CI環境での一括ビルド:

```bash
export CI=1
export COOKBOOK_NONSTOP=true
export COOKBOOK_LOGS=true

repo cook --filesystem=config/desktop.toml
```

### 11.4 【メンテナー】リポジトリの保守

定期的なメンテナンス作業:

1. **依存関係の確認**: `repo tree --all` で全体の依存関係を確認
2. **不要ファイルの削除**: `repo clean --all` で不要なビルド成果物を削除
3. **リポジトリの整合性確認**: repo.tomlの内容を確認

---

## 12. よくある質問と対処法

### 12.1 ビルドに関するQ&A

**Q: ビルドがキャッシュを使用しているか確認したい**

A: `COOKBOOK_VERBOSE=true`を設定すると、以下のようなメッセージが表示されます:
- "DEBUG: using cached build" - キャッシュを使用
- "DEBUG: updating '{path}'" - 再ビルドを実行

**Q: 強制的に再ビルドしたい**

A: 以下のいずれかを実行:
```bash
repo clean {name}    # targetディレクトリを削除
COOKBOOK_CLEAN_BUILD=true repo cook {name}  # buildを削除して再ビルド
```

**Q: ビルドを並列化したい**

A: 環境変数で設定:
```bash
COOKBOOK_MAKE_JOBS=8 repo cook {name}
```

### 12.2 ソース取得に関するQ&A

**Q: blake3ハッシュエラーが出る**

A: ダウンロードしたファイルが破損しているか、recipe.tomlのハッシュ値が古い可能性があります:
```bash
repo unfetch {name}  # ソースを削除
repo fetch {name}    # 再ダウンロード
```

**Q: Gitリポジトリのクローンが遅い**

A: recipe.tomlで`shallow_clone = true`を設定すると高速化できます。

### 12.3 TUIに関するQ&A

**Q: TUIを無効化したい**

A: 環境変数を設定:
```bash
CI=1 repo cook {name}
```

**Q: TUIでログが見えない**

A: 「1」キーでFetch Log、「2」キーでCook Logに切り替えられます。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "fetch {name} - failed" | ソース取得に失敗 | ネットワーク接続を確認、URLが正しいか確認 |
| "cook {name} - failed" | ビルドに失敗 | build/logs/{target}/{name}.logを確認 |
| "Package {name} has not been built" | パッケージが未ビルド | `repo cook {name}`でビルド |
| "The downloaded tar blake3 is not equal" | ハッシュ不一致 | recipe.tomlのblake3を更新 |
| "Infinite loop detected" | same_as参照のループ | レシピのsame_as設定を確認 |

### 13.2 よくあるトラブルと解決方法

**ビルドが途中で止まる**

1. ログを確認: `cat build/logs/{target}/{name}.log`
2. 依存関係を確認: `repo tree {name}`
3. クリーンビルドを試行:
   ```bash
   repo clean {name}
   repo unfetch {name}
   repo cook {name}
   ```

**TUIがフリーズする**

1. 「c」キーでビルドを停止
2. Ctrl+Cで強制終了
3. CLIモードで再試行: `CI=1 repo cook {name}`

**ディスク容量不足**

1. 不要なソースを削除: `repo unfetch --all`
2. 不要なビルド成果物を削除: `repo clean --all`
3. 自動クリーンアップを有効化: `COOKBOOK_CLEAN_TARGET=true`

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の情報を添えて報告してください:

1. 実行したコマンド
2. エラーメッセージの全文
3. ビルドログ（build/logs/{target}/{name}.log）
4. 環境情報（OS、Rustバージョン等）

**報告先:**
- Redox OS GitLab: https://gitlab.redox-os.org/redox-os/redox

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-23 | 初版作成 |

---

*本マニュアルは、Redox OS Build System（cookbook）のエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、コマンドや操作方法が変更される場合があります。*
