---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **NFT-STRESS-002**：24時間連続ビルドの具体的なメモリ監視手段が不明
  2. **NFT-STRESS-003**：ディスク容量不足時の具体的エラーメッセージ未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/lib.rs` - WALK_DEPTH定数、is_redox()関数
- E-02: `src/config.rs` - CookConfig構造体、init_config()関数、translate_mirror()関数
- E-03: `src/cook/cook_build.rs` - build()関数、auto_deps_from_dynamic_linking()関数、build_deps_dir()関数
- E-04: `src/cook/fetch.rs` - fetch()関数、fetch_offline()関数、get_blake3()関数
- E-05: `src/cook/package.rs` - package()関数、package_toml()関数
- E-06: `src/cook/pty.rs` - setup_pty()関数、PtyFd構造体、TICK_RATE定数
- E-07: `src/cook/fs.rs` - run_command()関数、rename()関数、serialize_and_write()関数
- E-08: `src/recipe.rs` - Recipe構造体、BuildKind enum、CookRecipe構造体
- E-09: `src/bin/repo.rs` - TuiApp構造体、CliCommand enum、REPO_HELP_STR定数
- E-10: `Cargo.toml` - 依存関係定義（pkgar、pkgar-keys、ratatui等）
- E-11: `config/` - 各アーキテクチャ用設定ファイル群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | COOKBOOK_MAKE_JOBSで並列度調整可能 | E-02 (config.rs L84-89) | ○ |
| C-02 | TICK_RATE=100msで描画更新 | E-09 (repo.rs L1021) | ○ |
| C-03 | フェッチとクックは別スレッドで並列実行 | E-09 (repo.rs L1023-1218) | ○ |
| C-04 | WALK_DEPTH=16の再帰制限 | E-01 (lib.rs L9) | ○ |
| C-05 | ログはVec<String>でメモリ保持 | E-09 (repo.rs L819) | ○ |
| C-06 | COOKBOOK_MAKE_JOBS=nproc()がデフォルト | E-02 (config.rs L84-89) | ○ |
| C-07 | pkg::recipes::list()使用 | E-09 (repo.rs L459) | ○ |
| C-08 | mpsc::channelによるスレッド間通信 | E-09 (repo.rs L1016-1017) | ○ |
| C-09 | fetch_offline()関数でオフライン対応 | E-04 (fetch.rs L37-115) | ○ |
| C-10 | KILL_ALL_PIDスクリプトで子プロセス終了 | E-09 (repo.rs L1599-1608) | ○ |
| C-11 | handle_nonstop_fail()で後続処理継続 | E-09 (repo.rs L609-617) | ○ |
| C-12 | translate_mirror()関数でミラー切り替え | E-02 (config.rs L135-167) | ○ |
| C-13 | pkgar-keys::PublicKeyFile使用 | E-03 (cook_build.rs L116-119) | ○ |
| C-14 | get_blake3()関数でハッシュ検証 | E-04 (fetch.rs L21-35) | ○ |
| C-15 | command.env()で明示的環境変数設定 | E-03 (cook_build.rs L393-414) | ○ |
| C-16 | PackageName::new()で入力検証 | E-08 (recipe.rs), E-10 (Cargo.toml pkg依存) | ○ |
| C-17 | visited集合による重複検出 | E-03 (cook_build.rs L56-61) | ○ |
| C-18 | fs::renameによるアトミック操作 | E-07 (fs.rs L192-202) | ○ |
| C-19 | stage_modified比較で自動更新 | E-03 (cook_build.rs L583-610) | ○ |
| C-20 | キャッシュ有効時のスキップ処理 | E-03 (cook_build.rs L221-227) | ○ |
| C-21 | map_err()で詳細情報付与 | E-07 (fs.rs全体) | ○ |
| C-22 | init_config()で設定解析 | E-02 (config.rs L68-121) | ○ |
| C-23 | write_log()関数でログ永続化 | E-09 (repo.rs L909-918) | ○ |
| C-24 | DEBUGプレフィックス付きメッセージ | E-03 (cook_build.rs L223, L263等) | ○ |
| C-25 | remove_all()関数でクリーンアップ | E-07 (fs.rs L18-25), E-03 (cook_build.rs L451-457) | ○ |
| C-26 | REPO_HELP_STRの内容表示 | E-09 (repo.rs L42-75, L185-188) | ○ |
| C-27 | CliCommand::from_str()でエラー | E-09 (repo.rs L116-131) | ○ |
| C-28 | RecipeStatus enumで状態管理 | E-09 (repo.rs L772-780) | ○ |
| C-29 | kill_everything()関数 | E-09 (repo.rs L1599-1608) | ○ |
| C-30 | process::exit(1)使用 | E-09 (repo.rs L177-180) | ○ |
| C-31 | is_redox()によるプラットフォーム判定 | E-01 (lib.rs L14-16) | ○ |
| C-32 | config/{arch}/ディレクトリ | E-11 (config/x86_64, aarch64, i586, riscv64gc) | ○ |
| C-33 | BuildKind enumの全種類 | E-08 (recipe.rs L90-128) | ○ |
| C-34 | object::build::elf::Builderで解析 | E-03 (cook_build.rs L84-107) | ○ |
| C-35 | categoryフラグ使用 | E-09 (repo.rs L56, L458-464) | ○ |
| C-36 | メモリリーク検出（長時間テスト） | **根拠なし** | △ |
| C-37 | ディスク容量不足時エラーメッセージ | **根拠なし** | △ |
| C-38 | 1024バイトバッファで処理 | E-09 (repo.rs L1717) | ○ |
| C-39 | EIOをEOFとして扱い | E-06 (pty.rs L186-198) | ○ |
| C-40 | build_deps_dir()でキャッシュ | E-03 (cook_build.rs L511-572) | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-STRESS-002（長時間テスト）**：コード上でメモリリーク監視の仕組みは見当たらない。外部ツール（Valgrind等）またはCI環境での長時間監視が必要。
  - 候補：CI設定ファイル / 外部監視ツール設定 / メモリプロファイラ設定
- **NFT-STRESS-003（ディスク容量不足）**：fs::write等のエラーハンドリングは存在するが、ディスク容量不足固有のエラーメッセージは未確認。
  - 候補：追加のエラーハンドリングテスト / シミュレーション環境構築

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：大部分のテストケースはソースコード上で明確な根拠あり
- **1（中リスク）**：ストレステスト関連（NFT-STRESS-002, NFT-STRESS-003）は実行環境依存のため、テスト環境構築が必要
- **0（低リスク）**：セキュリティ関連テストケースはpkgar-keys等の既存ライブラリに依存しており、実装が確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テストの合格基準値（時間、メモリ等）が実運用環境に適切か確認
- [ ] セキュリティテスト（NFT-SEC-001〜005）の検証手順が十分か確認
- [ ] クロスコンパイル対応（NFT-COMPAT-002）のテスト対象アーキテクチャが網羅されているか確認
- [ ] ストレステストの実行環境（CI/ローカル）の準備状況を確認
- [ ] TUIモード関連テストの手動確認手順が明確か確認
