---
generated_at: 2026-01-23 16:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **レスポンスタイム目標値**：具体的な数値目標の根拠なし
  2. **依存関係解決の目標時間**：推定値のため要確認
  3. **障害復旧時間（RTO）/目標復旧時点（RPO）**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/lib.rs` - WALK_DEPTH定数、REMOTE_PKG_SOURCE定数
- E-02: `src/config.rs` - CookConfig構造体、環境変数設定
- E-03: `Cargo.toml` - プロジェクト依存関係、Edition設定
- E-04: `config/base.toml` - ベース設定、セキュリティスキーム、ユーザー設定
- E-05: `config/server.toml` - サーバー構成、ファイルシステムサイズ
- E-06: `config/desktop.toml` - デスクトップ構成、ファイルシステムサイズ
- E-07: `config/net.toml` - ネットワーク設定
- E-08: `mk/config.mk` - ビルド設定、環境変数定義
- E-09: `mk/qemu.mk` - QEMU設定、エミュレーションパラメータ
- E-10: `mk/podman.mk` - Podman設定、コンテナ設定
- E-11: `mk/ci.mk` - CI/CD設定
- E-12: `.gitlab-ci.yml` - GitLab CI設定
- E-13: `src/recipe.rs` - レシピ解析、ビルドテンプレート定義
- E-14: `build.sh` - アーキテクチャサポート
- E-15: `Makefile` - ビルドターゲット、デバッグ設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 再帰深度制限16レベル（WALK_DEPTH） | E-01 | ○ |
| C-02 | 並列ビルドジョブ数はCPUコア数自動検出 | E-02 | ○ |
| C-03 | COOKBOOK_MAKE_JOBSで上書き可能 | E-02 | ○ |
| C-04 | TUI有効時に並列ビルド可能 | E-02 | ○ |
| C-05 | オフラインビルド対応（COOKBOOK_OFFLINE） | E-02, E-08 | ○ |
| C-06 | エラー時継続（COOKBOOK_NONSTOP） | E-02, E-08 | ○ |
| C-07 | Podmanコンテナ内ビルド対応 | E-08, E-10 | ○ |
| C-08 | SYS_ADMINケーパビリティ付与 | E-10 | ○ |
| C-09 | SELinux対応（:Zボリュームフラグ） | E-10 | ○ |
| C-10 | ディスク暗号化オプション対応 | E-08 | ○ |
| C-11 | BLAKE3ハッシュ検証 | E-13 | ○ |
| C-12 | login_schemes.tomlでアクセス制御 | E-04 | ○ |
| C-13 | rootユーザーデフォルトパスワード | E-04 | ○ |
| C-14 | x86_64アーキテクチャ対応 | E-08, E-09, E-14 | ○ |
| C-15 | aarch64アーキテクチャ対応 | E-08, E-09, E-14 | ○ |
| C-16 | i586アーキテクチャ対応 | E-08, E-09, E-14 | ○ |
| C-17 | riscv64gcアーキテクチャ対応 | E-08, E-09, E-14 | ○ |
| C-18 | 設定ファイル継承機能（include） | E-04, E-05, E-06, E-07 | ○ |
| C-19 | ビルドテンプレート6種類 | E-13 | ○ |
| C-20 | Rust Edition 2024使用 | E-03 | ○ |
| C-21 | rustfmtによる自動整形 | E-12 | ○ |
| C-22 | ビルドログ出力（COOKBOOK_LOGS） | E-02 | ○ |
| C-23 | sccache対応 | E-08, E-10 | ○ |
| C-24 | SHA256SUMによるチェックサム検証 | E-11 | ○ |
| C-25 | QEMU SMPアーキテクチャ依存 | E-09 | ○ |
| C-26 | QEMUメモリ設定 | E-09 | ○ |
| C-27 | GDBリモートデバッグ対応 | E-15 | ○ |
| C-28 | ポート転送設定（SSH, HTTP等） | E-09 | ○ |
| C-29 | ミラーサーバー設定 | E-02 | ○ |
| C-30 | リモートパッケージソースURL | E-01 | ○ |
| C-31 | ビルドタスク開始5秒以内 | **根拠なし** | △ |
| C-32 | 設定ファイル解析1秒以内 | **根拠なし** | △ |
| C-33 | 依存関係解決10秒以内 | **根拠なし** | △ |
| C-34 | 障害復旧時間（RTO） | **根拠なし** | △ |
| C-35 | 目標復旧時点（RPO） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **レスポンスタイム目標値**: コードベースに具体的な時間目標の定義なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / ベンチマーク結果
- **可用性SLA**: 稼働率やRTO/RPOの明示的な定義なし
  - 候補：運用マニュアル / SLA文書 / 障害対応手順書
- **キャッシュ有効期限**: sccacheの詳細設定
  - 候補：sccache設定ファイル / 環境変数設定

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - セキュリティ: rootユーザーのデフォルトパスワードが平文で設定されている（本番環境では変更必須）
- **1: 中リスク** - 可用性: 明示的な障害復旧手順やRTO/RPOが未定義
- **0: 低リスク** - パフォーマンス: レスポンスタイム目標が推定値のため、実測に基づく検証が望ましい
- **0: 低リスク** - 拡張性: 新アーキテクチャ追加時の手順が暗黙的

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンスタイム目標値の妥当性を確認（実測値との比較）
- [ ] rootユーザーのデフォルトパスワード運用方針を確認
- [ ] 本番環境でのRTO/RPO要件を明確化
- [ ] 各アーキテクチャのQEMU設定値の妥当性確認
- [ ] sccacheキャッシュサイズ・有効期限の運用方針確認
- [ ] SELinux無効環境での動作検証
