# 非機能要件定義書

## 概要

本ドキュメントは、Redox OSビルドシステム（redox_cookbook）の非機能要件を定義するものです。Redox OSはRust言語で書かれたマイクロカーネルアーキテクチャのオープンソースオペレーティングシステムであり、本ビルドシステムはそのコンパイル・パッケージング・イメージ生成を担当します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| ビルドタスク開始 | 5秒以内 | レシピ解析からビルド開始まで |
| 設定ファイル解析 | 1秒以内 | TOMLパース処理 |
| 依存関係解決 | 10秒以内 | 再帰深度制限: 16レベル（WALK_DEPTH） |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 並列ビルドジョブ数 | システムのCPUコア数 | `std::thread::available_parallelism()`で自動検出、環境変数`COOKBOOK_MAKE_JOBS`で上書き可能 |
| 同時パッケージビルド数 | TUI有効時: 並列可能 | `COOKBOOK_TUI`設定で制御 |
| リモートパッケージ取得 | ミラーサーバー経由 | `ftp.gnu.org/gnu`は`mirrors.ocf.berkeley.edu/gnu`へリダイレクト |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| オフラインビルド対応 | 可能 | `COOKBOOK_OFFLINE=true`で有効化 |
| ビルド継続性 | 設定可能 | `COOKBOOK_NONSTOP=true`でエラー時も継続 |
| 障害復旧 | 手動クリーン後再ビルド | `make clean`または`make distclean`で復旧 |
| コンテナ隔離 | Podman対応 | `PODMAN_BUILD=1`でコンテナ内ビルド |

## セキュリティ要件

### 認証・認可

- **コンテナ分離**: Podmanによるビルド環境の隔離
  - `SYS_ADMIN`ケーパビリティ付与（FUSE利用のため）
  - `/dev/fuse`デバイスアクセス許可
  - SELinux対応（`:Z`ボリュームフラグ）

### 暗号化

- **ディスク暗号化**: `REDOXFS_MKFS_FLAGS`に`--encrypt`オプションで有効化可能
- **パッケージ署名**: pkgarによるBLAKE3ハッシュ検証
  - ソースtarballの`blake3`フィールドでチェックサム検証

### アクセス制御

- **ユーザー権限制御**: Redox OS内の`login_schemes.toml`でスキーム単位のアクセス制御
  - rootユーザー: 全スキーム（`*`）へのアクセス許可
  - 一般ユーザー: 特定スキームのみアクセス可能（kernel、base、network、IPC、file、display等）

### パスワードポリシー

- **デフォルトパスワード**: rootユーザーのデフォルトパスワードは`password`（base.toml）
- **一般ユーザー**: パスワード未設定（空文字列）

## 拡張性要件

### マルチアーキテクチャ対応

| アーキテクチャ | サポート状況 | 備考 |
| --- | --- | --- |
| x86_64 | 完全対応 | プライマリターゲット |
| aarch64 | 完全対応 | ARM64サポート |
| i586 | 完全対応 | レガシー32bit |
| riscv64gc | 完全対応 | RISC-Vサポート |

### 設定拡張性

- **設定ファイル継承**: `include`ディレクティブによる設定ファイルの階層化
  - 例: `desktop.toml` → `server.toml` → `net.toml` → `base.toml`
- **パッケージ設定ルール**: source/local/binary/ignoreの4種類
- **ミラー設定**: `cookbook.toml`でカスタムミラー定義可能

### ビルドテンプレート

| テンプレート | 説明 |
| --- | --- |
| none | メタパッケージ用（ビルドなし） |
| remote | リモートからバイナリ取得 |
| cargo | Rustプロジェクト（Cargo使用） |
| configure | autotools系プロジェクト |
| cmake | CMakeプロジェクト |
| meson | Mesonプロジェクト |
| custom | カスタムスクリプト |

## 保守性要件

### コード品質

- **言語**: Rust（Edition 2024）
- **コードフォーマット**: `rustfmt`による自動整形
- **CI/CDリント**: GitLab CIで`cargo fmt -- --check`実行

### ログ管理

- **ビルドログ**: `COOKBOOK_LOGS=true`で`build/logs`ディレクトリに出力
- **詳細ログ**: `COOKBOOK_VERBOSE=true`で詳細出力有効化
- **ネットワークキャプチャ**: `$(BUILD)/network.pcap`にパケットダンプ

### ビルドキャッシュ

- **sccache対応**: `SCCACHE_BUILD=1`でCargoビルドキャッシュ有効化
  - Podman内実行時はデフォルト有効
- **バイナリプレフィックス**: `PREFIX_BINARY=1`で事前コンパイル済みツールチェーン使用

## 運用・監視要件

### ビルドステータス

- **イメージビルド結果**: `SHA256SUM`ファイルでチェックサム検証
  - 圧縮形式: zstd
  - 出力先: `build/img/$(ARCH)/`

### エミュレーション環境

| 項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| QEMU SMP | アーキテクチャ依存（1-4） | x86_64: 4, aarch64: 1 |
| QEMU メモリ | 1024-2048 MB | アーキテクチャ依存 |
| KVM加速 | ホストアーキテクチャ一致時有効 | macOSではHVF使用 |

### デバッグ支援

- **GDBリモートデバッグ**: `make gdb`でカーネルデバッグ接続
- **ユーザー空間デバッグ**: `make gdb-userspace`でアプリケーションデバッグ
- **ネットワーク監視**: `make wireshark`でパケット解析

### ポート転送（QEMU）

- SSH: ホスト8022 → ゲスト22
- HTTP: ホスト8080 → ゲスト80
- その他: 8081, 8082, 8083, 64126（gdbserver）

## 備考

### 環境変数一覧

| 環境変数 | デフォルト値 | 説明 |
| --- | --- | --- |
| COOKBOOK_MAKE_JOBS | CPUコア数 | 並列ジョブ数 |
| COOKBOOK_TUI | CI未設定時true | TUI有効化 |
| COOKBOOK_LOGS | TUI依存 | ログ出力有効化 |
| COOKBOOK_OFFLINE | false | オフラインモード |
| COOKBOOK_VERBOSE | true | 詳細ログ |
| COOKBOOK_NONSTOP | false | エラー時継続 |
| COOKBOOK_CLEAN_BUILD | false | ビルド前クリーン |
| COOKBOOK_CLEAN_TARGET | false | ビルド後クリーン |

### 依存関係制限

- 再帰深度上限: 16レベル（`WALK_DEPTH`定数）
- リモートパッケージソース: `https://static.redox-os.org/pkg`

### ファイルシステムサイズ

| 設定 | サイズ |
| --- | --- |
| server | 512 MiB |
| desktop | 650 MiB |
| 最小構成 | 設定ファイルで指定 |
