---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **共通エラーレスポンス**：LSP仕様からの推測であり、実装固有のエラーコードは未確認
  2. **認証方式**：実装コード内に明示的な認証ロジックが見当たらないため推測

## 2) 参照した情報（Evidence一覧）

- E-01: `src/LanguageServer/Protocol/Handler/ServerLifetime/InitializeHandler.cs`
- E-02: `src/LanguageServer/Protocol/Handler/DocumentChanges/DidOpenHandler.cs`
- E-03: `src/LanguageServer/Protocol/Handler/DocumentChanges/DidChangeHandler.cs`
- E-04: `src/LanguageServer/Protocol/Handler/DocumentChanges/DidCloseHandler.cs`
- E-05: `src/LanguageServer/Protocol/Handler/Completion/CompletionHandler.cs`
- E-06: `src/LanguageServer/Protocol/Handler/Hover/HoverHandler.cs`
- E-07: `src/LanguageServer/Protocol/Handler/Definitions/GoToDefinitionHandler.cs`
- E-08: `src/LanguageServer/Protocol/Handler/References/FindAllReferencesHandler.cs`
- E-09: `src/LanguageServer/Protocol/Handler/SignatureHelp/SignatureHelpHandler.cs`
- E-10: `src/LanguageServer/Protocol/Handler/CodeActions/CodeActionsHandler.cs`
- E-11: `src/LanguageServer/Protocol/Handler/Rename/RenameHandler.cs`
- E-12: `src/LanguageServer/Protocol/Handler/Formatting/FormatDocumentHandler.cs`
- E-13: `src/LanguageServer/Protocol/Handler/Symbols/DocumentSymbolsHandler.cs`
- E-14: `src/LanguageServer/Protocol/Handler/Symbols/WorkspaceSymbolsHandler.cs`
- E-15: `src/LanguageServer/Protocol/Handler/FoldingRanges/FoldingRangesHandler.cs`
- E-16: `src/LanguageServer/Protocol/Handler/SemanticTokens/SemanticTokensRangeHandler.cs`
- E-17: `src/LanguageServer/Protocol/Handler/InlayHint/InlayHintHandler.cs`
- E-18: `src/LanguageServer/Protocol/Handler/CodeLens/CodeLensHandler.cs`
- E-19: `src/LanguageServer/Protocol/Handler/Diagnostics/DocumentPullDiagnosticHandler.cs`
- E-20: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/RunTestsHandler.cs`
- E-21: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/OpenSolutionHandler.cs`
- E-22: `src/LanguageServer/Protocol/Handler/MethodAttribute.cs`（メソッド名定義）
- E-23: LSP仕様（https://microsoft.github.io/language-server-protocol/）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initialize エンドポイントの存在と機能 | E-01 (`[Method(Methods.InitializeName)]`) | ○ |
| C-02 | textDocument/didOpen エンドポイントの存在と機能 | E-02 (`[Method(LSP.Methods.TextDocumentDidOpenName)]`) | ○ |
| C-03 | textDocument/didChange エンドポイントの存在と機能 | E-03 (`[Method(Methods.TextDocumentDidChangeName)]`) | ○ |
| C-04 | textDocument/didClose エンドポイントの存在と機能 | E-04 (`[Method(LSP.Methods.TextDocumentDidCloseName)]`) | ○ |
| C-05 | textDocument/completion エンドポイントの存在と機能 | E-05 (`[Method(LSP.Methods.TextDocumentCompletionName)]`) | ○ |
| C-06 | textDocument/hover エンドポイントの存在と機能 | E-06 (`[Method(Methods.TextDocumentHoverName)]`) | ○ |
| C-07 | textDocument/definition エンドポイントの存在と機能 | E-07 (`[Method(LSP.Methods.TextDocumentDefinitionName)]`) | ○ |
| C-08 | textDocument/references エンドポイントの存在と機能 | E-08 (`[Method(LSP.Methods.TextDocumentReferencesName)]`) | ○ |
| C-09 | textDocument/signatureHelp エンドポイントの存在と機能 | E-09 (`[Method(LSP.Methods.TextDocumentSignatureHelpName)]`) | ○ |
| C-10 | textDocument/codeAction エンドポイントの存在と機能 | E-10 (`[Method(LSP.Methods.TextDocumentCodeActionName)]`) | ○ |
| C-11 | textDocument/rename エンドポイントの存在と機能 | E-11 (`[Method(LSP.Methods.TextDocumentRenameName)]`) | ○ |
| C-12 | textDocument/formatting エンドポイントの存在と機能 | E-12 (`[Method(LSP.Methods.TextDocumentFormattingName)]`) | ○ |
| C-13 | textDocument/documentSymbol エンドポイントの存在と機能 | E-13 (`[Method(Methods.TextDocumentDocumentSymbolName)]`) | ○ |
| C-14 | workspace/symbol エンドポイントの存在と機能 | E-14 (`[Method(Methods.WorkspaceSymbolName)]`) | ○ |
| C-15 | textDocument/foldingRange エンドポイントの存在と機能 | E-15 (`[Method(Methods.TextDocumentFoldingRangeName)]`) | ○ |
| C-16 | textDocument/semanticTokens/range エンドポイントの存在と機能 | E-16 (`[Method(Methods.TextDocumentSemanticTokensRangeName)]`) | ○ |
| C-17 | textDocument/inlayHint エンドポイントの存在と機能 | E-17 (`[Method(Methods.TextDocumentInlayHintName)]`) | ○ |
| C-18 | textDocument/codeLens エンドポイントの存在と機能 | E-18 (`[Method(LSP.Methods.TextDocumentCodeLensName)]`) | ○ |
| C-19 | textDocument/diagnostic エンドポイントの存在と機能 | E-19 (`[Method(VSInternalMethods.DocumentPullDiagnosticName)]`) | ○ |
| C-20 | textDocument/runTests エンドポイントの存在と機能 | E-20 (`RunTestsMethodName = "textDocument/runTests"`) | ○ |
| C-21 | solution/open エンドポイントの存在と機能 | E-21 (`OpenSolutionName = "solution/open"`) | ○ |
| C-22 | サポート言語（C#, VB）の情報 | E-05, E-06 等の `ExportCSharpVisualBasicStatelessLspService` 属性 | ○ |
| C-23 | Visual Studio拡張機能のサポート | E-06 (`clientCapabilities.HasVisualStudioLspCapability()`) | ○ |
| C-24 | 共通エラーレスポンスのエラーコード一覧 | **根拠なし** | △ |
| C-25 | 認証方式（ローカル通信のため不要） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **共通エラーレスポンス（C-24）**
  - 理由：LSP仕様からの一般的なエラーコードを記載したが、Roslyn固有のエラーコードやカスタムエラーハンドリングの実装は未確認
  - 候補：`Microsoft.CommonLanguageServerProtocol.Framework` のエラーハンドリング実装 / LSP仕様書

- **認証方式（C-25）**
  - 理由：LSPは通常ローカルプロセス間通信のため認証不要と推測したが、Service Broker接続時の認証要件は未確認
  - 候補：`src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/BrokeredServices/` ディレクトリ内のファイル

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 全エンドポイントの存在確認 - ソースコード内の `[Method()]` 属性から直接確認済み
- **0（低リスク）**: パラメータ型と構造 - LSP標準仕様に準拠しており、ハンドラーのメソッドシグネチャから確認
- **1（中リスク）**: レスポンス例のJSON構造 - 実装コードから推測したサンプルであり、実際の出力と異なる可能性あり
- **1（中リスク）**: VS Internal 拡張機能の網羅性 - 一部のVS固有メソッドは記載していない可能性あり
- **0（低リスク）**: バージョン整合性 - 現在のソースコードから抽出しているため、最新の実装を反映

## 6) レビュアーチェックリスト（最小）

- [ ] 各エンドポイントのメソッド名がLSP仕様と一致しているか確認
- [ ] リクエスト/レスポンスのJSON例が実際の動作と整合しているか確認
- [ ] 共通エラーレスポンスのエラーコードが実装と一致しているか確認
- [ ] VS Internal 拡張機能で記載漏れがないか確認
- [ ] 認証・セキュリティに関する追加情報が必要か判断
- [ ] テストエンドポイント（runTests）のパラメータ仕様が正確か確認
- [ ] ワークスペース関連エンドポイント（solution/open, project/open）の追加仕様を確認
