# Roslyn - The .NET Compiler Platform

## 概要

RoslynはMicrosoftが開発するオープンソースの.NETコンパイラプラットフォームです。C#およびVisual Basicコンパイラのリファレンス実装であり、コード分析ツールを構築するための豊富なAPIを提供します。Visual Studioの言語サービス、IntelliSense、コードリファクタリング機能の基盤となっています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| C#/VBコンパイラ | C#およびVisual Basicの完全なコンパイラ実装（csc/vbc） |
| Compiler API | 構文解析、セマンティック分析、コード生成のためのAPI群 |
| Workspaces API | ソリューション、プロジェクト、ドキュメントを操作するためのAPI |
| コード分析 | Analyzer、Code Fixによる静的コード分析とリファクタリング |
| Language Server Protocol | LSPを通じたIDE統合（Visual Studio、VS Code等） |
| Scripting | C#スクリプティング（CSI）のサポート |
| Expression Evaluator | デバッガ用の式評価エンジン |

## 技術スタック

### コア

- フレームワーク: .NET 10.0（.NET Framework 4.7.2もサポート）
- 言語: C#, Visual Basic
- ビルドシステム: MSBuild, .NET SDK 10.0.102
- IDE統合: Visual Studio 2022 (v17.14.0以降)

### 主要ライブラリ

- System.Collections.Immutable: イミュータブルコレクション
- System.Reflection.Metadata: メタデータ解析
- Microsoft.Build: MSBuildとの統合
- StreamJsonRpc: Language Server通信
- Microsoft.VisualStudio.Threading: VS統合用スレッディング
- xUnit: テストフレームワーク

## ディレクトリ構成

```
roslyn-main/
├── src/                          # ソースコード
│   ├── Compilers/                # コンパイラ本体
│   │   ├── CSharp/               # C#コンパイラ
│   │   ├── VisualBasic/          # VBコンパイラ
│   │   ├── Core/                 # 共通コンパイラ基盤
│   │   └── Extension/            # VS拡張機能
│   ├── Workspaces/               # Workspaces API
│   │   ├── Core/                 # 共通Workspace機能
│   │   ├── CSharp/               # C#用Workspace
│   │   └── MSBuild/              # MSBuild統合
│   ├── Features/                 # IDEフィーチャー（リファクタリング等）
│   ├── EditorFeatures/           # エディタ統合機能
│   ├── LanguageServer/           # LSP実装
│   ├── VisualStudio/             # Visual Studio統合
│   ├── Analyzers/                # コード分析器
│   ├── Scripting/                # スクリプティング機能
│   └── ExpressionEvaluator/      # デバッガ式評価
├── docs/                         # ドキュメント
│   ├── contributing/             # コントリビュータ向けガイド
│   ├── compilers/                # コンパイラ設計ドキュメント
│   ├── features/                 # 機能設計ドキュメント
│   └── wiki/                     # Wikiページ
├── eng/                          # ビルドエンジニアリング
├── scripts/                      # ユーティリティスクリプト
├── Build.cmd / build.sh          # ビルドスクリプト
├── Test.cmd / test.sh            # テストスクリプト
├── Restore.cmd / restore.sh      # パッケージ復元スクリプト
├── Roslyn.slnx                   # メインソリューションファイル
├── global.json                   # SDK/ツールバージョン設定
└── NuGet.config                  # NuGetフィード設定
```

## セットアップ

### 必要条件

- **Windows**: Visual Studio 2022 Preview（拡張機能開発ワークロード含む）
- **Unix/Mac**: .NET SDK 10.0.102
- **.NET Framework**: 4.7.2以上（Windows）
- **PowerShell**: 5.0以上（Windows）

### インストール手順

#### Windows

```cmd
# 1. リポジトリをクローン
git clone https://github.com/dotnet/roslyn.git

# 2. 依存関係を復元
Restore.cmd

# 3. ビルド
Build.cmd

# 4. テスト実行
Test.cmd
```

#### Unix/Mac

```bash
# 1. リポジトリをクローン
git clone git@github.com:dotnet/roslyn.git

# 2. 依存関係を復元
./restore.sh

# 3. ビルド
./build.sh

# 4. テスト実行
./test.sh
```

### Visual Studio 2022での開発

1. Visual Studio 2022 Previewをインストール
2. Visual Studio拡張機能開発ワークロードを選択
3. .NET 10.0 SDKをインストール
4. `Restore.cmd`を実行
5. `Roslyn.slnx`を開く

## 開発

### ビルドオプション

```cmd
# デバッグビルド
Build.cmd -configuration Debug

# リリースビルド
Build.cmd -configuration Release

# 拡張機能をデプロイしてVSを起動
Build.cmd -Restore -Configuration Release -deployExtensions -launch
```

### テスト実行

```cmd
# 全テスト実行
Test.cmd

# .NET Framework上でテスト
eng/build.ps1 -test

# .NET Core上でテスト
eng/build.ps1 -testCoreClr

# コンパイラテストのみ
eng/build.ps1 -testCompilerOnly
```

### コーディングスタイル

- [.NET Runtime Coding Guidelines](https://github.com/dotnet/runtime/blob/main/docs/coding-guidelines/coding-style.md)に従う
- `.editorconfig`で自動フォーマット
- `Debug.Assert()`でデバッグ時の検証
- ホットパスでのLINQ、アロケーション回避

### デバッグ

1. **RoslynDeployment**プロジェクトをスタートアッププロジェクトに設定
2. F5でVisual Studioの実験インスタンス（RoslynDev hive）を起動
3. 変更した言語機能やIDE機能を試すことが可能

### NuGetフィード

プレリリースビルドは以下のフィードから取得可能：

- **Compiler**: `https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-tools/nuget/v3/index.json`
- **IDE Services**: `https://pkgs.dev.azure.com/azure-public/vside/_packaging/vssdk/nuget/v3/index.json`
- **.NET SDK**: `https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet5/nuget/v3/index.json`
