---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があるため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `/Users/tomoka.baba/Work/roslyn-main/README.md` - 公式README
- E-02: `/Users/tomoka.baba/Work/roslyn-main/global.json` - SDK/ツールバージョン設定
- E-03: `/Users/tomoka.baba/Work/roslyn-main/eng/Packages.props` - パッケージ依存関係定義
- E-04: `/Users/tomoka.baba/Work/roslyn-main/CONTRIBUTING.md` - コントリビューションガイド
- E-05: `/Users/tomoka.baba/Work/roslyn-main/build.sh` - Unixビルドスクリプト
- E-06: `/Users/tomoka.baba/Work/roslyn-main/Build.cmd` - Windowsビルドスクリプト
- E-07: `/Users/tomoka.baba/Work/roslyn-main/docs/contributing/Building, Debugging, and Testing on Windows.md` - Windows開発ガイド
- E-08: `/Users/tomoka.baba/Work/roslyn-main/docs/contributing/Building, Debugging, and Testing on Unix.md` - Unix開発ガイド
- E-09: `/Users/tomoka.baba/Work/roslyn-main/src/` - ソースディレクトリ構造
- E-10: `/Users/tomoka.baba/Work/roslyn-main/Directory.Packages.props` - 中央パッケージ管理設定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RoslynはC#およびVBコンパイラのオープンソース実装 | E-01 | ○ |
| C-02 | コード分析ツール構築用APIを提供 | E-01 | ○ |
| C-03 | .NET SDK 10.0.102を使用 | E-02 | ○ |
| C-04 | Visual Studio 17.14.0以降をサポート | E-02 | ○ |
| C-05 | xUnitをテストフレームワークとして使用 | E-03 | ○ |
| C-06 | System.Collections.Immutableを使用 | E-03 | ○ |
| C-07 | StreamJsonRpcを使用（LSP通信） | E-03 | ○ |
| C-08 | src/Compilers/にコンパイラソース | E-09 | ○ |
| C-09 | src/Workspaces/にWorkspaces API | E-09 | ○ |
| C-10 | src/Features/にIDEフィーチャー | E-09 | ○ |
| C-11 | src/LanguageServer/にLSP実装 | E-09 | ○ |
| C-12 | Build.cmdでWindowsビルド | E-06 | ○ |
| C-13 | build.shでUnixビルド | E-05 | ○ |
| C-14 | .NET Framework 4.7.2が最小要件 | E-07 | ○ |
| C-15 | PowerShell 5.0以上が必要（Windows） | E-07 | ○ |
| C-16 | Restore.cmdで依存関係復元 | E-07 | ○ |
| C-17 | Test.cmdでテスト実行 | E-07 | ○ |
| C-18 | RoslynDeploymentがスタートアッププロジェクト | E-07 | ○ |
| C-19 | RoslynDev hiveで実験インスタンス起動 | E-07 | ○ |
| C-20 | .NET Runtime Coding Guidelinesに従う | E-04 | ○ |
| C-21 | .editorconfigでスタイル管理 | E-04 | ○ |
| C-22 | Debug.Assert()でデバッグ検証 | E-04 | ○ |
| C-23 | ホットパスでLINQ回避推奨 | E-04 | ○ |
| C-24 | 3種類のNuGetフィードを提供 | E-01 | ○ |
| C-25 | .NET Foundation傘下プロジェクト | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- すべての主張に対して根拠が確認できたため、不足情報はありません

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - すべての主張がプロジェクト内のファイルから直接確認可能です
- バージョン情報（SDK、VS、パッケージ）は時間経過により変更される可能性があるため、定期的な更新レビューを推奨します

## 6) レビュアーチェックリスト（最小）

- [ ] SDKバージョン（10.0.102）がglobal.jsonと一致しているか確認
- [ ] Visual Studioバージョン（17.14.0）が最新の要件と一致しているか確認
- [ ] 主要ライブラリ一覧がeng/Packages.propsの内容を反映しているか確認
- [ ] ディレクトリ構成がsrc/配下の実際の構造と一致しているか確認
- [ ] ビルド/テストコマンドが現行のスクリプトと一致しているか確認
