---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **C-42 デバッグ手順**：開発者固有のワークフローに依存
  2. **C-43 外部リソースURL**：外部リソースの有効性は時間経過で変化
  3. **C-45 テストディレクトリ配置規則**：一部例外パターンが存在する可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクト概要）
- E-02: `global.json`（.NET SDKバージョン設定）
- E-03: `Directory.Build.props`（MSBuild設定）
- E-04: `src/Compilers/Core/Portable/Compilation/Compilation.cs`（Compilationクラス定義）
- E-05: `src/Compilers/CSharp/Portable/Symbols/Symbol.cs`（Symbolクラス定義）
- E-06: `src/Workspaces/Core/Portable/Workspace/Workspace.cs`（Workspaceクラス定義）
- E-07: `src/Compilers/CSharp/Portable/Syntax/SyntaxFactory.cs`（SyntaxFactoryクラス定義）
- E-08: `src/Compilers/CSharp/Portable/Binder/Binder.cs`（Binderクラス定義）
- E-09: `src/Features/Core/Portable/Completion/CompletionService.cs`（CompletionService定義）
- E-10: `src/Features/Core/Portable/CodeFixes/Service/CodeFixService.cs`（CodeFixService定義）
- E-11: `src/Analyzers/CSharp/Analyzers/UseImplicitObjectCreation/CSharpUseImplicitObjectCreationDiagnosticAnalyzer.cs`
- E-12: `src/LanguageServer/Protocol/Handler/ILspServiceRequestHandler.cs`（LSPハンドラインターフェース）
- E-13: プロジェクトディレクトリ構造（ls コマンド結果）
- E-14: `CONTRIBUTING.md`（貢献ガイドライン）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RoslynはC#/VBコンパイラのオープンソース実装 | E-01 | ○ |
| C-02 | .NET Foundation配下のプロジェクト | E-01 | ○ |
| C-03 | .NET SDK 10.0.102を使用 | E-02 | ○ |
| C-04 | Microsoft.DotNet.Arcade.Sdkを使用 | E-03 | ○ |
| C-05 | Compilationは不変オブジェクト | E-04 | ○ |
| C-06 | Compilationはabstract partial class | E-04 | ○ |
| C-07 | Symbolは全シンボルの基底クラス | E-05 | ○ |
| C-08 | Workspaceはプロジェクト/ドキュメント管理 | E-06 | ○ |
| C-09 | Workspaceはabstract partial class | E-06 | ○ |
| C-10 | SyntaxFactoryは構文ノード生成ファクトリ | E-07 | ○ |
| C-11 | SyntaxFactoryはstatic partial class | E-07 | ○ |
| C-12 | Binderは名前解決を担当 | E-08 | ○ |
| C-13 | CompletionServiceはILanguageService実装 | E-09 | ○ |
| C-14 | CodeFixServiceはMEFでエクスポート | E-10 | ○ |
| C-15 | DiagnosticAnalyzerは[DiagnosticAnalyzer]属性で装飾 | E-11 | ○ |
| C-16 | AbstractBuiltInCodeStyleDiagnosticAnalyzerが基底クラス | E-11 | ○ |
| C-17 | RegisterSyntaxNodeActionでノード解析登録 | E-11 | ○ |
| C-18 | ILspServiceRequestHandlerインターフェース存在 | E-12 | ○ |
| C-19 | src/Compilers/ディレクトリ構造 | E-13 | ○ |
| C-20 | src/Workspaces/ディレクトリ構造 | E-13 | ○ |
| C-21 | src/Features/ディレクトリ構造 | E-13 | ○ |
| C-22 | src/LanguageServer/ディレクトリ構造 | E-13 | ○ |
| C-23 | src/Analyzers/ディレクトリ構造 | E-13 | ○ |
| C-24 | CSharp/とVisualBasic/の分離 | E-13 | ○ |
| C-25 | Core/Portable/のパターン | E-13 | ○ |
| C-26 | Abstract*プレフィックス命名規則 | E-11 | ○ |
| C-27 | *Providerサフィックス命名規則 | E-09, E-10 | ○ |
| C-28 | *Serviceサフィックス命名規則 | E-09, E-10 | ○ |
| C-29 | I*プレフィックスでインターフェース | E-12 | ○ |
| C-30 | _*プレフィックスでプライベートフィールド | E-04, E-06 | ○ |
| C-31 | [Export]/[Import]属性でMEF使用 | E-10 | ○ |
| C-32 | [ImportingConstructor]属性 | E-10 | ○ |
| C-33 | Lazy<T>での遅延初期化 | E-04, E-10 | ○ |
| C-34 | ImmutableArray<T>の使用 | E-04, E-05 | ○ |
| C-35 | IReadOnlyDictionary<K,V>の使用 | E-04 | ○ |
| C-36 | レイヤードアーキテクチャ | E-13 | ○ |
| C-37 | Compiler層が最下層 | E-13 | ○ |
| C-38 | Workspace層がCompiler上 | E-13 | ○ |
| C-39 | Features層がWorkspace上 | E-13 | ○ |
| C-40 | LanguageServer層がFeatures上 | E-13 | ○ |
| C-41 | VisualStudio層が最上位 | E-13 | ○ |
| C-42 | デバッグ手順（devenv.exeアタッチ） | **根拠なし** | △ |
| C-43 | 外部参考資料URL | **根拠なし** | △ |
| C-44 | CONTRIBUTING.mdの存在 | E-14 | ○ |
| C-45 | *Test/ディレクトリにテスト配置 | E-13（一部推定） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-42 デバッグ手順**：開発者ドキュメントやContributingガイドからの直接引用なし
  - 候補：`docs/contributing/Building, Debugging, and Testing on Windows.md` / 公式Wiki / 開発者インタビュー
- **C-43 外部リソースURL**：URLの有効性は検証時点でのみ確認可能
  - 候補：URLアクセス確認 / Wayback Machine / 公式ドキュメント最新版確認
- **C-45 テストディレクトリ配置規則**：一般パターンとしては正確だが、例外が存在する可能性
  - 候補：全テストディレクトリの網羅的確認 / プロジェクト規約ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：プロジェクト概要、言語・フレームワーク特定
- **0（低リスク）**：ディレクトリ構造、命名規則
- **0（低リスク）**：主要クラス説明（ソースコード参照あり）
- **1（中リスク）**：アーキテクチャ図（推定含む）
- **1（中リスク）**：業務フロー追跡例（一般パターンからの推定）
- **2（高リスク）**：デバッグ手順、外部リソース（検証困難）

## 6) レビュアーチェックリスト（最小）
- [ ] 主要クラスの説明が実際のソースコードと一致しているか
- [ ] 命名規則の例が網羅的か、例外パターンがないか
- [ ] ディレクトリ構造の説明が最新の状態を反映しているか
- [ ] アーキテクチャ図のレイヤー依存関係が正確か
- [ ] 外部参考資料のURLが有効か
- [ ] デバッグ手順が現在の開発環境で動作するか
- [ ] 用語集の定義が正確か
