---
generated_at: 2026-02-10 15:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **トランザクション管理の分離レベル詳細**：コードからの直接的な確認が困難
  2. **テレメトリ送信先の詳細**：Visual Studio統合時の挙動は外部ドキュメント依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/roslyn-main/README.md`
- E-02: `/Users/tomoka.baba/Work/roslyn-main/global.json`
- E-03: `/Users/tomoka.baba/Work/roslyn-main/src/Compilers/Core/Portable/Microsoft.CodeAnalysis.csproj`
- E-04: `/Users/tomoka.baba/Work/roslyn-main/src/Workspaces/Core/Portable/Microsoft.CodeAnalysis.Workspaces.csproj`
- E-05: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Microsoft.CodeAnalysis.Features.csproj`
- E-06: `/Users/tomoka.baba/Work/roslyn-main/src/LanguageServer/Protocol/Microsoft.CodeAnalysis.LanguageServer.Protocol.csproj`
- E-07: `/Users/tomoka.baba/Work/roslyn-main/Roslyn.slnx`
- E-08: `/Users/tomoka.baba/Work/roslyn-main/src/` ディレクトリ構造
- E-09: `/Users/tomoka.baba/Work/roslyn-main/Directory.Build.props`
- E-10: `/Users/tomoka.baba/Work/roslyn-main/azure-pipelines.yml`（存在確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RoslynはC#およびVBコンパイラのオープンソース実装である | E-01 | ○ |
| C-02 | .NET SDK 10.0.102を使用 | E-02 | ○ |
| C-03 | Visual Studio 17.14.0に対応 | E-02 | ○ |
| C-04 | Microsoft.DotNet.Arcade.Sdkを使用 | E-02, E-09 | ○ |
| C-05 | Compilersレイヤーが最下層 | E-03, E-04, E-05 | ○ |
| C-06 | WorkspacesはCompilersに依存 | E-04 | ○ |
| C-07 | FeaturesはWorkspacesに依存 | E-05 | ○ |
| C-08 | LanguageServerはFeaturesに依存 | E-06 | ○ |
| C-09 | System.Collections.Immutableを使用 | E-03 | ○ |
| C-10 | System.Reflection.Metadataを使用 | E-03 | ○ |
| C-11 | System.Compositionを使用（MEF） | E-04 | ○ |
| C-12 | StreamJsonRpcを使用（LSP） | E-06 | ○ |
| C-13 | SQLitePCLRawを使用（キャッシュ） | E-04 | ○ |
| C-14 | Humanizer.Coreを使用 | E-04 | ○ |
| C-15 | ICSharpCode.Decompilerを使用 | E-06 | ○ |
| C-16 | Microsoft.DiaSymReaderを使用 | E-05 | ○ |
| C-17 | InternalsVisibleToによるアクセス制御 | E-03, E-04, E-05, E-06 | ○ |
| C-18 | RestrictedInternalsVisibleToによるパートナーAPI | E-04, E-06 | ○ |
| C-19 | パッケージ構造（src/Compilers等） | E-08 | ○ |
| C-20 | C#/VB言語別分離アーキテクチャ | E-07, E-08 | ○ |
| C-21 | Portable/Desktop分離 | E-04, E-08 | ○ |
| C-22 | ExternalAccessパターン採用 | E-05, E-06, E-08 | ○ |
| C-23 | Azure DevOps CI/CDパイプライン | E-10 | ○ |
| C-24 | Microsoft.CodeAnalysis.Elfie使用（検索） | E-05 | ○ |
| C-25 | System.Threading.Channels使用 | E-04 | ○ |
| C-26 | System.IO.Pipelines使用 | E-04 | ○ |
| C-27 | トランザクション管理の詳細な分離レベル | **根拠なし** | △ |
| C-28 | テレメトリ送信先（Azure Application Insights） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **トランザクション管理の分離レベル**
  - 不変オブジェクトパターンの採用は確認できるが、「スナップショット分離」という用語の直接的なコード根拠がない
  - 候補：Workspaces/Core/Portable内のSolutionStateクラス / Compilationクラスの実装詳細 / アーキテクチャドキュメント

- **テレメトリ送信先**
  - Visual Studio統合時のテレメトリ機能は外部（VS SDK）に依存するため、Roslynリポジトリ内で確認困難
  - 候補：Visual Studio SDKドキュメント / Microsoft.VisualStudio.Telemetryパッケージ / VS統合コード

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - プロジェクトの基本構成（レイヤー構成、依存関係）
  - プロジェクトファイルから直接確認可能
- **0: 低リスク** - 使用ミドルウェア・ライブラリ
  - csprojファイルのPackageReference から直接確認可能
- **1: 中リスク** - データフロー詳細
  - 実装コードの動作確認が理想的だが、標準的なコンパイラパイプライン設計と整合
- **1: 中リスク** - 横断的関心事の実装詳細
  - ETWロギング等は実装コード確認が必要だが、.NETプラットフォーム標準パターン

## 6) レビュアーチェックリスト（最小）
- [ ] レイヤー依存関係がcsprojのProjectReference と整合しているか確認
- [ ] 外部システム連携（VS、VSCode、MSBuild）の説明が実際の統合方式と合致するか確認
- [ ] パッケージ構造図がsrc/ディレクトリの実際の構成と一致するか確認
- [ ] トランザクション管理（不変オブジェクトパターン）の記述が実装と整合するか、SolutionState等のコードで確認
- [ ] テレメトリに関する記述をVS統合コード（VisualStudio/ディレクトリ）で確認
