# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph External["外部システム"]
        VS[Visual Studio]
        VSCode[VS Code]
        MSBuild[MSBuild]
        NETSDK[.NET SDK]
        OmniSharp[OmniSharp]
    end

    subgraph Roslyn["Roslyn Platform"]
        subgraph VSIntegration["Visual Studio 統合層"]
            VSLS[Microsoft.VisualStudio.LanguageServices]
            VSCore[VisualStudio.Core]
            VSIX[VSIX Package]
        end

        subgraph LSP["Language Server 層"]
            LSPServer[Microsoft.CodeAnalysis.LanguageServer]
            LSPProtocol[LanguageServer.Protocol]
            CLSPFramework[CommonLanguageServerProtocol.Framework]
        end

        subgraph Editor["Editor Features 層"]
            EditorCore[EditorFeatures.Core]
            EditorCSharp[EditorFeatures.CSharp]
            EditorVB[EditorFeatures.VisualBasic]
            EditorText[EditorFeatures.Text]
        end

        subgraph Features["Features 層"]
            FeaturesCore[Features.Core]
            FeaturesCSharp[Features.CSharp]
            FeaturesVB[Features.VisualBasic]
            Analyzers[Analyzers]
            CodeFixes[CodeFixes]
        end

        subgraph Workspaces["Workspaces 層"]
            WSCore[Workspaces.Core]
            WSCSharp[Workspaces.CSharp]
            WSVB[Workspaces.VisualBasic]
            WSMSBuild[Workspaces.MSBuild]
            WSRemote[Remote.ServiceHub]
        end

        subgraph Compilers["Compilers 層"]
            CoreAPI[Microsoft.CodeAnalysis]
            CSharpCompiler[CodeAnalysis.CSharp]
            VBCompiler[CodeAnalysis.VisualBasic]
            CSC[csc.exe]
            VBC[vbc.exe]
            VBCSCompiler[VBCSCompiler]
        end

        subgraph ExternalAccess["External Access 層"]
            EARazor[ExternalAccess.Razor]
            EAFSharp[ExternalAccess.FSharp]
            EAOmniSharp[ExternalAccess.OmniSharp]
            EACopilot[ExternalAccess.Copilot]
        end
    end

    VS --> VSLS
    VSCode --> LSPServer
    MSBuild --> VBCSCompiler
    NETSDK --> CSC
    NETSDK --> VBC
    OmniSharp --> EAOmniSharp

    VSLS --> EditorCore
    VSLS --> VSCore
    LSPServer --> LSPProtocol
    LSPProtocol --> FeaturesCore

    EditorCore --> FeaturesCore
    EditorCSharp --> FeaturesCSharp
    EditorVB --> FeaturesVB

    FeaturesCore --> WSCore
    FeaturesCSharp --> WSCSharp
    FeaturesVB --> WSVB

    WSCore --> CoreAPI
    WSCSharp --> CSharpCompiler
    WSVB --> VBCompiler
    WSMSBuild --> WSCore
    WSRemote --> WSCore

    CSC --> CSharpCompiler
    VBC --> VBCompiler
    VBCSCompiler --> CSharpCompiler
    VBCSCompiler --> VBCompiler

    CSharpCompiler --> CoreAPI
    VBCompiler --> CoreAPI

    EARazor --> FeaturesCore
    EAFSharp --> WSCore
    EAOmniSharp --> WSCore
    EACopilot --> FeaturesCore
```

## レイヤー依存関係図

```mermaid
graph TD
    subgraph "依存の方向（上から下へ）"
        L1[Visual Studio Integration]
        L2[Language Server]
        L3[Editor Features]
        L4[Features]
        L5[Workspaces]
        L6[Compilers]
    end

    L1 --> L3
    L2 --> L4
    L3 --> L4
    L4 --> L5
    L5 --> L6

    style L1 fill:#f9f,stroke:#333
    style L2 fill:#bbf,stroke:#333
    style L3 fill:#bfb,stroke:#333
    style L4 fill:#fbf,stroke:#333
    style L5 fill:#fbb,stroke:#333
    style L6 fill:#ff9,stroke:#333
```

## コンパイルパイプライン

```mermaid
flowchart LR
    subgraph Input["入力"]
        Source[ソースファイル]
        Refs[参照アセンブリ]
        Options[コンパイルオプション]
    end

    subgraph Parsing["構文解析"]
        Lexer[Lexer]
        Parser[Parser]
        SyntaxTree[SyntaxTree]
    end

    subgraph Binding["意味解析"]
        SymbolTable[Symbol Table]
        Binder[Binder]
        SemanticModel[SemanticModel]
    end

    subgraph Analysis["解析"]
        FlowAnalysis[Flow Analysis]
        DiagnosticAnalyzer[Diagnostic Analyzer]
    end

    subgraph Emit["コード生成"]
        ILEmit[IL Emit]
        PEWriter[PE Writer]
        PDBWriter[PDB Writer]
    end

    subgraph Output["出力"]
        Assembly[DLL/EXE]
        PDB[PDBファイル]
        Diagnostics[診断結果]
    end

    Source --> Lexer
    Lexer --> Parser
    Parser --> SyntaxTree

    SyntaxTree --> Binder
    Refs --> SymbolTable
    SymbolTable --> Binder
    Binder --> SemanticModel

    SemanticModel --> FlowAnalysis
    SemanticModel --> DiagnosticAnalyzer
    Options --> ILEmit

    SemanticModel --> ILEmit
    ILEmit --> PEWriter
    ILEmit --> PDBWriter

    PEWriter --> Assembly
    PDBWriter --> PDB
    FlowAnalysis --> Diagnostics
    DiagnosticAnalyzer --> Diagnostics
```

## Workspace アーキテクチャ

```mermaid
graph TB
    subgraph Host["ホスト環境"]
        IDE[Visual Studio / VS Code]
        CLI[dotnet CLI]
    end

    subgraph Workspace["Workspace Layer"]
        WS[Workspace]
        Solution[Solution]
        Project[Project]
        Document[Document]
    end

    subgraph State["状態管理"]
        SolutionState[SolutionState]
        ProjectState[ProjectState]
        DocumentState[DocumentState]
        Compilation[Compilation]
    end

    subgraph Services["サービス"]
        SolutionServices[SolutionServices]
        HostServices[HostServices]
        MEFHost[MEF Host]
    end

    IDE --> WS
    CLI --> WS

    WS --> Solution
    Solution --> Project
    Project --> Document

    Solution --> SolutionState
    Project --> ProjectState
    Document --> DocumentState

    SolutionState --> Compilation
    ProjectState --> Compilation
    DocumentState --> SyntaxTree[SyntaxTree]

    WS --> SolutionServices
    SolutionServices --> HostServices
    HostServices --> MEFHost
```

## Out-of-Process (OOP) アーキテクチャ

```mermaid
sequenceDiagram
    participant Host as Host Process (VS/LSP)
    participant Hub as ServiceHub
    participant Remote as Remote Process

    Host->>Hub: Connect to ServiceHub
    Hub->>Remote: Spawn Remote Process
    Remote-->>Hub: Ready

    Host->>Hub: Request (JSON-RPC)
    Hub->>Remote: Forward Request
    Remote->>Remote: Execute Analysis
    Remote-->>Hub: Response
    Hub-->>Host: Forward Response

    Note over Host,Remote: Checksum-based asset synchronization
    Host->>Remote: SolutionChecksum
    Remote->>Host: Request missing assets
    Host-->>Remote: Asset data
```

## Language Server Protocol フロー

```mermaid
sequenceDiagram
    participant Client as LSP Client (VS Code)
    participant Server as Roslyn LSP Server
    participant Handler as Request Handler
    participant Feature as Feature Service
    participant WS as Workspace

    Client->>Server: Initialize Request
    Server-->>Client: Initialize Response

    Client->>Server: textDocument/didOpen
    Server->>WS: Update Document
    WS-->>Server: Document Updated

    Client->>Server: textDocument/completion
    Server->>Handler: Route Request
    Handler->>Feature: GetCompletions
    Feature->>WS: Get SemanticModel
    WS-->>Feature: SemanticModel
    Feature-->>Handler: CompletionList
    Handler-->>Server: Response
    Server-->>Client: Completion Items

    Client->>Server: textDocument/didChange
    Server->>WS: Update Document
    Note over Server: Background Diagnostics
    Server-->>Client: textDocument/publishDiagnostics
```

## アナライザーパイプライン

```mermaid
flowchart TB
    subgraph Registration["登録"]
        AnalyzerRef[Analyzer Reference]
        AnalyzerLoader[Analyzer Loader]
        AnalyzerRegistry[Analyzer Registry]
    end

    subgraph Execution["実行"]
        AnalyzerDriver[Analyzer Driver]
        SyntaxAnalyzer[Syntax Tree Analyzer]
        SemanticAnalyzer[Semantic Model Analyzer]
        SymbolAnalyzer[Symbol Analyzer]
        OperationAnalyzer[Operation Analyzer]
    end

    subgraph Results["結果"]
        DiagnosticBag[Diagnostic Bag]
        DiagnosticService[Diagnostic Service]
        ErrorList[Error List / Squiggles]
    end

    AnalyzerRef --> AnalyzerLoader
    AnalyzerLoader --> AnalyzerRegistry
    AnalyzerRegistry --> AnalyzerDriver

    AnalyzerDriver --> SyntaxAnalyzer
    AnalyzerDriver --> SemanticAnalyzer
    AnalyzerDriver --> SymbolAnalyzer
    AnalyzerDriver --> OperationAnalyzer

    SyntaxAnalyzer --> DiagnosticBag
    SemanticAnalyzer --> DiagnosticBag
    SymbolAnalyzer --> DiagnosticBag
    OperationAnalyzer --> DiagnosticBag

    DiagnosticBag --> DiagnosticService
    DiagnosticService --> ErrorList
```

## パッケージ依存関係

```mermaid
graph BT
    subgraph NuGet["NuGet パッケージ"]
        Common[Microsoft.CodeAnalysis.Common]
        CSharp[Microsoft.CodeAnalysis.CSharp]
        VB[Microsoft.CodeAnalysis.VisualBasic]
        WSCommon[Microsoft.CodeAnalysis.Workspaces.Common]
        WSCSharp[Microsoft.CodeAnalysis.CSharp.Workspaces]
        WSVB[Microsoft.CodeAnalysis.VisualBasic.Workspaces]
        Features[Microsoft.CodeAnalysis.Features]
        Compilers[Microsoft.Net.Compilers.Toolset]
    end

    subgraph External["外部依存"]
        Immutable[System.Collections.Immutable]
        Metadata[System.Reflection.Metadata]
        Composition[System.Composition]
        JsonRpc[StreamJsonRpc]
    end

    Common --> Immutable
    Common --> Metadata

    CSharp --> Common
    VB --> Common

    WSCommon --> Common
    WSCommon --> Composition

    WSCSharp --> CSharp
    WSCSharp --> WSCommon

    WSVB --> VB
    WSVB --> WSCommon

    Features --> WSCommon
    Features --> JsonRpc

    Compilers --> CSharp
    Compilers --> VB
```
