---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **バックアップ保持期間**：一部のデフォルト値は推測
  2. **監視設計の通知先**：具体的な通知先設定ファイルが未確認
  3. **Agent スペック詳細**：Azure DevOps側の設定は外部システム依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.devcontainer/Dockerfile`
- E-02: `.devcontainer/devcontainer.json`
- E-03: `global.json`
- E-04: `azure-pipelines.yml`
- E-05: `azure-pipelines-official.yml`
- E-06: `azure-pipelines-integration.yml`
- E-07: `azure-pipelines-compliance.yml`
- E-08: `NuGet.config`
- E-09: `eng/config/PublishData.json`
- E-10: `eng/pipelines/build-windows-job.yml`
- E-11: `eng/pipelines/build-unix-job.yml`
- E-12: `eng/pipelines/test-windows-job.yml`
- E-13: `eng/pipelines/test-unix-job.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CI/CDプラットフォームはAzure DevOps/Azure Pipelines | E-04, E-05 | ○ |
| C-02 | .NET SDK バージョン 10.0.102 を使用 | E-03 | ○ |
| C-03 | Visual Studio 17.14.0 を使用 | E-03 | ○ |
| C-04 | vswhere 3.1.7 を使用 | E-03 | ○ |
| C-05 | xcopy-msbuild 18.0.0 を使用 | E-03 | ○ |
| C-06 | Microsoft.DotNet.Arcade.Sdk 11.0.0-beta.26055.1 を使用 | E-03 | ○ |
| C-07 | Microsoft.DotNet.Helix.Sdk 11.0.0-beta.26055.1 を使用 | E-03 | ○ |
| C-08 | Windows Agent は VS2022 Preview/VS2026 Preview を使用 | E-04 | ○ |
| C-09 | Ubuntu Agent は Build.Ubuntu.2204.Amd64 を使用 | E-04 | ○ |
| C-10 | macOS Agent は macOS-15 を使用 | E-04 | ○ |
| C-11 | Helix Windows Queue は Windows.10.Amd64 を使用 | E-04 | ○ |
| C-12 | Helix Ubuntu Queue は Ubuntu.2204.Amd64 を使用 | E-04 | ○ |
| C-13 | Helix macOS Queue は OSX.15.Amd64 を使用 | E-04 | ○ |
| C-14 | パブリックプロジェクトは NetCore-Public プールを使用 | E-04 | ○ |
| C-15 | 内部プロジェクトは NetCore1ESPool-Internal プールを使用 | E-04 | ○ |
| C-16 | NuGet パッケージソースに dotnet-eng を使用 | E-08 | ○ |
| C-17 | NuGet パッケージソースに vssdk を使用 | E-08 | ○ |
| C-18 | NuGet パッケージソースに vs-impl を使用 | E-08 | ○ |
| C-19 | Dev Container は mcr.microsoft.com/dotnet/sdk:8.0 ベース | E-01 | ○ |
| C-20 | Dev Container で curl, git をインストール | E-01 | ○ |
| C-21 | VS Code 拡張機能に ms-dotnettools.csharp を推奨 | E-02 | ○ |
| C-22 | VS Code 拡張機能に ms-azure-devops.azure-pipelines を推奨 | E-02 | ○ |
| C-23 | main, release/* ブランチで自動ビルドがトリガー | E-04 | ○ |
| C-24 | Official Build で CodeQL が有効 | E-05 | ○ |
| C-25 | Official Build で TSA が有効 | E-05 | ○ |
| C-26 | Official Build で PoliCheck が有効 | E-05 | ○ |
| C-27 | VSDrop の保持期間は 90日 | E-05 | ○ |
| C-28 | 1ESPipelineTemplates を使用 | E-05 | ○ |
| C-29 | Node.js 16.x を使用 | E-05 | ○ |
| C-30 | NuGet 4.9.2 を使用 | E-05 | ○ |
| C-31 | Source Build は CentOS Stream 9 コンテナで実行 | E-04 | ○ |
| C-32 | VS Insertion が自動実行される | E-05 | ○ |
| C-33 | ビルドログの保持期間は30日 | **根拠なし** | △ |
| C-34 | Azure DevOps Dashboard で監視 | **根拠なし** | △ |
| C-35 | Agent の具体的なスペック（CPU/メモリ） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ビルドログ保持期間**: Azure DevOps の組織設定に依存するため、リポジトリ内ファイルからは確認不可
  - 候補：Azure DevOps 管理画面 / 組織ポリシー設定
- **監視ダッシュボード設定**: Azure DevOps のダッシュボード設定はリポジトリ外管理
  - 候補：Azure DevOps プロジェクト設定
- **Agent ハードウェアスペック**: Azure DevOps Agent Pool の設定はリポジトリ外管理
  - 候補：Azure DevOps Agent Pool 設定 / Microsoft Docs

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - CI/CDパイプライン構成（設定ファイルで明確に確認可能）
- **0: 低リスク** - SDK/ツールバージョン（global.json で明確に定義）
- **0: 低リスク** - NuGet フィード構成（NuGet.config で明確に定義）
- **1: 中リスク** - バックアップ保持期間（一部推測値を含む）
- **1: 中リスク** - 監視設計（外部サービス設定に依存）
- **0: 低リスク** - 開発環境構成（Dev Container 設定で確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] global.json のバージョン情報が最新のプロジェクト要件と一致しているか確認
- [ ] azure-pipelines.yml のトリガー設定がブランチ戦略と整合しているか確認
- [ ] NuGet.config のフィード設定が組織のセキュリティポリシーに準拠しているか確認
- [ ] VSDrop 保持期間（90日）がコンプライアンス要件を満たしているか確認
- [ ] Helix Queue の設定がテスト要件を網羅しているか確認
- [ ] バックアップ保持期間の推測値について、実際のAzure DevOps設定を確認
