# インフラ構成図

## 全体システム構成図

```mermaid
graph TB
    subgraph "ソースコード管理"
        GitHub["GitHub<br/>dotnet/roslyn"]
    end

    subgraph "CI/CD プラットフォーム"
        AzureDevOps["Azure DevOps<br/>Azure Pipelines"]

        subgraph "パイプライン種別"
            PR["PR Validation<br/>azure-pipelines.yml"]
            Official["Official Build<br/>azure-pipelines-official.yml"]
            Integration["Integration Tests<br/>azure-pipelines-integration.yml"]
            Compliance["Compliance<br/>azure-pipelines-compliance.yml"]
        end
    end

    subgraph "ビルドエージェント"
        subgraph "Windows Agents"
            WinVS2022["Windows VS2022 Preview<br/>windows.vs2022preview.scout.amd64"]
            WinVS2026["Windows VS2026 Preview<br/>windows.vs2026preview.scout.amd64"]
            Win1ES["Windows 1ES<br/>1es-windows-2022"]
        end

        subgraph "Linux Agents"
            Ubuntu["Ubuntu 22.04<br/>Build.Ubuntu.2204.Amd64"]
            CentOS["CentOS Stream 9<br/>Source Build Container"]
        end

        subgraph "macOS Agents"
            macOS["macOS 15<br/>macOS-15"]
        end
    end

    subgraph "テスト実行基盤"
        Helix["Microsoft Helix<br/>分散テスト実行"]

        subgraph "Helix Queues"
            HelixWin["Windows.10.Amd64"]
            HelixWinVS["windows.amd64.vs2022.pre"]
            HelixWinES["Windows.10.Amd64.Server2022.ES"]
            HelixUbuntu["Ubuntu.2204.Amd64"]
            HelixMac["OSX.15.Amd64"]
        end
    end

    subgraph "成果物ストレージ"
        Artifacts["Azure DevOps<br/>Artifacts"]
        NuGet["NuGet Feeds<br/>dnceng/azure-public"]
        VSDrop["VS Drop Storage<br/>devdiv.artifacts.visualstudio.com"]
        SymbolServer["Microsoft Symbol Server<br/>msdl.microsoft.com"]
    end

    subgraph "配布先"
        VSInsert["Visual Studio<br/>Insertion"]
        NuGetOrg["nuget.org<br/>パブリック配布"]
    end

    GitHub --> AzureDevOps
    AzureDevOps --> PR
    AzureDevOps --> Official
    AzureDevOps --> Integration
    AzureDevOps --> Compliance

    PR --> WinVS2022
    PR --> WinVS2026
    PR --> Ubuntu

    Official --> Win1ES
    Official --> WinVS2022

    WinVS2022 --> Helix
    WinVS2026 --> Helix
    Ubuntu --> Helix
    macOS --> Helix

    Helix --> HelixWin
    Helix --> HelixWinVS
    Helix --> HelixWinES
    Helix --> HelixUbuntu
    Helix --> HelixMac

    Official --> Artifacts
    Official --> NuGet
    Official --> VSDrop
    Official --> SymbolServer

    VSDrop --> VSInsert
    NuGet --> NuGetOrg
```

## ビルドパイプラインフロー

```mermaid
flowchart TD
    subgraph "Trigger"
        Push["Push to main/release/*"]
        PROpen["PR Open/Update"]
        Schedule["Scheduled Build"]
    end

    subgraph "Build Stage"
        WinDebug["Windows Debug Build"]
        WinRelease["Windows Release Build"]
        UnixBuild["Unix Build"]
        MacBuild["macOS Build"]
        SourceBuild["Source Build"]
    end

    subgraph "Test Stage"
        subgraph "Windows Tests"
            WinDesktopDebug["Windows Desktop Debug<br/>x86/x64"]
            WinDesktopRelease["Windows Desktop Release<br/>x86/x64"]
            WinCoreClrDebug["Windows CoreClr Debug"]
            WinCoreClrRelease["Windows CoreClr Release"]
            WinIOperation["IOperation Tests"]
            WinRuntimeAsync["RuntimeAsync Tests"]
            WinUsedAssemblies["UsedAssemblies Tests"]
        end

        subgraph "Unix Tests"
            LinuxDebug["Linux Debug Tests"]
            MacDebug["macOS Debug Tests"]
        end
    end

    subgraph "Correctness Stage"
        Determinism["Determinism Check"]
        BootstrapDefault["Bootstrap Build Default"]
        BootstrapFramework["Bootstrap Build Framework"]
        Rebuild["Rebuild Validation"]
        Analyzers["Analyzer Check"]
        TodoCheck["TODO Check"]
        BuildArtifacts["Build Artifacts Validation"]
    end

    subgraph "Publish Stage"
        PublishArtifacts["Publish Artifacts"]
        PublishNuGet["Publish NuGet Packages"]
        PublishVSDrop["Publish to VS Drop"]
        PublishSymbols["Publish Symbols"]
    end

    subgraph "Insert Stage"
        VSInsert["VS Insertion PR"]
    end

    Push --> WinDebug & WinRelease & UnixBuild & MacBuild & SourceBuild
    PROpen --> WinDebug & WinRelease & UnixBuild & SourceBuild
    Schedule --> WinDebug & WinRelease & UnixBuild & MacBuild

    WinDebug --> WinDesktopDebug & WinCoreClrDebug & WinIOperation & WinRuntimeAsync & WinUsedAssemblies
    WinRelease --> WinDesktopRelease & WinCoreClrRelease
    UnixBuild --> LinuxDebug
    MacBuild --> MacDebug

    WinDebug & WinRelease --> Determinism & BootstrapDefault & BootstrapFramework & Rebuild & Analyzers & TodoCheck & BuildArtifacts

    WinCoreClrRelease --> PublishArtifacts --> PublishNuGet & PublishVSDrop & PublishSymbols

    PublishVSDrop --> VSInsert
```

## Agent Pool 構成

```mermaid
graph LR
    subgraph "Public Project"
        PublicPool["NetCore-Public"]

        subgraph "Public Agents"
            PubWin["windows.vs2022preview.scout.amd64.open"]
            PubWin2["windows.vs2026preview.scout.amd64.open"]
            PubUbuntu["Build.Ubuntu.2204.Amd64.Open"]
            PubWin1ES["1es-windows-2022-open"]
        end
    end

    subgraph "Internal Project"
        InternalPool["NetCore1ESPool-Internal"]

        subgraph "Internal Agents"
            IntWin["windows.vs2022preview.scout.amd64"]
            IntWin2["windows.vs2026preview.scout.amd64"]
            IntUbuntu["Build.Ubuntu.2204.Amd64"]
            IntWin1ES["1es-windows-2022"]
        end
    end

    PublicPool --> PubWin & PubWin2 & PubUbuntu & PubWin1ES
    InternalPool --> IntWin & IntWin2 & IntUbuntu & IntWin1ES
```

## Helix テスト実行構成

```mermaid
graph TB
    subgraph "Test Submission"
        TestArtifacts["Test Artifacts<br/>Transport_Artifacts_*"]
        HelixSDK["Helix SDK<br/>Microsoft.DotNet.Helix.Sdk"]
    end

    subgraph "Helix Service"
        HelixAPI["Helix API<br/>HelixApiAccessToken"]
        HelixQueue["Queue Manager"]
    end

    subgraph "Windows Queues"
        WinQueue["Windows.10.Amd64"]
        WinVSQueue["windows.amd64.vs2022.pre"]
        WinESQueue["Windows.10.Amd64.Server2022.ES<br/>Spanish Locale"]
    end

    subgraph "Linux Queues"
        UbuntuQueue["Ubuntu.2204.Amd64"]
    end

    subgraph "macOS Queues"
        MacQueue["OSX.15.Amd64"]
    end

    subgraph "Test Results"
        XUnitResults["xUnit XML Results"]
        HelixLogs["Helix Logs"]
    end

    TestArtifacts --> HelixSDK --> HelixAPI --> HelixQueue

    HelixQueue --> WinQueue & WinVSQueue & WinESQueue
    HelixQueue --> UbuntuQueue
    HelixQueue --> MacQueue

    WinQueue & WinVSQueue & WinESQueue --> XUnitResults
    UbuntuQueue --> XUnitResults
    MacQueue --> XUnitResults

    WinQueue & WinVSQueue & WinESQueue --> HelixLogs
    UbuntuQueue --> HelixLogs
    MacQueue --> HelixLogs
```

## パッケージ配布構成

```mermaid
graph TB
    subgraph "Build Output"
        Packages["NuGet Packages<br/>artifacts/packages"]
        VSIX["VSIX Packages<br/>artifacts/VSSetup"]
        Symbols["Symbol Files<br/>PDB Artifacts"]
    end

    subgraph "NuGet Feeds"
        subgraph "dnceng Feeds"
            DotNetEng["dotnet-eng"]
            DotNetTools["dotnet-tools"]
            DotNetPublic["dotnet-public"]
            DotNet10["dotnet10/dotnet11"]
        end

        subgraph "azure-public Feeds"
            VSSDK["vssdk"]
            VSImpl["vs-impl"]
            VSBuildServices["vs-buildservices"]
        end

        subgraph "DevDiv Feeds"
            VS["VS Package Feed"]
        end
    end

    subgraph "External Distribution"
        NuGetOrg["nuget.org"]
        SymbolServer["Microsoft Symbol Server"]
        VSDrop["VS Drop Storage"]
    end

    subgraph "Consumers"
        VSInsert["Visual Studio"]
        DevKit["VS Code DevKit"]
        OmniSharp["OmniSharp"]
    end

    Packages --> DotNetEng & DotNetTools & DotNetPublic & DotNet10
    Packages --> VSSDK & VSImpl & VSBuildServices
    Packages --> VS
    Packages --> NuGetOrg

    VSIX --> VSDrop --> VSInsert

    Symbols --> SymbolServer

    NuGetOrg --> DevKit & OmniSharp
    VSImpl --> DevKit
```

## 開発環境構成

```mermaid
graph TB
    subgraph "Local Development"
        DevMachine["Developer Machine"]

        subgraph "IDE Options"
            VS["Visual Studio 2022/2026"]
            VSCode["VS Code"]
            Rider["JetBrains Rider"]
        end
    end

    subgraph "Container Development"
        DevContainer["Dev Container"]
        Codespaces["GitHub Codespaces"]

        subgraph "Container Image"
            DotNetSDK["mcr.microsoft.com/dotnet/sdk:8.0"]
            DotNet10SDK[".NET SDK 10.0.102"]
            Git["Git/Curl"]
        end
    end

    subgraph "Build Scripts"
        BuildPS1["eng/build.ps1"]
        BuildSH["eng/build.sh"]
        RestorePS1["eng/restore.sh"]
    end

    DevMachine --> VS & VSCode & Rider
    VS & VSCode --> BuildPS1 & BuildSH

    DevContainer --> DotNetSDK --> DotNet10SDK --> Git
    Codespaces --> DevContainer

    DevContainer --> RestorePS1 --> BuildSH
```
