# インフラ設計書

## 概要

本ドキュメントは、Microsoft Roslyn（.NET Compiler Platform）プロジェクトのインフラストラクチャ構成を記述するものです。Roslynは、C#およびVisual Basic コンパイラをオープンソースで提供するプロジェクトであり、Azure DevOps/Azure Pipelinesを基盤としたCI/CDインフラストラクチャを採用しています。

## システム構成

### 全体構成

Roslynプロジェクトは、以下の主要なインフラストラクチャコンポーネントで構成されています：

1. **ソースコード管理**: GitHub（dotnet/roslyn リポジトリ）
2. **CI/CDプラットフォーム**: Azure DevOps / Azure Pipelines
3. **ビルドエージェント**: Azure DevOps Agent Pools（Windows/Ubuntu/macOS）
4. **テスト実行基盤**: Microsoft Helix（分散テスト実行システム）
5. **パッケージ配布**: NuGet / Azure DevOps Artifacts
6. **開発環境**: VS Code Dev Containers / GitHub Codespaces

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Windows Build Agent | Windows環境でのビルド・テスト | VS 2022 Preview/2026 Preview (windows.vs2022preview.scout.amd64, windows.vs2026preview.scout.amd64) | オンデマンド |
| Ubuntu Build Agent | Linux環境でのビルド・テスト | Ubuntu 22.04 Amd64 (Build.Ubuntu.2204.Amd64) | オンデマンド |
| macOS Build Agent | macOS環境でのビルド・テスト | macOS 15 (OSX.15.Amd64) | オンデマンド |
| Helix Windows Agent | Windows分散テスト実行 | Windows 10 Amd64 | オンデマンド |
| Helix Ubuntu Agent | Linux分散テスト実行 | Ubuntu 22.04 Amd64 | オンデマンド |
| Helix macOS Agent | macOS分散テスト実行 | OSX 15 Amd64 | オンデマンド |
| Source Build Agent | ソースビルド検証 | CentOS Stream 9 Container | オンデマンド |

### ネットワーク構成

#### Azure DevOps ネットワーク

- **パブリックプロジェクト**: `NetCore-Public` プールを使用（オープンソースコントリビューター向け）
- **内部プロジェクト**: `NetCore1ESPool-Internal` プールを使用（Microsoft 内部向け）
- **ドロップストレージ**: `devdiv.artifacts.visualstudio.com` への接続

#### NuGet パッケージソース

| フィード名 | URL | 用途 |
| --- | --- | --- |
| dotnet-eng | https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-eng/nuget/v3/index.json | .NET Engineering パッケージ |
| dotnet-tools | https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-tools/nuget/v3/index.json | .NET ツール群 |
| dotnet-public | https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-public/nuget/v3/index.json | .NET パブリックパッケージ |
| vssdk | https://pkgs.dev.azure.com/azure-public/vside/_packaging/vssdk/nuget/v3/index.json | Visual Studio SDK |
| vs-impl | https://pkgs.dev.azure.com/azure-public/vside/_packaging/vs-impl/nuget/v3/index.json | VS 実装パッケージ |
| vs-buildservices | https://pkgs.dev.azure.com/azure-public/vside/_packaging/vs-buildservices/nuget/v3/index.json | VS ビルドサービス |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| .NET SDK | 10.0.102 | プロジェクトビルド基盤 |
| Visual Studio | 17.14.0 | IDE・ビルドツール |
| MSBuild | xcopy-msbuild 18.0.0 | ビルドエンジン |
| vswhere | 3.1.7 | Visual Studio検出ツール |
| Node.js | 16.x | フロントエンドツール・スクリプト実行 |
| NuGet | 4.9.2 | パッケージ管理 |
| Microsoft.DotNet.Arcade.Sdk | 11.0.0-beta.26055.1 | .NET ビルドSDK |
| Microsoft.DotNet.Helix.Sdk | 11.0.0-beta.26055.1 | Helix テスト実行SDK |
| Microsoft.Build.Traversal | 3.4.0 | MSBuild 拡張 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理・PR管理 | HTTPS (GitHub PAT) |
| Azure DevOps | CI/CD パイプライン実行 | Azure DevOps API |
| Microsoft Helix | 分散テスト実行 | Helix API (トークン認証) |
| Azure Artifacts | NuGetパッケージ配布 | Azure DevOps Artifacts API |
| Visual Studio Drop | VSIXパッケージ配布 | devdiv.artifacts.visualstudio.com |
| Microsoft Symbol Server | シンボル公開 | msdl.microsoft.com |
| 1ESPipelineTemplates | パイプラインテンプレート | Azure DevOps Git |

## スケーリング設計

### ビルドエージェントスケーリング

- **スケーリング方式**: Azure DevOps Agent Pools によるオンデマンドスケーリング
- **パブリックビルド**: NetCore-Public プール（パブリックリポジトリ向け）
- **内部ビルド**: NetCore1ESPool-Internal プール（内部リポジトリ向け）

### 並列ビルド戦略

1. **ステージ並列実行**: Windows Debug/Release、Unix、macOS ビルドが並列実行
2. **テスト並列実行**: Helixを使用した分散テスト実行
3. **マトリックスビルド**: x86/x64、CoreCLR/Desktop .NET Framework の組み合わせテスト

### トリガー条件

| ブランチパターン | トリガー条件 |
| --- | --- |
| main | 自動ビルド（CI） |
| main-vs-deps | 自動ビルド（CI） |
| release/* | 自動ビルド（CI） |
| features/* | 自動ビルド（CI） |
| PR to main/release/* | PRビルド |

## 可用性設計

### 冗長構成

- **マルチプラットフォームビルド**: Windows、Linux、macOS での並列ビルド・テスト
- **マルチランタイムテスト**: CoreCLR、Desktop .NET Framework でのテスト実行
- **アーキテクチャ別テスト**: x86、x64、ARM64 対応

### フェイルオーバー方式

- **ビルドリトライ**: Azure Pipelines の標準リトライ機能を使用
- **テストリトライ**: Helix によるテストリトライ機能
- **エージェント切り替え**: Agent Pool内の別エージェントへの自動切り替え

### ブランチ保護

- **main/release ブランチ**: 必須CIチェック、PRレビュー必須
- **Official Build**: 署名付きビルド、セキュリティスキャン必須

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git（GitHub） | リアルタイム（コミット単位） | 無期限 |
| ビルド成果物 | Azure Pipelines Artifacts | ビルド毎 | 30日（デフォルト） |
| NuGetパッケージ | Azure Artifacts | パッケージ公開毎 | 無期限 |
| VSDrop成果物 | Visual Studio Drop Storage | ビルド毎 | 90日 |
| OptProf データ | Artifact Services | ビルド毎 | 90日 |
| ビルドログ | Azure Pipelines | ビルド毎 | 30日 |

## 監視設計

### ビルド監視

- **Azure DevOps Dashboard**: ビルド状態、テスト結果の可視化
- **Build Badge**: README.md にビルド状態バッジを表示
- **通知**: Azure DevOps によるビルド失敗時のメール/Teams通知

### セキュリティ監視

- **CodeQL**: コード品質・セキュリティ分析（Official Build時）
- **TSA (Token Security Analysis)**: シークレット漏洩検出
- **PoliCheck**: ポリシーチェック（Official Build時）
- **BinSkim**: バイナリセキュリティ分析
- **CredScan**: 認証情報漏洩スキャン

### テスト監視

- **Test Results**: Azure DevOps Test Results による集計
- **Helix Portal**: 分散テスト結果の詳細確認
- **xUnit Test Results**: XMLレポートによるテスト結果公開

## 開発環境

### Dev Container 構成

```dockerfile
FROM mcr.microsoft.com/dotnet/sdk:8.0
# .NET SDK 10.0.102 をインストール
# curl, git をインストール
```

### 推奨VS Code拡張機能

- ms-dotnettools.csharp
- ms-dotnettools.csdevkit
- EditorConfig.EditorConfig
- ms-vscode.powershell
- tintoy.msbuild-project-tools
- ms-azure-devops.azure-pipelines

## 備考

### 特記事項

1. **1ES Pipeline Templates**: Microsoft内部向けセキュリティ・コンプライアンス準拠のパイプラインテンプレートを使用
2. **IBC (Instrumentation-Based Compilation)**: 最適化データを使用したパフォーマンス最適化
3. **Source Build**: .NET ソースビルド互換性の維持
4. **VS Insertion**: Visual Studio への自動インサーション機能

### 制約事項

1. Official Build は `refs/heads/main` または `refs/heads/release/*` ブランチでのみ実行
2. CodeQL は Official Build 時のみ有効
3. macOS ビルドは PR ビルド時はスキップ（リソース節約）
