---
generated_at: 2026-02-10 15:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **監査ログの保持期間**：運用ドキュメントでの確認が必要
  2. **CoreCLR環境での鍵コンテナ制限**：プラットフォーム固有の制約

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilers/Core/Portable/StrongName/StrongNameKeys.cs`
- E-02: `src/Compilers/Core/Portable/StrongName/StrongNameProvider.cs`
- E-03: `src/Compilers/Core/Portable/StrongName/DesktopStrongNameProvider.cs`
- E-04: `src/Compilers/Core/Portable/StrongName/CryptoBlobParser.cs`
- E-05: `src/Compilers/Core/Portable/PEWriter/SigningUtilities.cs`
- E-06: `src/Compilers/Core/Portable/CryptographicHashProvider.cs`
- E-07: `src/Compilers/Core/Portable/IVTConclusion.cs`
- E-08: `src/Compilers/Core/Portable/Symbols/ISymbolExtensions_PerformIVTCheck.cs`
- E-09: `src/Compilers/Core/Portable/Compilation/DeterministicKeyBuilder.cs`
- E-10: `src/Compilers/Core/Portable/Symbols/Attributes/AttributeDescription.cs`
- E-11: `src/Compilers/Core/Portable/Symbols/Attributes/CommonTypeWellKnownAttributeData.cs`
- E-12: `src/Compilers/CSharp/Test/Emit3/Attributes/AttributeTests_Security.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StrongName署名によりアセンブリの発行元を証明 | E-01, E-02, E-03 | ○ |
| C-02 | PublicKeyによるアセンブリ同一性の検証 | E-01, E-04 | ○ |
| C-03 | InternalsVisibleTo検証でfriend assemblyアクセスを制御 | E-07, E-08 | ○ |
| C-04 | Strong-named Assemblyはフル信頼アクセスが可能 | E-08 | ○ |
| C-05 | Weak-named Assemblyは公開メンバーのみアクセス可能 | E-08 | ○ |
| C-06 | IVTチェックで5つの検証パターンを実装 | E-08 | ○ |
| C-07 | RSA署名にSHA-1/SHA-256を使用 | E-05 | ○ |
| C-08 | ソースファイルハッシュにSHA-1, SHA-256を使用 | E-06 | ○ |
| C-09 | アセンブリハッシュに複数のアルゴリズムをサポート | E-06 | ○ |
| C-10 | 決定論的ビルドキーにXxHash128を使用 | E-09 | ○ |
| C-11 | ECMA-335準拠のためSHA-1を使用（レガシー互換性） | E-05, E-06 | ○ |
| C-12 | SHA-1のハッシュサイズは160bit | E-06 | ○ |
| C-13 | SHA-256のハッシュサイズは256bit | E-06 | ○ |
| C-14 | KeyPairはSNK/PFXファイルで管理 | E-01, E-03 | ○ |
| C-15 | PublicKeyはメタデータに埋め込み | E-01 | ○ |
| C-16 | KeyContainerはWindows CSPで管理 | E-01, E-03 | ○ |
| C-17 | PUBLICKEYBLOBタイプは0x06 | E-04 | ○ |
| C-18 | PRIVATEKEYBLOBタイプは0x07 | E-04 | ○ |
| C-19 | 公開鍵文字列は16進数形式で検証 | E-01 | ○ |
| C-20 | CryptoBlobParserで暗号ブロブの構造検証を実施 | E-04 | ○ |
| C-21 | SecurityCriticalAttributeを認識・処理 | E-10, E-11 | ○ |
| C-22 | SuppressUnmanagedCodeSecurityAttributeを認識・処理 | E-11 | ○ |
| C-23 | PrincipalPermissionAttributeを認識・処理 | E-10, E-12 | ○ |
| C-24 | 決定論的ビルドでコンパイラバージョンを記録 | E-09 | ○ |
| C-25 | 決定論的ビルドでソースファイルチェックサムを記録 | E-09 | ○ |
| C-26 | 決定論的ビルドで公開鍵を記録 | E-09 | ○ |
| C-27 | 監査ログの保持期間はコンパイル実行時のみ | **根拠なし** | △ |
| C-28 | CoreCLR/非Windows環境では鍵コンテナ署名が使用不可 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- C-27: 監査ログの保持期間について
  - コード上ではログの永続化機能は確認できませんでしたが、ビルドシステムやCI/CD環境での運用方法は確認が必要です
  - 候補：運用マニュアル / CI/CD設定 / ビルドシステム設定

## 5) リスクフラグ（レビュー観点）

| リスク項目 | レベル | 説明 |
|---|---|---|
| SHA-1の使用 | 1: 中リスク | ECMA-335準拠のため使用されているが、暗号学的には脆弱性あり。コメントで明示的に記載されている |
| MD5の使用 | 1: 中リスク | レガシー互換のためサポート。新規使用は非推奨 |
| 鍵ファイルのキャッシュ | 0: 低リスク | IDE操作の高速化のためキャッシュを使用。メモリ内のみで永続化なし |

## 6) レビュアーチェックリスト（最小）

- [ ] StrongName署名の実装がE-01, E-02, E-03と整合しているか確認
- [ ] IVTチェックの5パターンがE-08のコードと一致しているか確認
- [ ] セキュリティ属性の一覧がE-10, E-11の定義と整合しているか確認
- [ ] 暗号アルゴリズムのサポート状況がE-06と一致しているか確認
- [ ] 決定論的ビルドの記録項目がE-09と整合しているか確認
- [ ] 監査ログの保持期間について運用観点での確認が必要
