---
generated_at: 2026-02-10 15:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な設定ファイルが確認できず
  2. **担当チーム区分**：組織構成に関する明示的な情報なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `azure-pipelines.yml`
- E-02: `azure-pipelines-integration.yml`
- E-03: `azure-pipelines-pr-validation.yml`
- E-04: `azure-pipelines-compliance.yml`
- E-05: `eng/pipelines/test-windows-job.yml`
- E-06: `eng/pipelines/test-unix-job.yml`
- E-07: `eng/pipelines/test-integration-helix.yml`
- E-08: `eng/config/xunit.runner.json`
- E-09: `src/Compilers/Core/CodeAnalysisTest/Microsoft.CodeAnalysis.UnitTests.csproj`
- E-10: `src/VisualStudio/IntegrationTest/New.IntegrationTests/Microsoft.VisualStudio.LanguageServices.New.IntegrationTests.csproj`
- E-11: `eng/targets/Settings.props`
- E-12: `.github/workflows/pr-validation.yml`
- E-13: `.github/workflows/labeler-*.yml`（複数ワークフロー）
- E-14: `src/Test/Perf/tests/Roslyn.PerformanceTests.csproj`
- E-15: `56個以上のUnitTestsプロジェクト（Glob検索結果）`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | xUnitがテストフレームワークとして使用されている | E-08, E-09, E-10 | ○ |
| C-02 | Moqがモックライブラリとして使用されている | E-09 | ○ |
| C-03 | Azure Pipelinesがメインのci/cdとして使用されている | E-01, E-02, E-03, E-04 | ○ |
| C-04 | Helixが分散テスト実行基盤として使用されている | E-05, E-06, E-07 | ○ |
| C-05 | Windows Debug/Releaseビルドステージが存在する | E-01 | ○ |
| C-06 | Unix/macOSビルドステージが存在する | E-01 | ○ |
| C-07 | Visual Studio統合テストが実施される | E-02, E-07, E-10 | ○ |
| C-08 | 決定性テストがCorrectnessステージで実施される | E-01 | ○ |
| C-09 | 再構築テストがCorrectnessステージで実施される | E-01 | ○ |
| C-10 | アナライザテストがCorrectnessステージで実施される | E-01 | ○ |
| C-11 | Windows Desktop x86/x64テストが実施される | E-01, E-05 | ○ |
| C-12 | Windows CoreClrテストが実施される | E-01, E-05 | ○ |
| C-13 | IOperationテストが存在する | E-01 | ○ |
| C-14 | RuntimeAsyncテストが存在する | E-01 | ○ |
| C-15 | UsedAssembliesテストが存在する | E-01 | ○ |
| C-16 | シャドウコピーが無効化されている | E-08 | ○ |
| C-17 | テストコレクションの並列実行が無効化されている | E-08 | ○ |
| C-18 | UIAComWrapperがUI自動化に使用されている | E-10 | ○ |
| C-19 | InputSimulatorPlusが操作シミュレーションに使用されている | E-10 | ○ |
| C-20 | BuildBossがビルド成果物検証に使用されている | E-01 | ○ |
| C-21 | GitHub Actionsがラベル自動付与に使用されている | E-12, E-13 | ○ |
| C-22 | パフォーマンステストプロジェクトが存在する | E-14 | ○ |
| C-23 | 56以上のUnitTestプロジェクトが存在する | E-15 | ○ |
| C-24 | スペイン語環境でのローカライゼーションテストが実施される | E-01 | ○ |
| C-25 | Source Build検証が実施される | E-01 | ○ |
| C-26 | テスト結果がXUnit形式で公開される | E-02, E-03 | ○ |
| C-27 | カバレッジ目標値が設定されている | **根拠なし** | △ |
| C-28 | 担当チームが開発チーム/QAチームに分かれている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値**: プロジェクト内にCoverlet等のコードカバレッジツール設定が確認できませんでした。明示的なカバレッジ目標は設定されていない可能性があります。
  - 候補：eng/config/ / Directory.Build.props / *.csproj内PackageReference
- **担当チーム区分**: 開発チーム・QAチームの区分は一般的なソフトウェア開発プラクティスに基づく推定です。実際の組織構成は別途確認が必要です。
  - 候補：CONTRIBUTING.md / チームドキュメント / 社内Wiki

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テストフレームワーク（xUnit, Moq）の使用
- **0: 低リスク** - CI/CDパイプライン構成（Azure Pipelines, GitHub Actions）
- **0: 低リスク** - テスト環境（Windows, Linux, macOS）
- **1: 中リスク** - カバレッジ目標値（明示的設定未確認、ただし広範なテストスイートあり）
- **0: 低リスク** - Helix分散テスト基盤
- **1: 中リスク** - 担当チーム区分（推定に基づく記載）

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標について、プロジェクトオーナーに確認し、必要であれば目標値を設定または記載を修正
- [ ] 担当チーム区分について、実際の組織構成を確認し、必要であれば記載を修正
- [ ] Helix分散テスト基盤の詳細設定について、追加情報が必要か確認
- [ ] パフォーマンステストの詳細な実施方法・閾値について追加情報が必要か確認
- [ ] セキュリティテスト（azure-pipelines-compliance.yml）の詳細について追加情報が必要か確認
