# テスト方針書

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）プロジェクトのテスト方針を定義します。Roslynは、C#およびVisual Basicコンパイラ、IDE機能、コード分析API、スクリプティング機能を提供する大規模プロジェクトであり、包括的なテスト戦略により品質を担保しています。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | コンパイラ、IDE機能、Workspaces、Features等の個別コンポーネントの機能検証 | 開発チーム |
| 結合テスト | コンパイラとIDE、Language Server Protocol等のコンポーネント間連携の検証 | 開発チーム |
| システムテスト | Visual Studio統合環境でのE2Eテスト、実際のIDE操作をシミュレート | QAチーム/開発チーム |
| 受入テスト | リリース前のパフォーマンス・決定性・正確性検証 | QAチーム |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | コンパイラ、IDE機能、Workspaces、Language Server等の機能検証 | CI/CDパイプライン（PR時およびコミット時） |
| 性能テスト | コンパイラ・IDE機能のパフォーマンス測定、ベンチマーク | リリース前、定期的 |
| セキュリティテスト | セキュリティコンプライアンス検証、SDLツールによる静的解析 | 専用パイプライン（azure-pipelines-compliance.yml） |
| 決定性テスト | コンパイル結果の決定性（同一入力で同一出力）検証 | Correctnessステージ |
| 再構築テスト | ビルド成果物の再構築可能性検証 | Correctnessステージ |
| アナライザテスト | コードスタイル・品質アナライザの動作検証 | CI/CDパイプライン |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Windows Debug/Release | Windows環境での単体・結合テスト | Windows Server 2022、VS2022/VS2026 Preview |
| Windows Desktop | .NET Framework 4.7.2ベースのデスクトップテスト | Windows 10/Server 2022、x86/x64 |
| Windows CoreClr | .NET Core/10ランタイムでのテスト | Windows 10/Server 2022 |
| Linux Debug | Ubuntu環境でのCoreClrテスト | Ubuntu 22.04、AMD64 |
| macOS Debug | macOS環境でのCoreClrテスト | macOS 15、AMD64 |
| Visual Studio統合テスト | Visual Studio内でのE2E統合テスト | Windows、VS2022 Preview |
| Helix分散テスト | 大規模並列テスト実行基盤 | Windows/Ubuntu/macOS Helix Queue |
| ソースビルド | Managed環境でのソースビルド検証 | CentOS Stream 9コンテナ |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| xUnit | 単体テスト・結合テストフレームワーク | NuGetパッケージ参照 |
| Moq | モックライブラリ | NuGetパッケージ参照 |
| Microsoft.NET.Test.Sdk | テスト実行SDK | NuGetパッケージ参照 |
| RunTests | テスト実行カスタムツール | 自社開発（.NET 10） |
| Helix | 分散テスト実行基盤 | Microsoft.DotNet.Helix |
| UIAComWrapper | UI自動化テスト | NuGetパッケージ参照 |
| InputSimulatorPlus | キーボード・マウス操作シミュレーション | NuGetパッケージ参照 |
| BuildBoss | ビルド成果物検証ツール | 自社開発（.NET 4.7.2） |
| BuildValidator | 再構築可能性検証ツール | 自社開発 |
| BenchmarkDotNet | パフォーマンスベンチマーク | NuGetパッケージ参照 |
| Roslyn.Diagnostics.Analyzers | コード品質分析 | NuGetパッケージ参照 |
| Microsoft.VisualStudio.Threading.Analyzers | スレッドアナライザ | NuGetパッケージ参照 |
| Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | パフォーマンス感度分析 | NuGetパッケージ参照 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値未設定（ただし包括的なテストスイートを維持） |
| 分岐カバレッジ | 明示的な目標値未設定 |

**注記**: Roslynプロジェクトでは、コードカバレッジツール（Coverlet等）の明示的な設定は確認されていませんが、56以上のUnitTestプロジェクトによる広範なテストカバレッジを維持しています。

## テストデータ

テストデータの準備方針：

- **埋め込みリソース**: テストプロジェクト内にリソースファイルとして埋め込み（例: `EmbeddedResource`）
- **テストユーティリティ**: `Microsoft.CodeAnalysis.Test.Utilities`、`Microsoft.CodeAnalysis.CSharp.Test.Utilities`等のテストユーティリティプロジェクトを使用
- **コンパイラリソース**: `Microsoft.CodeAnalysis.Compiler.Test.Resources`によるコンパイラテスト用リソース提供
- **PDBユーティリティ**: `Roslyn.Test.PdbUtilities`によるPDBテスト用データ提供
- **ソースコード埋め込み**: 統合テストでは`EmbedAllSources=true`によりソースコードを埋め込み

## 不具合管理

不具合の管理方法：

- **Issue管理**: GitHubのIssue Trackerを使用
- **PRバリデーション**: PR作成時に自動テスト実行、失敗時はマージブロック
- **テスト結果公開**: Azure Pipelines上でXUnit Test Results形式で公開
- **ログ・アーティファクト**: 失敗時にはログ、ダンプファイル、テスト結果をパイプラインアーティファクトとして保存
- **ラベラー**: 機械学習ベースのラベル自動付与システム（GitHub Actions）

## CI/CD連携

CI/CDパイプラインでのテスト実行について：

### Azure Pipelines（メインCI/CD）

| パイプライン | 目的 | トリガー |
| --- | --- | --- |
| azure-pipelines.yml | メインビルド・テストパイプライン | main, release/*, features/*へのPush/PR |
| azure-pipelines-integration.yml | Visual Studio統合テスト | main, release/*, features/*へのPush/PR |
| azure-pipelines-pr-validation.yml | PRバリデーションビルド | 手動トリガー |
| azure-pipelines-official.yml | 公式リリースビルド | リリース時 |
| azure-pipelines-compliance.yml | セキュリティコンプライアンス | 定期的 |

### テスト実行ステージ

1. **Build Stage**: Windows Debug/Release、Unix、macOS、Source Buildの並列ビルド
2. **Test Stage**:
   - Windows Desktop (Debug/Release, x86/x64)
   - Windows CoreClr (Debug/Release, IOperation, RuntimeAsync, UsedAssemblies)
   - Unix CoreClr (Linux Debug)
   - macOS CoreClr (Debug)
3. **Integration Stage**: Visual Studio統合テスト (OOP 32/64bit)
4. **Correctness Stage**:
   - Build Artifacts検証
   - 決定性テスト
   - ブートストラップビルド
   - TODO/PROTOTYPEチェック
   - 再構築テスト
   - アナライザテスト

### Helix分散テスト

- 大規模テストスイートをHelix Queue（Windows, Ubuntu, macOS）で分散実行
- ローカル環境とHelix環境の切り替えをサポート
- 日本語/スペイン語環境でのローカライゼーションテスト

### GitHub Actions

| ワークフロー | 目的 |
| --- | --- |
| pr-validation.yml | PRバリデーション補助 |
| labeler-*.yml | Issue/PRの自動ラベル付与 |
| backport.yml | リリースブランチへのバックポート |
| copilot-setup-steps.yml | Copilot設定 |

## 備考

### xUnit設定

```json
{
  "shadowCopy": false,
  "parallelizeTestCollections": false,
  "diagnosticMessages": false
}
```

- シャドウコピー無効化によるパフォーマンス向上
- テストコレクションの並列実行無効化（テスト間の干渉防止）

### テストプロジェクト構成

プロジェクト内には56以上のUnitTestプロジェクトが存在し、以下のカテゴリに分類されます：

- **Compilers**: コンパイラ関連テスト（Syntax, Semantic, Emit, CommandLine等）
- **Workspaces**: ワークスペース機能テスト
- **Features**: IDE機能テスト
- **EditorFeatures**: エディタ機能テスト
- **LanguageServer**: Language Server Protocolテスト
- **VisualStudio**: Visual Studio統合テスト
- **Scripting**: スクリプティング機能テスト
- **RoslynAnalyzers**: アナライザテスト

### 特殊テスト

- **IOperationテスト**: コンパイラのIOperation APIの検証
- **RuntimeAsyncテスト**: 非同期ランタイム機能の検証
- **UsedAssembliesテスト**: アセンブリ参照の検証とGetEmitDiagnosticsの追加検証
- **Determinismテスト**: ブートストラップコンパイラを使用した決定性検証
