# ER図

## Roslyn SQLite永続化ストレージ ER図

```mermaid
erDiagram
    StringInfo7 {
        integer StringDataId PK "主キー（自動採番）"
        varchar Data UK "文字列データ（ユニーク）"
    }

    SolutionData7 {
        integer DataNameId PK,FK "データ名ID"
        blob Checksum "チェックサム（16バイト）"
        blob Data "バイナリデータ"
    }

    ProjectData7 {
        integer ProjectPathId PK,FK "プロジェクトパスID"
        integer ProjectNameId PK,FK "プロジェクト名ID"
        integer DataNameId PK,FK "データ名ID"
        blob Checksum "チェックサム（16バイト）"
        blob Data "バイナリデータ"
    }

    DocumentData7 {
        integer ProjectPathId PK,FK "プロジェクトパスID"
        integer ProjectNameId PK,FK "プロジェクト名ID"
        integer DocumentFolderId PK,FK "ドキュメントフォルダID"
        integer DocumentNameId PK,FK "ドキュメント名ID"
        integer DataNameId PK,FK "データ名ID"
        blob Checksum "チェックサム（16バイト）"
        blob Data "バイナリデータ"
    }

    StringInfo7 ||--o{ SolutionData7 : "DataNameId"
    StringInfo7 ||--o{ ProjectData7 : "ProjectPathId"
    StringInfo7 ||--o{ ProjectData7 : "ProjectNameId"
    StringInfo7 ||--o{ ProjectData7 : "DataNameId"
    StringInfo7 ||--o{ DocumentData7 : "ProjectPathId"
    StringInfo7 ||--o{ DocumentData7 : "ProjectNameId"
    StringInfo7 ||--o{ DocumentData7 : "DocumentFolderId"
    StringInfo7 ||--o{ DocumentData7 : "DocumentNameId"
    StringInfo7 ||--o{ DocumentData7 : "DataNameId"
```

## リレーションシップ説明

### StringInfo7（文字列マスタ）

全てのテーブルから参照される中央のマスタテーブルです。文字列データを一意のIDにマッピングし、以下のメリットを提供します：

- **ストレージ効率**: 同じ文字列（ファイルパスなど）を複数箇所で使用する際、文字列全体を重複して格納する代わりにIDを参照
- **検索効率**: 整数IDによる高速な検索が可能
- **一貫性**: 文字列の一元管理により、データの一貫性を保証

### SolutionData7（ソリューションデータ）

- `DataNameId` -> `StringInfo7.StringDataId`: 格納するデータの名前（キー）への参照

### ProjectData7（プロジェクトデータ）

- `ProjectPathId` -> `StringInfo7.StringDataId`: プロジェクトファイルのパスへの参照
- `ProjectNameId` -> `StringInfo7.StringDataId`: プロジェクト名への参照（TFM区別用）
- `DataNameId` -> `StringInfo7.StringDataId`: 格納するデータの名前への参照

### DocumentData7（ドキュメントデータ）

- `ProjectPathId` -> `StringInfo7.StringDataId`: 所属プロジェクトのパスへの参照
- `ProjectNameId` -> `StringInfo7.StringDataId`: 所属プロジェクト名への参照
- `DocumentFolderId` -> `StringInfo7.StringDataId`: ドキュメントのフォルダパスへの参照
- `DocumentNameId` -> `StringInfo7.StringDataId`: ドキュメントファイル名への参照
- `DataNameId` -> `StringInfo7.StringDataId`: 格納するデータの名前への参照

## データベース構成図

```mermaid
flowchart TB
    subgraph Application["アプリケーション層"]
        VS["Visual Studio / Roslyn"]
    end

    subgraph Storage["ストレージ層"]
        direction TB
        SQLitePS["SQLitePersistentStorage"]

        subgraph Databases["データベース"]
            direction LR
            WriteCache["writecache<br/>（インメモリDB）"]
            Main["main<br/>（ディスクDB）"]
        end

        SQLitePS --> WriteCache
        SQLitePS --> Main
        WriteCache -.->|"定期的にフラッシュ"| Main
    end

    VS --> SQLitePS

    subgraph Tables["テーブル構成（両DBに同一構造）"]
        StringInfo7T["StringInfo7"]
        SolutionData7T["SolutionData7"]
        ProjectData7T["ProjectData7"]
        DocumentData7T["DocumentData7"]
    end

    Main --> Tables
    WriteCache --> Tables
```

## 階層構造

```mermaid
graph TD
    Solution["Solution<br/>（ソリューション）"]
    Project["Project<br/>（プロジェクト）"]
    Document["Document<br/>（ドキュメント）"]

    Solution --> |"1:N"| Project
    Project --> |"1:N"| Document

    SolutionData["SolutionData7"]
    ProjectData["ProjectData7"]
    DocumentData["DocumentData7"]

    Solution -.->|"データ格納"| SolutionData
    Project -.->|"データ格納"| ProjectData
    Document -.->|"データ格納"| DocumentData
```

## 主キー構成の詳細

| テーブル | 主キー構成 | 説明 |
|----------|------------|------|
| StringInfo7 | StringDataId | 自動採番の整数ID |
| SolutionData7 | DataNameId | データ名のみで一意 |
| ProjectData7 | ProjectPathId + ProjectNameId + DataNameId | プロジェクト識別 + データ名で一意 |
| DocumentData7 | ProjectPathId + ProjectNameId + DocumentFolderId + DocumentNameId + DataNameId | プロジェクト + ドキュメント識別 + データ名で一意 |
