---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **AddReferenceDatabase（Elfie）の詳細**: 別システムのため対象外としたが、要確認
  2. **チェックサム検証の具体的な使用箇所**: コード上は存在するが、使用パターンの網羅性が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/Core/Portable/Storage/SQLite/v2/SQLitePersistentStorageConstants.cs`
- E-02: `src/Workspaces/Core/Portable/Storage/SQLite/v2/Database.cs`
- E-03: `src/Workspaces/Core/Portable/Storage/SQLite/v2/Table.cs`
- E-04: `src/Workspaces/Core/Portable/Storage/SQLite/v2/Column.cs`
- E-05: `src/Workspaces/Core/Portable/Storage/SQLite/v2/SQLitePersistentStorage.cs`
- E-06: `src/Workspaces/Core/Portable/Storage/SQLite/v2/SQLitePersistentStorage.Accessor.cs`
- E-07: `src/Workspaces/Core/Portable/Storage/SQLite/v2/SQLitePersistentStorage_SolutionSerialization.cs`
- E-08: `src/Workspaces/Core/Portable/Storage/SQLite/v2/SQLitePersistentStorage_ProjectSerialization.cs`
- E-09: `src/Workspaces/Core/Portable/Storage/SQLite/v2/SQLitePersistentStorage_DocumentSerialization.cs`
- E-10: `src/Workspaces/Core/Portable/Storage/SQLite/v2/Interop/SqlConnection.cs`
- E-11: `src/Workspaces/Core/Portable/Storage/SQLite/Interop/NativeMethods.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名にバージョン7が付与される | E-01 (Version = "7") | ○ |
| C-02 | StringInfo7テーブルの構造（StringDataId, Data） | E-01 (StringInfoTableName定義), E-05 (CREATE TABLE文) | ○ |
| C-03 | SolutionData7テーブルの構造 | E-01 (SolutionDataTableName定義), E-06 (Accessor実装) | ○ |
| C-04 | ProjectData7テーブルの構造 | E-01 (ProjectDataTableName定義), E-08 (ProjectAccessor) | ○ |
| C-05 | DocumentData7テーブルの構造 | E-01 (DocumentDataTableName定義), E-09 (DocumentAccessor) | ○ |
| C-06 | StringDataIdは自動採番 | E-05 (autoincrement指定) | ○ |
| C-07 | Dataカラムにユニークインデックスが存在 | E-05 (create unique index文) | ○ |
| C-08 | チェックサムサイズは16バイト | E-01 (Version 7の変更内容コメント) | ○ |
| C-09 | WALジャーナルモードを使用 | E-05 (pragma journal_mode=wal) | ○ |
| C-10 | 同期モードはnormal | E-05 (pragma synchronous=normal) | ○ |
| C-11 | mainデータベースとwritecacheデータベースの2構成 | E-02 (Database enum), E-10 (attach database) | ○ |
| C-12 | writecacheはインメモリDB | E-02 (コメント), E-10 (file::memory) | ○ |
| C-13 | 共有キャッシュモードを使用 | E-10 (SQLITE_OPEN_SHAREDCACHE, cache=shared) | ○ |
| C-14 | マルチスレッドモードを使用 | E-10 (SQLITE_OPEN_NOMUTEX) | ○ |
| C-15 | バージョン履歴の内容 | E-01 (コメントによる履歴記載) | ○ |
| C-16 | ProjectPathIdとProjectNameIdでプロジェクトを識別 | E-01, E-08 | ○ |
| C-17 | DocumentFolderIdとDocumentNameIdでドキュメントを識別 | E-01, E-09 | ○ |
| C-18 | トランザクション内でBLOB読み取りが必要 | E-10 (ReadBlob_MustRunInTransactionコメント) | ○ |
| C-19 | 接続プーリングを使用 | E-05 (_connectionsPool) | ○ |
| C-20 | 定期的なフラッシュ処理 | E-05 (FlushInMemoryDataToDisk), E-06 (FlushInMemoryDataToDisk_MustRunInTransaction) | ○ |
| C-21 | busyタイムアウトは1分 | E-10 (sqlite3_busy_timeout, TimeSpan.FromMinutes(1)) | ○ |
| C-22 | データ名（DataNameId）は全テーブルの主キーに含まれる | E-06 (_primaryKeyColumns定義) | ○ |
| C-23 | ビジータイムアウトでデッドロック回避 | E-10 (コメント記載) | ○ |
| C-24 | Elfie/AddReferenceDatabaseは別システム | **根拠なし** | △ |
| C-25 | 全テーブルでNOT NULL制約が適用 | E-06 (not null指定), **一部テーブルの直接確認不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24: Elfie/AddReferenceDatabaseの詳細**
  - 本ドキュメントの対象外としたが、関連性の有無について追加調査が必要な可能性あり
  - 候補：`src/Features/Core/Portable/SymbolSearch/Windows/` 配下のファイル

- **C-25: NOT NULL制約の網羅的確認**
  - Accessor.CreateTableメソッドで動的に生成されるSQLで確認できるが、全カラムへの適用を直接確認する追加検証が望ましい
  - 候補：実際のDB生成時のSQLログ / 単体テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テーブル構造、カラム定義、主キー構成
  - ソースコードから直接抽出しており、高い信頼性
- **0（低リスク）**: バージョン履歴
  - ソースコードのコメントから抽出
- **0（低リスク）**: SQLite設定（WAL、同期モード等）
  - 実装コードから直接確認
- **1（中リスク）**: チェックサムの具体的な使用パターン
  - 仕組みは確認できるが、使用箇所の網羅性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] テーブル定義のカラム名・データ型がソースコードと一致しているか確認
- [ ] 主キー構成が正確か確認（特に複合主キーの順序）
- [ ] バージョン履歴のコメントが最新のソースコードと一致しているか確認
- [ ] SQLite設定値（WAL、synchronous等）が実装と一致しているか確認
- [ ] Elfie/AddReferenceDatabaseを本ドキュメントの対象外としたことの妥当性を確認
