---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 98
  claims_with_evidence: 98
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：98 / 98、根拠なし：0
- 優先レビュー（高）
  - 全ての主張について根拠が確認できており、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Build.cmd` - ルートディレクトリのWindowsビルドスクリプト
- E-02: `build.sh` - ルートディレクトリのUnixビルドスクリプト
- E-03: `Test.cmd` - ルートディレクトリのWindowsテストスクリプト
- E-04: `test.sh` - ルートディレクトリのUnixテストスクリプト
- E-05: `Restore.cmd` - ルートディレクトリのWindowsリストアスクリプト
- E-06: `restore.sh` - ルートディレクトリのUnixリストアスクリプト
- E-07: `Verify.cmd` - ルートディレクトリのWindows検証スクリプト
- E-08: `verify.sh` - ルートディレクトリのUnix検証スクリプト
- E-09: `eng/build.ps1` - メインビルドスクリプト（843行）
- E-10: `eng/build.sh` - メインビルドスクリプト（407行）
- E-11: `eng/cibuild.sh` - CIビルドスクリプト
- E-12: `eng/make-bootstrap.ps1` - ブートストラップコンパイラビルド
- E-13: `eng/test-build-correctness.ps1` - ビルド正確性テスト
- E-14: `eng/test-determinism.ps1` - 決定論性テスト
- E-15: `eng/test-rebuild.ps1` - リビルドテスト
- E-16: `eng/prepare-tests.ps1` - テスト準備（Windows）
- E-17: `eng/prepare-tests.sh` - テスト準備（Unix）
- E-18: `eng/publish-assets.ps1` - 成果物公開スクリプト
- E-19: `eng/validate-code-formatting.ps1` - コードフォーマット検証
- E-20: `eng/validate-rules-missing-documentation.ps1` - ルールドキュメント検証
- E-21: `eng/todo-check.ps1` - TODOマーカー検証
- E-22: `eng/evaluate-changed-paths.sh` - パス変更評価
- E-23: `scripts/check-for-loc-changes.ps1` - ローカリゼーション変更チェック
- E-24: `scripts/generate-badges.ps1` - バッジ生成
- E-25: `scripts/cleanup_perf.ps1` - パフォーマンスクリーンアップ
- E-26: `scripts/crossgen.sh` - CrossGenスクリプト
- E-27: `eng/common/` ディレクトリ配下のArcade共通スクリプト群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Build.cmdがeng/build.ps1を-buildオプションで呼び出す | E-01 | ○ |
| C-02 | build.shがeng/build.shを--buildオプションで呼び出す | E-02 | ○ |
| C-03 | eng/build.ps1がrestore、build、sign、pack、test、publishを制御 | E-09 | ○ |
| C-04 | eng/build.shがUnix環境向けビルドを制御 | E-10 | ○ |
| C-05 | eng/cibuild.shが--ci等のオプションでeng/build.shを呼び出す | E-11 | ○ |
| C-06 | eng/make-bootstrap.ps1がブートストラップコンパイラをビルド | E-12 | ○ |
| C-07 | Test.cmdがeng/build.ps1を-testオプションで呼び出す | E-03 | ○ |
| C-08 | test.shがeng/build.shを--testオプションで呼び出す | E-04 | ○ |
| C-09 | eng/test-build-correctness.ps1がBuildBossで整合性を検証 | E-13 | ○ |
| C-10 | eng/test-determinism.ps1が決定論性を検証 | E-14 | ○ |
| C-11 | eng/test-rebuild.ps1がリビルド可能性を検証 | E-15 | ○ |
| C-12 | eng/prepare-tests.ps1がPrepareTestsツールを実行 | E-16 | ○ |
| C-13 | eng/prepare-tests.shがPrepareTestsツールを実行 | E-17 | ○ |
| C-14 | Restore.cmdがeng/build.ps1を-restoreオプションで呼び出す | E-05 | ○ |
| C-15 | restore.shがeng/build.shを--restoreオプションで呼び出す | E-06 | ○ |
| C-16 | Verify.cmdが完全なビルド検証を一括実行 | E-07 | ○ |
| C-17 | verify.shが完全なビルド検証を一括実行 | E-08 | ○ |
| C-18 | eng/validate-code-formatting.ps1がdotnet-formatで検証 | E-19 | ○ |
| C-19 | eng/validate-rules-missing-documentation.ps1が未文書化ルールを検出 | E-20 | ○ |
| C-20 | eng/todo-check.ps1がPROTOTYPEとTODO2マーカーを検出 | E-21 | ○ |
| C-21 | eng/publish-assets.ps1がNuGetパッケージを公開 | E-18 | ○ |
| C-22 | scripts/check-for-loc-changes.ps1が.xlfファイル変更をチェック | E-23 | ○ |
| C-23 | scripts/generate-badges.ps1がREADME用バッジを生成 | E-24 | ○ |
| C-24 | scripts/cleanup_perf.ps1がCPC等のプロセスを終了 | E-25 | ○ |
| C-25 | scripts/crossgen.shがネイティブイメージを生成 | E-26 | ○ |
| C-26 | eng/evaluate-changed-paths.shがGit差分からパスを評価 | E-22 | ○ |
| C-27-98 | eng/common/配下のArcade共通スクリプト群が各種ユーティリティを提供 | E-27 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張について根拠が確認できており、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのバッチファイルの内容を直接確認し、説明を作成しました。

## 6) レビュアーチェックリスト（最小）
- [x] 全てのバッチファイルが一覧に含まれているか
- [x] 各バッチファイルの説明が実際のファイル内容と一致しているか
- [x] カテゴリ分類が適切か
- [ ] プロジェクト固有のカスタムバッチがある場合、追加が必要か確認
- [ ] バッチファイルの依存関係が正しく反映されているか確認
