# バッチ設計書 1-Build.cmd

## 概要

本ドキュメントは、RoslynプロジェクトのWindows環境向けビルドエントリーポイントスクリプト「Build.cmd」の設計仕様を記載する。

### 本バッチの処理概要

Build.cmdは、Windows環境においてRoslynプロジェクトのビルドを実行するためのコマンドラインエントリーポイントである。

**業務上の目的・背景**：Roslynコンパイラおよび関連ツールの開発において、Windows環境での統一的なビルド手段を提供する。開発者やCI/CDパイプラインが一貫した方法でビルドを実行できるようにし、ビルド手順の標準化と自動化を実現する。これにより、開発効率の向上とビルド品質の担保を図る。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプライン（Azure DevOps等）からの自動実行。コードの変更後、ビルド検証が必要な際に随時実行される。

**主要な処理内容**：
1. PowerShellの実行ポリシーをByPassに設定し、プロファイルなしでPowerShellを起動
2. eng/build.ps1スクリプトに-buildオプションを付与して呼び出し
3. コマンドライン引数をそのままeng/build.ps1に渡す

**前後の処理との関連**：本バッチはeng/build.ps1の薄いラッパーであり、実際のビルドロジックはeng/build.ps1に委譲される。リストア処理（Restore.cmd）の後に実行されることが多く、テスト処理（Test.cmd）の前に実行される。

**影響範囲**：Roslyn.slnxソリューション全体のビルド成果物（artifacts/binディレクトリ）に影響を与える。NuGetパッケージ、VSIX拡張機能、コンパイラバイナリ等が生成される。

## バッチ種別

ビルド処理（コンパイル・パッケージング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境でのみ実行可能 |
| PowerShell | PowerShell 5.0以上がインストールされていること |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| Visual Studio | msbuildEngine=vsの場合、Visual Studioがインストールされていること |

### 実行可否判定

特別な判定ロジックはなく、前提条件が満たされていれば実行可能。eng/build.ps1側で詳細な条件チェックが行われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | eng/build.ps1に渡される追加パラメータ（-configuration, -restore等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Roslyn.slnx | Solution | ビルド対象のソリューションファイル |
| ソースコード | C#/VB | コンパイル対象のソースファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | DLL/EXE | コンパイル済みバイナリ |
| artifacts/packages | NuGet | 生成されたNuGetパッケージ |
| artifacts/VSSetup | VSIX | Visual Studio拡張機能 |
| artifacts/log | binlog | MSBuildバイナリログ（-blオプション時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各プロジェクトに依存 |
| 出力先 | artifacts/bin/{Configuration}/{TargetFramework} |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. コマンドプロンプトからBuild.cmdを実行
   └─ コマンドライン引数を受け取る
2. PowerShellを起動
   └─ ExecutionPolicy: ByPass, NoProfile設定
3. eng/build.ps1を-buildオプション付きで呼び出し
   └─ 追加のコマンドライン引数を渡す
4. ビルド結果を標準出力に表示
   └─ 終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Build.cmd実行] --> B[PowerShell起動]
    B --> C[eng/build.ps1呼び出し]
    C --> D{-buildオプション付与}
    D --> E[追加引数を渡す]
    E --> F[ビルド実行]
    F --> G[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | PowerShellエラー | eng/build.ps1の実行失敗 | ログを確認し、ビルドエラーを修正 |
| 非0 | ビルドエラー | コンパイルエラー、依存関係エラー等 | エラーメッセージに従い対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. 標準出力/標準エラー出力のログを確認
3. artifacts/log配下のバイナリログ（.binlog）を確認
4. エラー内容に応じてソースコードまたは環境を修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ソリューション全体（約200プロジェクト） |
| 目標処理時間 | 環境依存（通常5-30分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの複数ビルド同時実行は推奨されない。MSBuildのノード再利用機能により競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | ビルド中 | MSBuildの進捗情報 |
| 標準エラー | エラー発生時 | コンパイルエラー、警告 |
| binlog | ビルド完了時 | 詳細なビルドログ（-blオプション時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDパイプライン |
| ビルド時間 | 環境依存 | CI/CDパイプライン |

## 備考

- 本バッチはeng/build.ps1への薄いラッパーであり、詳細なビルドロジックはeng/build.ps1を参照
- Unix環境ではbuild.shを使用すること
- 開発者向けのクイックビルドとして利用される
