# バッチ設計書 11-test-rebuild.ps1

## 概要

本ドキュメントは、Roslynプロジェクトにおけるリビルド可能性テストスクリプト（test-rebuild.ps1）の設計仕様を定義します。このバッチは、ビルド成果物がソースコードとリソースから再構築可能であることを検証し、ビルドの決定論性と再現性を保証します。

### 本バッチの処理概要

このバッチでは、Roslynコンパイラのビルド成果物（DLL、アセンブリ）がソースコードから正確に再構築できることを検証する処理を行います。BuildValidatorツールを使用して、ビルド成果物とソースコードの整合性を自動的に確認します。

**業務上の目的・背景**：コンパイラのような重要なソフトウェアにおいて、ビルドの再現性は非常に重要です。同じソースコードからは常に同じバイナリが生成されることを保証することで、セキュリティ監査、デバッグ、リリース管理の信頼性を高めます。このスクリプトは、ビルド成果物がソースコードから完全に再構築可能であることを検証し、意図しない差異やビルド環境への依存を検出します。

**バッチの実行タイミング**：CI/CDパイプラインでの継続的な検証、リリース前の品質確認時、コードレビュー後の検証時に実行されます。手動実行も可能で、ローカル開発環境での検証にも使用されます。

**主要な処理内容**：
1. オプションでブートストラップビルドを実行し、最新のコンパイラでプロジェクトをビルド
2. 一時ディレクトリの準備（Subst-TempDir）
3. .NET CLIの初期化とSDKパスの取得
4. BuildValidatorツールの実行による再構築可能性検証
5. 既知の問題があるアセンブリの除外設定

**前後の処理との関連**：このバッチは通常、eng/build.ps1によるフルビルドの後に実行されます。test-determinism.ps1（決定論性テスト）と組み合わせて使用され、ビルドの品質を多角的に検証します。

**影響範囲**：このバッチは読み取り専用の検証処理であり、artifacts/BuildValidatorディレクトリにデバッグ情報を出力しますが、ソースコードや本番ビルド成果物には影響を与えません。

## バッチ種別

検証処理 / 品質保証テスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CD時、手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプライン、手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | artifacts/obj/およびartifacts/bin/にビルド成果物が存在すること |
| BuildValidatorツール | artifacts/bin/BuildValidator/が存在すること |
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |

### 実行可否判定

-helpオプションが指定された場合はヘルプを表示して終了。それ以外の場合は検証処理を実行します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| configuration | string | No | Debug | ビルド構成（Debug/Release） |
| ci | switch | No | $false | CI環境で実行する場合に指定 |
| prepareMachine | switch | No | $false | マシン準備処理を実行するか |
| useGlobalNuGetCache | switch | No | $true | グローバルNuGetキャッシュを使用するか |
| bootstrap | switch | No | $false | ブートストラップビルドを実行するか |
| help | switch | No | - | ヘルプを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| artifacts/obj/ | DLL/アセンブリ | 検証対象のビルド成果物（オブジェクトファイル） |
| artifacts/bin/ | DLL/アセンブリ | 参照用のビルド成果物 |
| ソースコード | C#/VB | リポジトリルートのソースコード |
| .NET SDK packs | DLL | .NET SDKの参照アセンブリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/BuildValidator/ | ディレクトリ | デバッグ用の検証結果情報 |
| 標準出力 | テキスト | 検証進捗と結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | BuildValidatorが生成するデバッグ情報 |
| 出力先 | artifacts/BuildValidator/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析とヘルプ表示判定
   └─ -helpオプションの場合は使用方法を表示して終了
2. build-utils.ps1の読み込み
   └─ 共通ユーティリティ関数の初期化
3. ブートストラップビルド（オプション）
   └─ eng/build.ps1を呼び出してフルビルドを実行
4. 一時ディレクトリの準備
   └─ Subst-TempDirで作業用ディレクトリを設定
5. .NET CLIの初期化
   └─ InitializeDotNetCliでSDKパスを取得
6. BuildValidatorツールの実行
   └─ 除外リストを設定して再構築可能性を検証
7. クリーンアップ
   └─ Unsubst-TempDirで一時ディレクトリを解除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{-help?}
    B -->|Yes| C[ヘルプ表示]
    C --> D[終了 exit 0]
    B -->|No| E[build-utils.ps1読み込み]
    E --> F{-bootstrap?}
    F -->|Yes| G[ブートストラップビルド実行]
    G --> H[Subst-TempDir]
    F -->|No| H
    H --> I[.NET CLI初期化]
    I --> J[BuildValidator実行]
    J --> K{検証成功?}
    K -->|Yes| L[Unsubst-TempDir]
    K -->|No| M[エラー出力]
    L --> N[終了 exit 0]
    M --> O[Unsubst-TempDir]
    O --> P[終了 exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 一般エラー | ブートストラップビルド失敗 | ビルドログを確認し、ビルドエラーを解決 |
| 1 | 一般エラー | BuildValidator実行失敗 | artifacts/obj/の存在確認、除外リストの見直し |
| 1 | 検証エラー | 再構築不可能なアセンブリ検出 | デバッグ情報を確認し、ソースコードとの差異を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. artifacts/BuildValidatorディレクトリのデバッグ情報を確認
2. 除外リストに追加すべきアセンブリがないか確認
3. ビルド環境（.NET SDKバージョン等）を確認
4. クリーンビルドを実行して再検証

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百のアセンブリファイル |
| 目標処理時間 | 構成により異なる（数分〜数十分） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は可能ですが、同一のartifactsディレクトリを共有する場合は競合が発生する可能性があります。異なるconfigurationを使用する場合は問題ありません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ブートストラップビルド開始メッセージ |
| 進捗ログ | BuildValidator実行中 | 検証進捗（--verboseオプション） |
| エラーログ | エラー発生時 | 例外メッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| 処理時間 | 環境依存 | CI/CDパイプライン |

## 備考

- 除外リストには、再構築時に差異が発生することが既知のアセンブリが含まれています
- Semantic Search参照アセンブリはReferenceAssemblyAttributeがないため除外されています
- .NET Framework 4.7.2向けの一部アセンブリは出力差異があるため除外されています
