# バッチ設計書 12-prepare-tests.ps1

## 概要

本ドキュメントは、Roslynプロジェクトにおけるテスト準備スクリプト（prepare-tests.ps1）の設計仕様を定義します。このバッチは、Windows環境でPrepareTestsツールを実行し、テスト実行に必要なペイロードを準備します。

### 本バッチの処理概要

このバッチでは、Roslynのテストスイートを実行するために必要なファイルやアセンブリを収集し、テストペイロードディレクトリに配置する処理を行います。PrepareTestsツールを使用して、テスト実行環境を自動的に構築します。

**業務上の目的・背景**：Roslynプロジェクトは大規模なテストスイートを持っており、テスト実行には多くの依存ファイルが必要です。このスクリプトは、分散テスト実行やCI/CD環境でのテスト実行を効率化するために、テストに必要なファイルを一箇所に収集します。これにより、テスト環境の構築が簡素化され、テスト実行の信頼性が向上します。

**バッチの実行タイミング**：ビルド完了後、テスト実行前に実行されます。CI/CDパイプラインでは自動的に実行され、ローカル開発環境では手動で実行することも可能です。

**主要な処理内容**：
1. 既存のtestPayloadディレクトリの削除（クリーンな状態から開始）
2. .NET SDKの確保
3. PrepareTestsツールの実行（ソースからテストペイロードを生成）
4. テスト実行に必要なファイルの収集と配置

**前後の処理との関連**：このバッチはeng/build.ps1によるビルドの後に実行され、Test.cmdまたはtest実行の前提条件となります。ビルド成果物（artifacts/bin/PrepareTests/）が存在している必要があります。

**影響範囲**：artifacts/testPayloadディレクトリを作成・更新します。既存のtestPayloadディレクトリは削除されるため、以前のテストペイロードは失われます。

## バッチ種別

テスト準備 / 環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド後、テスト前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプライン、手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | artifacts/bin/PrepareTests/が存在すること |
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |
| Windows環境 | PowerShellが実行可能な環境 |

### 実行可否判定

PrepareTestsツールが存在しない場合は実行に失敗します。事前にビルドを完了させる必要があります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| configuration | string | No | Debug | ビルド構成（Debug/Release） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| artifacts/bin/PrepareTests/ | DLL | PrepareTestsツール本体 |
| リポジトリ全体 | 各種 | テストに必要なソースファイルと成果物 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/testPayload/ | ディレクトリ | テスト実行に必要なファイル一式 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PrepareTestsツールが生成するテストペイロード |
| 出力先 | artifacts/testPayload/ |
| 文字コード | 該当なし（バイナリファイル含む） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. build-utils.ps1の読み込み
   └─ 共通ユーティリティ関数の初期化
2. リポジトリルートへ移動
   └─ Push-Locationで作業ディレクトリを変更
3. 既存testPayloadディレクトリの削除
   └─ クリーンな状態からの開始を保証
4. .NET SDKの確保
   └─ Ensure-DotNetSdkでSDKパスを取得
5. PrepareTestsツールの実行
   └─ dotnet execでPrepareTests.dllを実行
6. 完了処理
   └─ Pop-Locationで元のディレクトリに戻る
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[build-utils.ps1読み込み]
    B --> C[Push-Location $RepoRoot]
    C --> D[testPayloadディレクトリ削除]
    D --> E[Ensure-DotNetSdk]
    E --> F[dotnet exec PrepareTests.dll]
    F --> G{成功?}
    G -->|Yes| H[Pop-Location]
    G -->|No| I[エラー出力]
    H --> J[終了 exit 0]
    I --> K[Pop-Location]
    K --> L[終了 exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 一般エラー | PrepareTests.dllが存在しない | ビルドを実行してPrepareTestsをビルド |
| 1 | 一般エラー | .NET SDKが見つからない | .NET SDKをインストール |
| 1 | 一般エラー | ディレクトリ削除失敗 | ファイルロックの解除、権限の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. PrepareTestsツールが存在するか確認
2. .NET SDKのインストール状態を確認
3. testPayloadディレクトリのロック状態を確認
4. 手動でtestPayloadディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千のファイル |
| 目標処理時間 | 数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

testPayloadディレクトリへの書き込みが発生するため、同時実行は避けるべきです。CI/CD環境では、ジョブごとに独立したワークスペースを使用することを推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | エラー発生時 | 例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| testPayload生成 | ディレクトリ未生成 | CI/CDパイプライン |

## 備考

- パーミッション問題により、testPayloadディレクトリの削除はPrepareTestsツール内ではなくスクリプト内で行われています
- configurationパラメータに応じて、異なるビルド構成のPrepareTestsツールが使用されます
- Unix環境向けには別途prepare-tests.shが用意されています
