# バッチ設計書 13-prepare-tests.sh

## 概要

本ドキュメントは、Roslynプロジェクトにおけるテスト準備スクリプト（prepare-tests.sh）の設計仕様を定義します。このバッチは、Unix/Linux/macOS環境でPrepareTestsツールを実行し、テスト実行に必要なペイロードを準備します。

### 本バッチの処理概要

このバッチでは、Roslynのテストスイートを実行するために必要なファイルやアセンブリを収集し、テストペイロードディレクトリに配置する処理を行います。Windows版のprepare-tests.ps1と同等の機能をUnix環境向けに提供します。

**業務上の目的・背景**：Roslynプロジェクトはクロスプラットフォーム対応であり、Unix系OS（Linux、macOS）でもテストを実行する必要があります。このスクリプトは、Unix環境でのテスト実行を可能にするために、テストに必要なファイルを収集します。CI/CDパイプラインでのマルチプラットフォームテストを実現し、プロジェクトの品質を保証します。

**バッチの実行タイミング**：ビルド完了後、テスト実行前に実行されます。CI/CDパイプラインでは自動的に実行され、ローカル開発環境では手動で実行することも可能です。

**主要な処理内容**：
1. スクリプトパスの解決（シンボリックリンク対応）
2. Arcade共通ツールの読み込み
3. .NET CLIの初期化
4. 既存のtestPayloadディレクトリの削除
5. PrepareTestsツールの実行（--unixオプション付き）

**前後の処理との関連**：このバッチはeng/build.shによるビルドの後に実行され、test.shまたはテスト実行の前提条件となります。ビルド成果物（artifacts/bin/PrepareTests/）が存在している必要があります。

**影響範囲**：artifacts/testPayloadディレクトリを作成・更新します。既存のtestPayloadディレクトリは削除されるため、以前のテストペイロードは失われます。

## バッチ種別

テスト準備 / 環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド後、テスト前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプライン、手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | artifacts/bin/PrepareTests/Debug/net10.0/が存在すること |
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |
| Unix環境 | Bash実行可能な環境（Linux、macOS） |

### 実行可否判定

PrepareTestsツールが存在しない場合は実行に失敗します。事前にビルドを完了させる必要があります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このスクリプトはパラメータを受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| artifacts/bin/PrepareTests/Debug/net10.0/ | DLL | PrepareTestsツール本体 |
| リポジトリ全体 | 各種 | テストに必要なソースファイルと成果物 |
| eng/common/tools.sh | Bash | Arcade共通ツール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/testPayload/ | ディレクトリ | テスト実行に必要なファイル一式 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PrepareTestsツールが生成するテストペイロード |
| 出力先 | artifacts/testPayload/ |
| 文字コード | 該当なし（バイナリファイル含む） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. シェルオプション設定
   └─ set -u（未定義変数エラー）、set -e（コマンド失敗時終了）
2. スクリプトパスの解決
   └─ シンボリックリンクを辿って実際のパスを取得
3. Arcade共通ツールの読み込み
   └─ eng/common/tools.shをsource
4. .NET CLIの初期化
   └─ InitializeDotNetCli関数を呼び出し
5. 既存testPayloadディレクトリの削除
   └─ rm -rfでクリーンな状態を確保
6. PrepareTestsツールの実行
   └─ dotnetコマンドでPrepareTests.dllを実行（--unixオプション付き）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[set -u, set -e]
    B --> C[スクリプトパス解決]
    C --> D[source tools.sh]
    D --> E[InitializeDotNetCli]
    E --> F[rm -rf testPayload]
    F --> G[dotnet PrepareTests.dll --unix]
    G --> H{成功?}
    H -->|Yes| I[終了 exit 0]
    H -->|No| J[終了 exit非0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | 一般エラー | PrepareTests.dllが存在しない | ビルドを実行してPrepareTestsをビルド |
| 非0 | 一般エラー | .NET SDKが見つからない | .NET SDKをインストール |
| 非0 | 一般エラー | 未定義変数の参照 | スクリプトの環境変数を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. PrepareTestsツールが存在するか確認
2. .NET SDKのインストール状態を確認
3. testPayloadディレクトリのパーミッションを確認
4. 手動でtestPayloadディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千のファイル |
| 目標処理時間 | 数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

testPayloadディレクトリへの書き込みが発生するため、同時実行は避けるべきです。CI/CD環境では、ジョブごとに独立したワークスペースを使用することを推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | エラー発生時 | シェルエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| testPayload生成 | ディレクトリ未生成 | CI/CDパイプライン |

## 備考

- Windows版（prepare-tests.ps1）との違いは--unixオプションの追加と、configurationパラメータがハードコードされている点です
- Debug構成固定でPrepareTestsツールを実行します
- _InitializeDotNetCli変数からdotnetパスを取得します
- シンボリックリンク対応のため、スクリプトパスを解決する処理が含まれています
