# バッチ設計書 14-Restore.cmd

## 概要

本ドキュメントは、RoslynプロジェクトにおけるNuGetパッケージリストアスクリプト（Restore.cmd）の設計仕様を定義します。このバッチは、Windows環境でプロジェクトの依存パッケージをNuGetから取得し、ビルドに必要な外部ライブラリを準備します。

### 本バッチの処理概要

このバッチでは、Roslynプロジェクトがビルドに必要とするNuGetパッケージを復元する処理を行います。eng/build.ps1を-restoreオプションで呼び出すシンプルなラッパースクリプトです。

**業務上の目的・背景**：現代のソフトウェア開発では、外部ライブラリやフレームワークへの依存が不可欠です。NuGetはC#/.NET開発における標準的なパッケージマネージャーであり、このスクリプトはプロジェクトの依存関係を解決し、ビルド可能な状態を準備します。クリーンなリポジトリからのビルド開始や、依存関係の更新後に使用されます。

**バッチの実行タイミング**：リポジトリのクローン直後、packages.lockファイルの更新後、NuGetパッケージのバージョン変更後、またはビルドエラー発生時のトラブルシューティング時に実行されます。

**主要な処理内容**：
1. PowerShellの起動（ExecutionPolicy ByPass）
2. eng/build.ps1の呼び出し（-restoreオプション付き）
3. 追加のコマンドライン引数のパススルー

**前後の処理との関連**：このバッチは通常、Build.cmdの前に実行されます。ビルドスクリプト（eng/build.ps1）が内部でリストアを行う場合もありますが、明示的にリストアのみを実行したい場合にこのスクリプトを使用します。

**影響範囲**：NuGetパッケージキャッシュ（ローカルまたはグローバル）とobj/フォルダに影響します。ソースコードには影響を与えません。

## バッチ種別

リストア / 依存関係管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（必要時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動、CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShellが利用可能であること |
| ネットワーク接続 | nuget.orgまたは構成されたフィードへのアクセスが可能 |
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |

### 実行可否判定

特別な判定ロジックはありません。常に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | 追加のコマンドライン引数（eng/build.ps1にパススルー） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.csproj, *.vbproj | XML | プロジェクトファイル（PackageReference定義） |
| Directory.Build.props | XML | 共通ビルドプロパティ |
| NuGet.config | XML | NuGetフィード設定 |
| *.slnx | XML | ソリューションファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| NuGetパッケージキャッシュ | nupkg | ダウンロードされたパッケージ |
| obj/project.assets.json | JSON | パッケージ依存関係グラフ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | project.assets.json（各プロジェクト） |
| 出力先 | 各プロジェクトのobj/フォルダ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（JSON形式） |

## 処理フロー

### 処理シーケンス

```
1. cmdスクリプト開始
   └─ @echo offでエコー抑制
2. PowerShell起動
   └─ ExecutionPolicy ByPassでポリシー回避
3. eng/build.ps1呼び出し
   └─ -restoreオプションと追加引数を渡す
4. 終了
   └─ build.ps1の終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Restore.cmd開始] --> B[PowerShell起動]
    B --> C[eng/build.ps1 -restore実行]
    C --> D{リストア成功?}
    D -->|Yes| E[終了 exit 0]
    D -->|No| F[終了 exit非0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ネットワークエラー | NuGetフィードに接続できない | ネットワーク接続を確認、プロキシ設定を確認 |
| 非0 | パッケージ不明 | 指定されたパッケージが見つからない | パッケージ名とバージョンを確認 |
| 非0 | 認証エラー | プライベートフィードへの認証失敗 | 認証情報を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | eng/build.ps1の実装に依存 |
| リトライ間隔 | eng/build.ps1の実装に依存 |
| リトライ対象エラー | ネットワーク一時障害 |

### 障害時対応

1. ネットワーク接続状態を確認
2. NuGet.configの設定を確認
3. パッケージキャッシュをクリアして再実行
4. 特定のパッケージで失敗する場合はバージョンを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百のパッケージ |
| 目標処理時間 | ネットワーク速度とキャッシュ状態に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一のNuGetキャッシュディレクトリを使用する複数のリストアは競合する可能性があります。CI/CD環境では、ジョブごとに独立したパッケージキャッシュを使用することを推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | リストア中 | パッケージダウンロード進捗 |
| 成功ログ | リストア完了時 | リストア完了メッセージ |
| エラーログ | エラー発生時 | パッケージ名とエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| 処理時間 | 環境依存 | CI/CDパイプライン |

## 備考

- このスクリプトはeng/build.ps1への単純なラッパーです
- %*により、追加のコマンドライン引数をbuild.ps1にパススルーできます
- ExecutionPolicy ByPassにより、PowerShellスクリプト実行ポリシーを回避します
- Unix環境では代わりにrestore.shを使用してください
