# バッチ設計書 16-Verify.cmd

## 概要

本ドキュメントは、Roslynプロジェクトにおける完全なビルド検証スクリプト（Verify.cmd）の設計仕様を定義します。このバッチは、Windows環境でビルド、リストア、リビルド、パック、テスト、アナライザ実行、警告のエラー化を一括で実行し、プロジェクトの品質を包括的に検証します。

### 本バッチの処理概要

このバッチでは、Roslynプロジェクトの完全な検証プロセスを実行します。複数のビルドフェーズとテスト、静的解析を組み合わせて、コードの品質とビルドの正確性を包括的に確認します。

**業務上の目的・背景**：ソフトウェア開発において、コード変更がプロジェクト全体に問題を引き起こさないことを確認することは重要です。このスクリプトは、ローカル環境でCI/CDパイプラインと同等の検証を実行することで、プルリクエスト前の品質確認や、リリース前の最終検証を可能にします。開発者がコミット前に実行することで、CIでの失敗を事前に防止できます。

**バッチの実行タイミング**：コードレビュー前、プルリクエスト作成前、リリース前の最終確認時、または開発者がローカルで完全な検証を行いたい時に実行されます。

**主要な処理内容**：
1. パッケージリストア（-restore）
2. プロジェクトビルド（-build）
3. クリーンリビルド（-rebuild）
4. NuGetパッケージ作成（-pack）
5. ユニットテスト実行（-test）
6. 静的アナライザ実行（-runAnalyzers）
7. 警告をエラーとして扱う（-warnAsError）

**前後の処理との関連**：このバッチは包括的な検証スクリプトであり、Build.cmd、Test.cmdなどの個別機能を内包しています。通常は単独で使用され、成功した場合はコミット/プルリクエストの準備が整ったことを意味します。

**影響範囲**：artifacts/ディレクトリ全体（bin、obj、packages、log）に影響します。ビルド成果物、テスト結果、パッケージが生成または更新されます。

## バッチ種別

検証処理 / 包括的品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コミット前、PR前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShellが利用可能であること |
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |
| Visual Studio Build Tools | ビルドに必要なツールがインストールされていること |
| ネットワーク接続 | NuGetパッケージのリストアに必要 |

### 実行可否判定

特別な判定ロジックはありません。常に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | 追加のコマンドライン引数（eng/build.ps1にパススルー） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.csproj, *.vbproj | XML | プロジェクトファイル |
| *.cs, *.vb | ソースコード | C#/VBソースファイル |
| *.slnx | XML | ソリューションファイル |
| NuGet.config | XML | NuGetフィード設定 |
| .editorconfig | テキスト | コーディングスタイル設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin/ | DLL/EXE | ビルド成果物 |
| artifacts/obj/ | 中間ファイル | ビルド中間ファイル |
| artifacts/packages/ | nupkg | NuGetパッケージ |
| artifacts/log/ | ログファイル | ビルド・テストログ |
| artifacts/TestResults/ | XML/HTML | テスト結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（プロジェクト名に基づく） |
| 出力先 | artifacts/配下の各ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. cmdスクリプト開始
   └─ @echo offでエコー抑制
2. PowerShell起動
   └─ ExecutionPolicy ByPassでポリシー回避
3. eng/build.ps1呼び出し（複合オプション）
   ├─ -restore: パッケージリストア
   ├─ -build: プロジェクトビルド
   ├─ -rebuild: クリーンリビルド
   ├─ -pack: パッケージ作成
   ├─ -test: テスト実行
   ├─ -runAnalyzers: 静的解析
   └─ -warnAsError: 警告エラー化
4. 終了
   └─ 全フェーズの結果に基づく終了コード
```

### フローチャート

```mermaid
flowchart TD
    A[Verify.cmd開始] --> B[PowerShell起動]
    B --> C[eng/build.ps1 -restore]
    C --> D{成功?}
    D -->|No| Z[終了 exit非0]
    D -->|Yes| E[-build]
    E --> F{成功?}
    F -->|No| Z
    F -->|Yes| G[-rebuild]
    G --> H{成功?}
    H -->|No| Z
    H -->|Yes| I[-pack]
    I --> J{成功?}
    J -->|No| Z
    J -->|Yes| K[-test]
    K --> L{成功?}
    L -->|No| Z
    L -->|Yes| M[-runAnalyzers]
    M --> N{成功?}
    N -->|No| Z
    N -->|Yes| O[-warnAsError検証]
    O --> P{成功?}
    P -->|No| Z
    P -->|Yes| Q[終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | リストアエラー | NuGetパッケージ取得失敗 | ネットワーク接続確認、パッケージバージョン確認 |
| 非0 | ビルドエラー | コンパイルエラー | エラーメッセージを確認し、コードを修正 |
| 非0 | テストエラー | テスト失敗 | 失敗したテストを確認し、修正 |
| 非0 | アナライザ警告 | 静的解析での問題検出 | 警告を解消または抑制 |
| 非0 | 警告エラー | ビルド警告の発生 | 警告の原因を特定し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認して問題の特定
2. 失敗したフェーズを特定（restore/build/test等）
3. 個別のスクリプト（Restore.cmd、Build.cmd等）で再実行して詳細確認
4. 必要に応じてクリーンビルドを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト全体 |
| 目標処理時間 | 30分〜1時間（環境依存） |
| メモリ使用量上限 | 8GB以上推奨 |

## 排他制御

同一のソースディレクトリでの複数同時実行は推奨されません。ビルド成果物の競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各フェーズ実行中 | ビルド/テスト進捗 |
| 成功ログ | 各フェーズ完了時 | 完了メッセージ |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |
| 警告ログ | 警告発生時 | 警告メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | コンソール出力 |
| 処理時間 | 1時間超 | なし（ローカル実行のため） |

## 備考

- このスクリプトはeng/build.ps1への包括的なラッパーです
- すべてのビルドフェーズを順番に実行し、いずれかが失敗した時点で終了します
- -warnAsErrorにより、警告もエラーとして扱われるため、厳密な品質チェックが可能です
- Unix環境では代わりにverify.shを使用してください
- 完全な検証には時間がかかるため、日常的な開発ではBuild.cmdやTest.cmdを使用することを推奨します
