# バッチ設計書 17-verify.sh

## 概要

本ドキュメントは、Roslynプロジェクトにおける完全なビルド検証スクリプト（verify.sh）の設計仕様を定義します。このバッチは、Unix/Linux/macOS環境でビルド、リストア、リビルド、パック、テスト、アナライザ実行、警告のエラー化を一括で実行し、プロジェクトの品質を包括的に検証します。

### 本バッチの処理概要

このバッチでは、Roslynプロジェクトの完全な検証プロセスをUnix環境で実行します。Windows版のVerify.cmdと同等の機能を提供し、複数のビルドフェーズとテスト、静的解析を組み合わせてコードの品質を確認します。

**業務上の目的・背景**：Roslynプロジェクトはクロスプラットフォーム対応であり、Unix系OS（Linux、macOS）でも開発と検証が可能です。このスクリプトは、Unix環境でローカルCI/CDと同等の検証を実行することで、プルリクエスト前の品質確認や、マルチプラットフォームでのリリース前検証を可能にします。

**バッチの実行タイミング**：コードレビュー前、プルリクエスト作成前、リリース前の最終確認時、またはUnix環境の開発者がローカルで完全な検証を行いたい時に実行されます。

**主要な処理内容**：
1. スクリプトパスの解決（シンボリックリンク対応）
2. eng/build.shの呼び出し（複合オプション付き）
   - --restore: パッケージリストア
   - --build: プロジェクトビルド
   - --rebuild: クリーンリビルド
   - --pack: NuGetパッケージ作成
   - --test: ユニットテスト実行
   - --runAnalyzers: 静的アナライザ実行
   - --warnAsError: 警告をエラーとして扱う

**前後の処理との関連**：このバッチは包括的な検証スクリプトであり、build.sh --buildやtest.shなどの個別機能を内包しています。通常は単独で使用され、成功した場合はコミット/プルリクエストの準備が整ったことを意味します。

**影響範囲**：artifacts/ディレクトリ全体（bin、obj、packages、log）に影響します。ビルド成果物、テスト結果、パッケージが生成または更新されます。

## バッチ種別

検証処理 / 包括的品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コミット前、PR前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash | Bashシェルが利用可能であること |
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |
| ネットワーク接続 | NuGetパッケージのリストアに必要 |
| Unix環境 | Linux、macOS、またはWSL環境 |

### 実行可否判定

特別な判定ロジックはありません。常に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string | No | なし | 追加のコマンドライン引数（eng/build.shにパススルー） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.csproj, *.vbproj | XML | プロジェクトファイル |
| *.cs, *.vb | ソースコード | C#/VBソースファイル |
| *.slnx | XML | ソリューションファイル |
| NuGet.config | XML | NuGetフィード設定 |
| .editorconfig | テキスト | コーディングスタイル設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin/ | DLL | ビルド成果物 |
| artifacts/obj/ | 中間ファイル | ビルド中間ファイル |
| artifacts/packages/ | nupkg | NuGetパッケージ |
| artifacts/log/ | ログファイル | ビルド・テストログ |
| artifacts/TestResults/ | XML | テスト結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（プロジェクト名に基づく） |
| 出力先 | artifacts/配下の各ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ シンボリックリンクを辿って実際のパスを取得
2. scriptrootの設定
   └─ スクリプトのディレクトリを確定
3. eng/build.sh呼び出し（複合オプション）
   ├─ --restore: パッケージリストア
   ├─ --build: プロジェクトビルド
   ├─ --rebuild: クリーンリビルド
   ├─ --pack: パッケージ作成
   ├─ --test: テスト実行
   ├─ --runAnalyzers: 静的解析
   └─ --warnAsError: 警告エラー化
4. 終了
   └─ 全フェーズの結果に基づく終了コード
```

### フローチャート

```mermaid
flowchart TD
    A[verify.sh開始] --> B[シンボリックリンク解決]
    B --> C[scriptroot設定]
    C --> D[eng/build.sh実行]
    D --> E{全フェーズ成功?}
    E -->|Yes| F[終了 exit 0]
    E -->|No| G[終了 exit非0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | リストアエラー | NuGetパッケージ取得失敗 | ネットワーク接続確認 |
| 非0 | ビルドエラー | コンパイルエラー | エラーメッセージを確認し修正 |
| 非0 | テストエラー | テスト失敗 | 失敗したテストを確認 |
| 非0 | アナライザ警告 | 静的解析での問題検出 | 警告を解消または抑制 |
| 非0 | 警告エラー | ビルド警告の発生 | 警告の原因を特定し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認して問題の特定
2. 失敗したフェーズを特定
3. 個別のスクリプトで再実行して詳細確認
4. 必要に応じてクリーンビルドを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト全体 |
| 目標処理時間 | 30分〜1時間（環境依存） |
| メモリ使用量上限 | 8GB以上推奨 |

## 排他制御

同一のソースディレクトリでの複数同時実行は推奨されません。ビルド成果物の競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各フェーズ実行中 | ビルド/テスト進捗 |
| 成功ログ | 各フェーズ完了時 | 完了メッセージ |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | コンソール出力 |
| 処理時間 | 1時間超 | なし（ローカル実行のため） |

## 備考

- このスクリプトはeng/build.shへの包括的なラッパーです
- すべてのビルドフェーズを順番に実行し、いずれかが失敗した時点で終了します
- --warnAsErrorにより、警告もエラーとして扱われます
- Windows環境では代わりにVerify.cmdを使用してください
- シンボリックリンク対応のため、スクリプトパスを解決する処理が含まれています
- $@により、追加のコマンドライン引数をbuild.shにパススルーできます
