# バッチ設計書 18-validate-code-formatting.ps1

## 概要

本ドキュメントは、Roslynプロジェクトにおけるコードフォーマット検証スクリプト（validate-code-formatting.ps1）の設計仕様を定義します。このバッチは、dotnet-formatツールを使用してソースコードのホワイトスペースフォーマットを検証し、コーディングスタイルの一貫性を確保します。

### 本バッチの処理概要

このバッチでは、Roslynプロジェクトのソースコードがプロジェクトのフォーマット規約に従っているかを検証します。dotnet-formatツールを使用して、ホワイトスペース（インデント、空白、改行）のフォーマットをチェックし、差異があればエラーを報告します。

**業務上の目的・背景**：大規模なオープンソースプロジェクトでは、多数の開発者がコードに貢献します。コーディングスタイルの一貫性は、コードの可読性と保守性を向上させ、コードレビューを効率化します。このスクリプトは、CI/CDパイプラインで自動的にフォーマット検証を行い、スタイルガイドラインに準拠しないコードがマージされることを防止します。

**バッチの実行タイミング**：CI/CDパイプラインでのプルリクエスト検証時、またはローカル開発環境でコミット前の確認時に実行されます。

**主要な処理内容**：
1. build-utils.ps1の読み込み
2. リポジトリルートへ移動
3. dotnet-formatツールの実行（whiteスペースフォーマット検証モード）
4. 指定されたディレクトリのみを対象として検証
5. 生成されたコードも含めて検証

**前後の処理との関連**：このバッチは独立した検証ツールであり、ビルド前後どちらでも実行可能です。CI/CDパイプラインでは通常、ビルドやテストと並行して実行されます。eng/validate-rules-missing-documentation.ps1やeng/todo-check.ps1などの他の検証スクリプトと組み合わせて使用されます。

**影響範囲**：このバッチは読み取り専用の検証処理であり、ソースコードを変更しません。--verify-no-changesオプションにより、差異の検出のみを行います。

## バッチ種別

検証処理 / コード品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CD時、コミット前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプライン、手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |
| dotnet-format | dotnet-formatツールがインストールされていること |
| PowerShell | PowerShellが利用可能であること |

### 実行可否判定

特別な判定ロジックはありません。常に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| rootDirectory | string | Yes | なし | 検証対象のルートディレクトリ |
| includeDirectories | string[] | Yes | なし | 検証対象のディレクトリリスト |
| ci | switch | No | $false | CI環境で実行する場合に指定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.cs | ソースコード | C#ソースファイル |
| .editorconfig | テキスト | フォーマット設定 |
| *.slnx, *.csproj | XML | プロジェクト設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証結果（差異がある場合はエラー） |
| 終了コード | 数値 | 0=成功、非0=フォーマット違反検出 |

### 出力ファイル仕様

該当なし（このバッチはファイルを出力しません）

## 処理フロー

### 処理シーケンス

```
1. build-utils.ps1の読み込み
   └─ 共通ユーティリティ関数の初期化
2. リポジトリルートへ移動
   └─ Push-Locationで作業ディレクトリを変更
3. 変数設定
   └─ $prepareMachine = $ci
4. dotnet-format実行
   ├─ tool run dotnet-format
   ├─ -v detailed（詳細ログ）
   ├─ whitespace（ホワイトスペースのみ検証）
   ├─ --folder（フォルダモード）
   ├─ --include-generated（生成コードも含む）
   ├─ --include $includeDirectories（対象ディレクトリ）
   └─ --verify-no-changes（変更がないことを検証）
5. 終了処理
   └─ Pop-Locationで元のディレクトリに戻る
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[build-utils.ps1読み込み]
    B --> C[Push-Location $RepoRoot]
    C --> D[dotnet-format whitespace実行]
    D --> E{フォーマット差異あり?}
    E -->|No| F[ExitWithExitCode 0]
    E -->|Yes| G[エラー出力]
    G --> H[ExitWithExitCode 1]
    F --> I[Pop-Location]
    H --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | フォーマット違反 | ホワイトスペースフォーマットの差異検出 | dotnet format whiteを実行してフォーマットを修正 |
| 1 | ツールエラー | dotnet-formatツールが見つからない | dotnet tool restore実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認してフォーマット違反の箇所を特定
2. dotnet format whitespaceを実行して自動修正
3. 修正後、再度検証を実行して確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千のソースファイル |
| 目標処理時間 | 数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用処理のため、同時実行が可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 詳細ログ | 検証中 | -v detailedによる詳細情報 |
| エラーログ | エラー発生時 | 例外メッセージ |
| 差異レポート | 違反検出時 | フォーマット差異の詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |

## 備考

- --verify-no-changesオプションにより、ファイルは変更されず検証のみ行われます
- --include-generatedにより、ソースジェネレータで生成されたコードも検証対象となります
- --folderオプションにより、ソリューションファイルではなくフォルダ単位で処理されます
- フォーマット違反を修正するには、dotnet format whitespaceを--verify-no-changesなしで実行します
- .editorconfigの設定に基づいてフォーマットルールが適用されます
