# バッチ設計書 19-validate-rules-missing-documentation.ps1

## 概要

本ドキュメントは、Roslynプロジェクトにおけるルールドキュメント検証スクリプト（validate-rules-missing-documentation.ps1）の設計仕様を定義します。このバッチは、Microsoft.CodeAnalysis.Featuresプロジェクトにおいて、未文書化のアナライザルールを検出し、ドキュメントの完全性を確保します。

### 本バッチの処理概要

このバッチでは、Roslynのアナライザルール（診断ルール）がドキュメント化されているかを検証します。GenerateRulesMissingDocumentationターゲットを実行して、ドキュメントが不足しているルールを検出します。

**業務上の目的・背景**：Roslynは多数のコード分析ルールを提供しており、各ルールには適切なドキュメントが必要です。ユーザーがルールの意味と対処方法を理解できるよう、すべてのルールにはドキュメントが提供されるべきです。このスクリプトは、新しいルールが追加された際にドキュメントが漏れていないかを自動的にチェックし、ドキュメントの完全性を保証します。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド検証時、または新しいアナライザルールを追加した後に実行されます。

**主要な処理内容**：
1. build-utils.ps1の読み込み
2. リポジトリルートへ移動
3. Microsoft.CodeAnalysis.Features.csprojのビルド実行
4. GenerateRulesMissingDocumentationターゲットの実行
5. 未文書化ルールがあればエラーを報告

**前後の処理との関連**：このバッチは独立した検証ツールです。通常は他の検証スクリプト（validate-code-formatting.ps1、todo-check.ps1など）と組み合わせてCI/CDパイプラインで実行されます。

**影響範囲**：このバッチは検証処理のみであり、ソースコードやドキュメントを変更しません。未文書化ルールの検出結果を報告します。

## バッチ種別

検証処理 / ドキュメント完全性チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CD時、ルール追加後） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプライン、手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | 適切なバージョンの.NET SDKがインストールされていること |
| PowerShell | PowerShellが利用可能であること |
| プロジェクト存在 | src/Features/Core/Portable/Microsoft.CodeAnalysis.Features.csprojが存在すること |

### 実行可否判定

特別な判定ロジックはありません。常に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ci | switch | No | $false | CI環境で実行する場合に指定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Microsoft.CodeAnalysis.Features.csproj | XML | Featuresプロジェクトファイル |
| DiagnosticDescriptors | C# | 診断ルール定義 |
| ドキュメントファイル | 各種 | ルールドキュメント |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドログと未文書化ルール一覧 |
| 終了コード | 数値 | 0=成功、1=未文書化ルール検出またはエラー |

### 出力ファイル仕様

該当なし（このバッチはファイルを出力しません）

## 処理フロー

### 処理シーケンス

```
1. ログ出力
   └─ "Building Microsoft.CodeAnalysis.Features"メッセージ
2. build-utils.ps1の読み込み
   └─ 共通ユーティリティ関数の初期化
3. リポジトリルートへ移動
   └─ Push-Locationで作業ディレクトリを変更
4. 変数設定
   └─ $prepareMachine = $ci
5. dotnet build実行
   ├─ 対象: src/Features/Core/Portable/Microsoft.CodeAnalysis.Features.csproj
   ├─ ターゲット: -t:GenerateRulesMissingDocumentation
   ├─ 設定: -p:RoslynEnforceCodeStyle=false
   ├─ 設定: -p:RunAnalyzersDuringBuild=false
   ├─ 設定: -p:ContinuousIntegrationBuild=$ci
   └─ 構成: -c Release
6. 終了処理
   └─ Pop-Locationで元のディレクトリに戻る
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ログ出力]
    B --> C[build-utils.ps1読み込み]
    C --> D[Push-Location $RepoRoot]
    D --> E[dotnet build実行]
    E --> F{未文書化ルールあり?}
    F -->|No| G[終了 exit 0]
    F -->|Yes| H[エラー出力]
    H --> I[ExitWithExitCode 1]
    G --> J[Pop-Location]
    I --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 未文書化ルール検出 | ドキュメントがないルールが存在 | 該当ルールのドキュメントを作成 |
| 1 | ビルドエラー | プロジェクトのビルドに失敗 | ビルドエラーを解決 |
| 1 | プロジェクト不明 | csprojファイルが見つからない | パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認して未文書化ルールを特定
2. 該当ルールのドキュメントを作成
3. 再度検証を実行して確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクトのビルド |
| 目標処理時間 | 数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一のobj/ディレクトリを使用する複数のビルドは競合する可能性があります。CI/CD環境では独立したワークスペースの使用を推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Building Microsoft.CodeAnalysis.Features" |
| ビルドログ | ビルド中 | MSBuildログ |
| エラーログ | エラー発生時 | 例外メッセージ、スタックトレース |
| 結果ログ | 検証完了時 | 未文書化ルール一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |

## 備考

- このスクリプトはMicrosoft.CodeAnalysis.Featuresプロジェクトのみをターゲットとしています
- Release構成でビルドされます
- RoslynEnforceCodeStyle=falseとRunAnalyzersDuringBuild=falseにより、コードスタイルとアナライザのチェックを無効化して高速化しています
- ContinuousIntegrationBuildプロパティは-ciオプションに連動します
- GenerateRulesMissingDocumentationはMSBuildカスタムターゲットで、未文書化ルールを検出する独自のロジックを実行します
