# バッチ設計書 2-build.sh

## 概要

本ドキュメントは、RoslynプロジェクトのUnix環境向けビルドエントリーポイントスクリプト「build.sh」の設計仕様を記載する。

### 本バッチの処理概要

build.shは、Unix環境（Linux/macOS）においてRoslynプロジェクトのビルドを実行するためのシェルスクリプトエントリーポイントである。

**業務上の目的・背景**：Roslynコンパイラおよび関連ツールの開発において、Unix環境での統一的なビルド手段を提供する。クロスプラットフォーム開発を支援し、Linux/macOS環境での開発者やCI/CDパイプラインが一貫した方法でビルドを実行できるようにする。Windows以外の環境でもRoslynの開発・ビルドを可能にすることで、開発者の選択肢を広げる。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプライン（Azure DevOps等）からの自動実行。Unix環境でコードの変更後、ビルド検証が必要な際に随時実行される。

**主要な処理内容**：
1. シンボリックリンクを解決してスクリプトの実際のパスを取得
2. スクリプトのルートディレクトリを特定
3. eng/build.shに--buildオプションとRoslyn.slnxソリューションを指定して呼び出し
4. コマンドライン引数をそのままeng/build.shに渡す

**前後の処理との関連**：本スクリプトはeng/build.shの薄いラッパーであり、実際のビルドロジックはeng/build.shに委譲される。リストア処理（restore.sh）の後に実行されることが多く、テスト処理（test.sh）の前に実行される。

**影響範囲**：Roslyn.slnxソリューション全体のビルド成果物（artifacts/binディレクトリ）に影響を与える。Unix環境向けのバイナリ、NuGetパッケージ等が生成される。

## バッチ種別

ビルド処理（コンパイル・パッケージング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix環境 | Linux または macOS で実行可能 |
| Bash | Bashシェルが利用可能であること |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| 実行権限 | スクリプトに実行権限が付与されていること |

### 実行可否判定

特別な判定ロジックはなく、前提条件が満たされていれば実行可能。eng/build.sh側で詳細な条件チェックが行われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string | No | なし | eng/build.shに渡される追加パラメータ（--configuration, --restore等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Roslyn.slnx | Solution | ビルド対象のソリューションファイル（明示的に指定） |
| ソースコード | C#/VB | コンパイル対象のソースファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | DLL | コンパイル済みバイナリ |
| artifacts/packages | NuGet | 生成されたNuGetパッケージ |
| artifacts/log | binlog | MSBuildバイナリログ（--blオプション時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各プロジェクトに依存 |
| 出力先 | artifacts/bin/{Configuration}/{TargetFramework} |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. シェルからbuild.shを実行
   └─ コマンドライン引数を受け取る
2. シンボリックリンクを解決
   └─ BASH_SOURCE[0]から実際のパスを取得
3. スクリプトルートディレクトリを特定
   └─ cd -P と dirname を使用
4. eng/build.shを呼び出し
   └─ --build --solution Roslyn.slnx と追加引数を渡す
5. ビルド結果を標準出力に表示
   └─ 終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[build.sh実行] --> B[シンボリックリンク解決]
    B --> C[scriptrootディレクトリ特定]
    C --> D[eng/build.sh呼び出し]
    D --> E{--buildオプション付与}
    E --> F[--solution Roslyn.slnx指定]
    F --> G[追加引数を渡す]
    G --> H[ビルド実行]
    H --> I[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正な引数が指定された場合 | 使用方法を確認し正しい引数を指定 |
| 非0 | ビルドエラー | コンパイルエラー、依存関係エラー等 | エラーメッセージに従い対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. 標準出力/標準エラー出力のログを確認
3. artifacts/log配下のバイナリログ（.binlog）を確認
4. エラー内容に応じてソースコードまたは環境を修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ソリューション全体（約200プロジェクト） |
| 目標処理時間 | 環境依存（通常5-30分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの複数ビルド同時実行は推奨されない。ビルドプロセス間で競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | ビルド中 | MSBuildの進捗情報 |
| 標準エラー | エラー発生時 | コンパイルエラー、警告 |
| binlog | ビルド完了時 | 詳細なビルドログ（--blオプション時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDパイプライン |
| ビルド時間 | 環境依存 | CI/CDパイプライン |

## 備考

- 本スクリプトはeng/build.shへの薄いラッパーであり、詳細なビルドロジックはeng/build.shを参照
- Windows環境ではBuild.cmdを使用すること
- シンボリックリンク解決により、リンク経由での実行も正しく動作する
- 明示的にRoslyn.slnxソリューションを指定している点がBuild.cmdとの違い
