# バッチ設計書 20-todo-check.ps1

## 概要

本ドキュメントは、Roslynプロジェクトにおける特定のTODOマーカー検証スクリプト（todo-check.ps1）の設計仕様を定義します。このバッチは、ソースコード内のPROTOTYPEおよびTODO2マーカーを検出し、これらの一時的なマーカーが本番コードに残っていないことを確認します。

### 本バッチの処理概要

このバッチでは、Roslynプロジェクトのソースコード内に特定の一時的なマーカー（PROTOTYPEとTODO2）が残っていないかを検証します。これらのマーカーは開発中の一時的な目印として使用されるものであり、本番コードやmainブランチには含まれるべきではありません。

**業務上の目的・背景**：開発中、開発者はPROTOTYPEやTODO2などのマーカーを使用して、まだ完成していないコードや後で対応が必要な箇所を示すことがあります。しかし、これらのマーカーが本番コードに残ったままマージされると、コードの品質問題や未完成の機能がリリースされるリスクがあります。このスクリプトは、mainブランチへのマージ前にこれらのマーカーを検出し、開発者に警告を発します。

**バッチの実行タイミング**：CI/CDパイプラインでのプルリクエスト検証時、特にmainブランチへのマージを対象とする場合に実行されます。

**主要な処理内容**：
1. 環境変数からターゲットブランチを確認
2. mainブランチへのマージの場合、PROTOTYPEマーカーを検索
3. すべてのマージでTODO2マーカーを検索
4. マーカーが見つかった場合はエラーを報告

**前後の処理との関連**：このバッチは独立した検証ツールです。通常は他の検証スクリプト（validate-code-formatting.ps1、validate-rules-missing-documentation.ps1など）と組み合わせてCI/CDパイプラインで実行されます。

**影響範囲**：このバッチは読み取り専用の検証処理であり、ソースコードを変更しません。マーカーの検出結果を報告し、見つかった場合はエラーで終了します。

## バッチ種別

検証処理 / コード品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CD時、PR時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプライン（Azure DevOps） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShellが利用可能であること |
| ソースディレクトリ | src、eng、scripts、docs/compilersディレクトリが存在すること |
| 環境変数 | SYSTEM_PULLREQUEST_TARGETBRANCHが設定されていること（CI環境） |

### 実行可否判定

特別な判定ロジックはありませんが、PROTOTYPEマーカーのチェックはmainブランチへのマージ時のみ実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このスクリプトはパラメータを受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/ | 各種 | ソースコードファイル |
| eng/ | 各種 | エンジニアリングスクリプト |
| scripts/ | 各種 | スクリプトファイル |
| docs/compilers/ | 各種 | コンパイラドキュメント |
| $env:SYSTEM_PULLREQUEST_TARGETBRANCH | 環境変数 | PRターゲットブランチ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証結果とマーカー検出箇所 |
| 終了コード | 数値 | 0=成功（マーカーなし）、例外=マーカー検出 |

### 出力ファイル仕様

該当なし（このバッチはファイルを出力しません）

## 処理フロー

### 処理シーケンス

```
1. 厳密モード設定
   └─ Set-StrictMode -version 2.0
2. ターゲットブランチ確認
   └─ $env:SYSTEM_PULLREQUEST_TARGETBRANCHを確認
3. PROTOTYPEマーカー検索（mainブランチへのマージ時のみ）
   ├─ 対象: src, eng, scripts, docs/compilers
   ├─ 除外: *.dll, *.exe, *.pdb, *.xlf, todo-check.ps1
   └─ パターン: 'PROTOTYPE'（大文字小文字区別）
4. PROTOTYPEマーカー検出時
   └─ 例外をスロー
5. TODO2マーカー検索（常に実行）
   ├─ 対象: src, eng, scripts, docs/compilers
   ├─ 除外: *.dll, *.exe, *.pdb, *.xlf, todo-check.ps1
   └─ パターン: 'TODO2'（大文字小文字区別）
6. TODO2マーカー検出時
   └─ 例外をスロー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ターゲット=main?}
    B -->|Yes| C[PROTOTYPE検索]
    C --> D{PROTOTYPE見つかった?}
    D -->|Yes| E[エラー出力・例外スロー]
    D -->|No| F[TODO2検索]
    B -->|No| F
    F --> G{TODO2見つかった?}
    G -->|Yes| H[エラー出力・例外スロー]
    G -->|No| I[終了 成功]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（このバッチはデータベースを使用しません）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 例外 | PROTOTYPEマーカー検出 | mainへのマージでPROTOTYPEが存在 | PROTOTYPEコメントを削除または適切なTODOに変更 |
| 例外 | TODO2マーカー検出 | TODO2が存在 | TODO2コメントを削除または通常のTODOに変更 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認してマーカーの場所を特定
2. 該当するファイルを開いてマーカーを確認
3. マーカーを削除するか、適切な形式に変更
4. 再度検証を実行して確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万のファイル |
| 目標処理時間 | 数秒〜1分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用処理のため、同時実行が可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | PROTOTYPE検索開始時 | "Checking no PROTOTYPE markers in source" |
| 検出ログ | マーカー検出時 | "Found PROTOTYPE/TODO2 markers in source:" |
| エラーログ | マーカー検出時 | マーカーの場所一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード/例外 | マーカー検出 | CI/CDパイプライン（Azure DevOps） |

## 備考

- PROTOTYPEマーカーはmainブランチへのマージ時のみチェックされます
- TODO2マーカーはすべてのマージでチェックされます
- このスクリプト自体（todo-check.ps1）は検索対象から除外されています
- バイナリファイル（*.dll, *.exe, *.pdb）およびローカリゼーションファイル（*.xlf）は検索対象外です
- Select-Stringコマンドレットを使用して、大文字小文字を区別したパターンマッチングを行います
- 通常のTODOコメントはチェック対象外であり、PROTOTYPE（開発中の試作）とTODO2（特別なマーカー）のみが対象です
- SYSTEM_PULLREQUEST_TARGETBRANCHはAzure DevOpsのCI環境で自動的に設定されます
