# バッチ設計書 22-check-for-loc-changes

## 概要

本ドキュメントは、ローカリゼーション（Loc）フリーズ期間中にローカライズファイル（.xlf）への変更を検出・防止するためのスクリプト `scripts/check-for-loc-changes.ps1` の設計を記述する。

### 本バッチの処理概要

このバッチは、Pull Request（PR）のマージによって .xlf ファイル（XLIFFローカリゼーションファイル）が変更されるかどうかをチェックし、変更がある場合はエラーコードを返す処理を実行する。

**業務上の目的・背景**：ソフトウェアのリリースサイクルにおいて、ローカリゼーション（翻訳）作業は特定の期間に集中して行われる。この期間中（Locフリーズ期間）は、翻訳対象のリソースファイルを変更すると翻訳作業との整合性が崩れるため、ソースファイルの変更を制限する必要がある。本バッチは、CIシステムでPRマージ前に実行され、.xlfファイルへの変更を検出することで、意図しないローカリゼーションリソースの変更を防止する役割を果たす。

**バッチの実行タイミング**：本バッチはLocフリーズ期間中にCIパイプラインで自動実行される。PRがベースブランチへマージされる前の検証ステップとして位置づけられ、変更が検出された場合はマージがブロックされる。

**主要な処理内容**：
1. baseブランチとheadコミット間のマージベースを特定
2. マージベースからheadまでの変更ファイル一覧を取得
3. 変更ファイルから.xlfファイルのみをフィルタリング
4. .xlfファイルの変更がある場合はエラーコード1で終了、ない場合は正常終了

**前後の処理との関連**：本バッチは独立したCI検証ステップとして動作する。他のバッチとの直接的な依存関係はないが、同一PRに対する他のCI検証（ビルド、テスト等）と並列または順次で実行される。

**影響範囲**：本バッチはリポジトリ内のファイルを読み取り専用で参照するのみであり、ファイルシステムやデータベースへの書き込みは行わない。CI/CDパイプラインの成功・失敗判定に影響を与える。

## バッチ種別

検証処理（ローカリゼーション変更検出）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR作成・更新時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CIパイプライン（PR検証） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Locフリーズ期間 | 本スクリプトがCIで有効化されていること |
| Gitリポジトリ | 有効なGitリポジトリ内で実行されること |
| base/headパラメータ | マージ対象のbaseとheadが指定されていること |

### 実行可否判定

base および head パラメータが必須であり、未指定の場合はエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| base | string | Yes | - | マージ先のブランチ/コミット/タグ |
| head | string | Yes | - | マージ元のブランチ/コミット/タグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Gitリポジトリ | Git | 変更差分の取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 変更された.xlfファイルのパス一覧 |
| 終了コード | 整数 | 0: 変更なし、1: 変更あり/エラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ build-utils.ps1 の読み込み
2. リポジトリルートへ移動
   └─ Push-Location $RepoRoot
3. マージベース特定
   └─ git merge-base $base $head
4. 変更ファイル取得
   └─ git diff --name-only $mergeBase $head
5. .xlfファイルフィルタリング
   └─ 拡張子が .xlf のファイルのみ抽出
6. 結果出力
   └─ 変更された .xlf ファイルパスを標準出力に出力
7. 終了コード判定
   └─ .xlf ファイルの変更有無に基づく
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[build-utils.ps1読み込み]
    B --> C[RepoRootへ移動]
    C --> D[git merge-base実行]
    D --> E[git diff --name-only実行]
    E --> F[.xlfファイルフィルタリング]
    F --> G{.xlfファイル変更あり?}
    G -->|なし| H[終了コード0で終了]
    G -->|あり| I[変更ファイル一覧出力]
    I --> J[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータ不足 | base/headが未指定 | 必須パラメータを指定して再実行 |
| 1 | Git操作エラー | git merge-base/diffが失敗 | Gitリポジトリの状態を確認 |
| 1 | Loc変更検出 | .xlfファイルに変更がある | 変更を取り消すか、Locフリーズ解除後にマージ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

Git操作エラーが発生した場合は、リポジトリの状態（ブランチの存在、コミットの有効性）を確認する。.xlfファイルの変更が検出された場合は、変更内容を確認し、意図的な変更であればLocフリーズ期間終了後に再度PRを作成するか、例外的な承認プロセスを経てマージを許可する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | PRあたり数十〜数百ファイルの変更 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用操作のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 変更検出ログ | .xlfファイル検出時 | "{ファイルパス} has been modified" |
| エラーログ | 例外発生時 | 例外メッセージと例外オブジェクト |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1（Loc変更検出） | CI通知（PR作成者へ） |

## 備考

- XLIFF（XML Localization Interchange File Format）は国際化・ローカリゼーションのための標準的なファイル形式
- 本スクリプトはLocフリーズ期間外では通常無効化される（CIパイプライン設定で制御）
- git merge-baseを使用することで、PRの実際のマージ結果に基づく正確な差分を取得できる
