# バッチ設計書 23-generate-badges

## 概要

本ドキュメントは、README.md用のAzure DevOpsビルドステータスバッジを生成するためのスクリプト `scripts/generate-badges.ps1` の設計を記述する。

### 本バッチの処理概要

このバッチは、Roslynプロジェクトの各種ビルド・テストジョブのステータスバッジ（Markdown形式）を生成し、標準出力に出力する処理を実行する。

**業務上の目的・背景**：オープンソースプロジェクトにおいて、README.mdにビルドステータスバッジを表示することは、プロジェクトの健全性を外部に示す重要な手段である。Roslynプロジェクトは複数のブランチ（main、main-vs-deps）で複数のビルドジョブ（Windows/Unix、Debug/Release、各種テスト）を実行しており、これらのステータスを一覧で表示するためのMarkdownテーブルを手動で作成・維持するのは煩雑である。本バッチは、Azure DevOpsのビルドパイプライン情報に基づいてバッジを自動生成し、README.mdの更新を効率化する。

**バッチの実行タイミング**：本バッチは随時手動で実行される。新しいビルドジョブの追加やブランチ構成の変更時に実行し、出力をREADME.mdにコピー＆ペーストして使用する。

**主要な処理内容**：
1. Builds テーブル生成（Windows Debug/Release、Unix Debug）
2. Desktop Unit Tests テーブル生成（Debug/Release × x86/x64）
3. CoreClr Unit Tests テーブル生成（Windows Debug/Release、Linux）
4. Integration Tests テーブル生成（Debug/Release × x86/x64）
5. Misc Tests テーブル生成（Determinism、Analyzers、Build Correctness等）

**前後の処理との関連**：本バッチは独立したユーティリティスクリプトであり、他のバッチとの直接的な依存関係はない。出力結果は手動でREADME.mdに適用される。

**影響範囲**：本バッチは標準出力へのテキスト生成のみを行い、ファイルシステムやデータベースへの書き込みは行わない。生成されたバッジがREADME.mdに反映された場合、GitHub上でのプロジェクト表示に影響する。

## バッチ種別

ドキュメント生成（バッジMarkdown生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド構成変更時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShell実行環境が利用可能であること |

### 実行可否判定

特になし。パラメータ不要で常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| スクリプト内ハードコード | 配列 | ブランチ名、ジョブ名の定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Markdown | バッジテーブル（複数） |

### 出力ファイル仕様

本バッチは標準出力のみを使用し、ファイル出力は行わない。出力は手動でREADME.mdにコピーして使用する。

| 項目 | 内容 |
|-----|------|
| 出力形式 | Markdownテーブル |
| 文字コード | システムデフォルト |

## 処理フロー

### 処理シーケンス

```
1. Buildsテーブル生成
   └─ Get-BuildsTable関数呼び出し
2. Desktop Unit Testsテーブル生成
   └─ Get-DesktopTable関数呼び出し
3. CoreClr Unit Testsテーブル生成
   └─ Get-CoreClrTable関数呼び出し
4. Integration Testsテーブル生成
   └─ Get-IntegrationTable関数呼び出し
5. Misc Testsテーブル生成
   └─ Get-MiscTable関数呼び出し
6. 結果出力
   └─ 各テーブルを順次標準出力へ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Get-BuildsTable]
    B --> C[Get-DesktopTable]
    C --> D[Get-CoreClrTable]
    D --> E[Get-IntegrationTable]
    E --> F[Get-MiscTable]
    F --> G[標準出力へ出力]
    G --> H[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 実行時エラー | PowerShellスクリプトエラー | エラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時は例外メッセージとスタックトレースが出力される。スクリプト内のハードコードされた値（ジョブ名、ブランチ名）とAzure DevOpsの実際の設定を照合して修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 固定（ブランチ数×ジョブ数） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用操作のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 例外発生時 | 例外メッセージとスタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 対象ブランチ：main、main-vs-deps
- Azure DevOpsパイプラインID：
  - roslyn-CI: 95
  - roslyn-integration-CI: 96
- 生成されるテーブル：
  1. Builds（Windows Debug/Release、Unix Debug）
  2. Desktop Unit Tests（Debug/Release × x86/x64）
  3. CoreClr Unit Tests（Windows Debug/Release、Linux）
  4. Integration Tests（Debug/Release × x86/x64）
  5. Misc Tests（Determinism、Analyzers、Build Correctness、Source-Build、TODO/Prototype、Spanish、macOS）
- バッジURLにはURL エンコードされたジョブ名が含まれる
- 出力されたMarkdownはREADME.mdに手動でコピーして使用する
