# バッチ設計書 24-cleanup_perf

## 概要

本ドキュメントは、パフォーマンステスト実行後の環境クリーンアップを行うためのスクリプト `scripts/cleanup_perf.ps1` の設計を記述する。

### 本バッチの処理概要

このバッチは、パフォーマンステスト実行後に残存する可能性のあるプロセス（CPC、MSBuild、コンパイラ等）を終了し、テストトレースファイルやログを削除する環境クリーンアップ処理を実行する。

**業務上の目的・背景**：Roslynプロジェクトのパフォーマンステストでは、CPC（Consumption Performance Collector）というツールを使用してETL（Event Trace Log）トレースを収集する。テストランナーがクラッシュした場合、CPCが正常に終了せずに動作し続け、ディスク全体をETLトレースで埋め尽くす可能性がある。また、MSBuildやコンパイラプロセスが残存することで、後続のテストやビルドに影響を与える可能性がある。本バッチは、これらの問題を防止するために、パフォーマンステスト後の環境を確実にクリーンな状態に戻す。

**バッチの実行タイミング**：本バッチはパフォーマンステストの終了後に自動または手動で実行される。CIパイプラインでは、パフォーマンステストステップの後続ステップとして配置される。

**主要な処理内容**：
1. 関連プロセス（Cpc.exe、msbuild.exe、csc.exe、vbc.exe、VBCSCompiler.exe）の強制終了
2. CPCの停止コマンド実行
3. テストトレースデータのアーカイブ（オプション）
4. CPC関連ディレクトリ（C:/CPC、C:/CPCTraces、C:/PerfLogs、C:/PerfTemp）の削除

**前後の処理との関連**：本バッチはパフォーマンステストバッチの後続処理として位置づけられる。テスト実行の成否に関わらず実行され、環境を初期状態に戻す。

**影響範囲**：本バッチはシステムプロセスの終了とファイルシステムへの削除操作を行う。誤実行した場合、実行中のビルドやコンパイル処理に影響を与える可能性がある。

## バッチ種別

環境クリーンアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（パフォーマンステスト後） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CIパイプライン/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows環境 | Windows OSで実行されること |
| 管理者権限 | プロセス終了・ディレクトリ削除に必要な権限があること |

### 実行可否判定

特になし。パフォーマンステスト後に常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CPCLocation | string | No | "C:/CPC" | CPCのインストールディレクトリ |
| ShouldArchive | switch | No | false | トレースデータをアーカイブするかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| C:/CPC | ディレクトリ | CPCインストールディレクトリ |
| C:/CPCTraces | ディレクトリ | CPCトレースデータ |
| C:/PerfLogs | ディレクトリ | パフォーマンスログ |
| C:/PerfTemp | ディレクトリ | パフォーマンス一時ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ToArchive | ディレクトリ | アーカイブ対象データ（ShouldArchive時のみ） |
| 標準出力 | テキスト | 処理進捗メッセージ |
| 終了コード | 整数 | 0: 正常終了、1: エラー発生 |

### 出力ファイル仕様

ShouldArchiveフラグが有効な場合のみ、ToArchiveディレクトリにデータを移動する。

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | ToArchive |
| 内容 | DataBackup*、consumptionTempResults.xml、PerfLogs |

## 処理フロー

### 処理シーケンス

```
1. プロセス強制終了
   └─ Cpc.exe、msbuild.exe、csc.exe、vbc.exe、VBCSCompiler.exe
2. CPC停止
   └─ cpc.exe /Stop /SkipClean 実行
3. アーカイブ処理（オプション）
   └─ ToArchiveディレクトリへのデータ移動
4. CPCディレクトリ削除
   └─ $CPCLocation の削除
5. トレースディレクトリ削除
   └─ C:/CPCTraces の削除
6. ログディレクトリ削除
   └─ C:/PerfLogs の削除
7. 一時ディレクトリ削除
   └─ C:/PerfTemp の削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[プロセス強制終了]
    B --> C[CPC停止コマンド実行]
    C --> D{ToArchiveディレクトリ存在?}
    D -->|はい| E[ToArchive削除]
    D -->|いいえ| F{ShouldArchive?}
    E --> F
    F -->|はい| G[ToArchiveディレクトリ作成]
    G --> H[CPCデータ移動]
    H --> I[PerfLogs移動]
    F -->|いいえ| J[CPCディレクトリ削除]
    I --> J
    J --> K{削除成功?}
    K -->|はい| L[CPCTraces削除]
    K -->|いいえ| M[マシン再起動]
    L --> N[PerfLogs削除]
    N --> O[PerfTemp削除]
    O --> P[終了コード設定]
    M --> P
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ディレクトリ削除失敗 | CPCディレクトリ削除失敗 | マシン再起動が自動実行される |
| 1 | データ移動失敗 | アーカイブ処理失敗 | エラーメッセージを確認、手動でクリーンアップ |
| 1 | ディレクトリ削除失敗 | トレース/ログ/一時ディレクトリ削除失敗 | 手動でクリーンアップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

CPCディレクトリの削除に失敗した場合、マシンが自動的に5秒後に再起動される。これは異常事態であり、mlinfraswat@microsoft.com への報告が求められる。その他のディレクトリ削除失敗の場合は手動でのクリーンアップを行う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 固定（ディレクトリ4箇所） |
| 目標処理時間 | 数秒〜数分（データ量依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ実行中は、対象プロセス（MSBuild、コンパイラ等）を使用する他の処理との同時実行を避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ディレクトリ操作時 | "creating ToArchive directory"、"moving..."、"removing..."、"done." |
| エラーログ | コピー失敗時 | "Copying CPC data failed"、"Copying PerfLogs failed" |
| 警告ログ | CPC削除失敗時 | "Removing CPC failed, restarting the machine. THIS SHOULD NOT HAPPEN..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| マシン再起動発生 | 1回 | mlinfraswat@microsoft.com |
| 終了コード | 1 | CI通知 |

## 備考

- CPC（Consumption Performance Collector）はMicrosoft製のパフォーマンス計測ツール
- taskkillコマンドを使用してプロセスを強制終了（/Fオプション）
- アーカイブデータにはETLトレースとパフォーマンス結果XMLが含まれる
- CPCディレクトリ削除失敗時のマシン再起動は、ロックされたファイルを解放するための措置
- 削除対象ディレクトリはすべてCドライブ直下に配置される想定
