# バッチ設計書 25-crossgen

## 概要

本ドキュメントは、CrossGenツールを使用してRoslynコンパイラアセンブリのネイティブイメージを生成するためのスクリプト `scripts/crossgen.sh` の設計を記述する。

### 本バッチの処理概要

このバッチは、.NET Core環境でRoslynコンパイラ関連のアセンブリに対してCrossGenツールを適用し、事前コンパイル（Ahead-of-Time Compilation）によるネイティブイメージを生成する処理を実行する。

**業務上の目的・背景**：.NET CoreアプリケーションはデフォルトでJIT（Just-In-Time）コンパイルによりILコードを実行時にネイティブコードに変換する。これには起動時のオーバーヘッドが発生する。CrossGenはAOT（Ahead-of-Time）コンパイルツールであり、事前にネイティブイメージを生成することで、アプリケーションの起動時間を短縮できる。Roslynコンパイラ（csc.exe、vbc.exe）は頻繁に呼び出されるツールであるため、起動時間の短縮は開発者の生産性向上に直結する。

**バッチの実行タイミング**：本バッチはRoslynのビルド後、パッケージングまたはデプロイ前に実行される。パフォーマンス最適化が必要な環境向けのリリースビルド時に使用される。

**主要な処理内容**：
1. RID（Runtime Identifier）の自動検出（macOS/Linux）
2. CoreCLRバージョンの取得（Dependencies.propsから）
3. CrossGenツールのコピーと実行権限設定
4. 主要アセンブリへのCrossGen適用（mscorlib、System.Collections.Immutable、System.Reflection.Metadata、Microsoft.CodeAnalysis.*、csc.exe、vbc.exe）

**前後の処理との関連**：本バッチはビルドバッチの後続処理として位置づけられる。ビルドによって生成されたアセンブリを入力として受け取り、ネイティブイメージを生成する。生成されたネイティブイメージはパッケージングまたはデプロイの対象となる。

**影響範囲**：本バッチは指定されたディレクトリ内のアセンブリファイルを処理する。元のアセンブリファイルはそのまま残り、ネイティブイメージが追加で生成される。

## バッチ種別

パフォーマンス最適化（ネイティブイメージ生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリースビルド時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix環境 | macOSまたはLinux環境で実行されること |
| NuGetパッケージ | CoreCLRランタイムパッケージがNuGetキャッシュに存在すること |
| ビルド完了 | 対象アセンブリが生成済みであること |

### 実行可否判定

RIDが検出できない場合（未対応OS）はエラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | - | Roslynアセンブリが格納されているディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Targets/Dependencies.props | XML | CoreCLRバージョン情報 |
| ~/.nuget/packages/runtime.{RID}.Microsoft.NETCore.Runtime.CoreCLR | ディレクトリ | CrossGenツール |
| 指定ディレクトリ内のアセンブリ | DLL/EXE | CrossGen対象ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 指定ディレクトリ | ネイティブイメージ | CrossGen生成ファイル |

### 出力ファイル仕様

CrossGenは元のアセンブリファイルと同じディレクトリにネイティブイメージを生成する。

| 項目 | 内容 |
|-----|------|
| 出力先 | 入力パラメータで指定されたディレクトリ |
| ファイル形式 | ネイティブイメージ（.niファイル） |

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ解決
   └─ 入力パラメータの絶対パス取得
2. RID検出
   └─ uname によるOS判定（Darwin→osx-x64、Linux→linux-x64）
3. CoreCLRバージョン取得
   └─ Dependencies.props からバージョン抽出
4. CrossGenツール準備
   └─ NuGetキャッシュからCrossGenをコピー、実行権限付与
5. mscorlib.dll のCrossGen
   └─ ランタイム基盤ライブラリ
6. System.Collections.Immutable.dll のCrossGen
   └─ 不変コレクションライブラリ
7. System.Reflection.Metadata.dll のCrossGen
   └─ メタデータ読み取りライブラリ
8. Microsoft.CodeAnalysis.dll のCrossGen
   └─ コンパイラ共通ライブラリ
9. Microsoft.CodeAnalysis.CSharp.dll のCrossGen
   └─ C#コンパイラライブラリ
10. Microsoft.CodeAnalysis.VisualBasic.dll のCrossGen
    └─ VBコンパイラライブラリ
11. csc.exe のCrossGen
    └─ C#コンパイラ実行ファイル
12. vbc.exe のCrossGen
    └─ VBコンパイラ実行ファイル
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力ディレクトリ解決]
    B --> C{RID環境変数設定済み?}
    C -->|はい| D[RID使用]
    C -->|いいえ| E{OS判定}
    E -->|Darwin| F[RID=osx-x64]
    E -->|Linux| G[RID=linux-x64]
    E -->|その他| H[エラー終了]
    F --> I[CoreCLRバージョン取得]
    G --> I
    D --> I
    I --> J[CrossGenツールコピー]
    J --> K[実行権限設定]
    K --> L[mscorlib.dll CrossGen]
    L --> M[System.Collections.Immutable.dll CrossGen]
    M --> N[System.Reflection.Metadata.dll CrossGen]
    N --> O[Microsoft.CodeAnalysis.dll CrossGen]
    O --> P[Microsoft.CodeAnalysis.CSharp.dll CrossGen]
    P --> Q[Microsoft.CodeAnalysis.VisualBasic.dll CrossGen]
    Q --> R[csc.exe CrossGen]
    R --> S[vbc.exe CrossGen]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | OS未対応 | macOS/Linux以外のOS | 対応環境で実行 |
| 1 | ツール不存在 | CrossGenが見つからない | NuGetリストアを実行 |
| 1 | アセンブリ不存在 | 対象ファイルが見つからない | ビルドを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はset -eにより即座にスクリプトが終了する。必要な依存関係（CoreCLRパッケージ、ビルド成果物）を確認し、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 8アセンブリ |
| 目標処理時間 | 数十秒〜数分 |
| メモリ使用量上限 | CrossGenの使用量に依存 |

## 排他制御

同一ディレクトリへの同時実行は避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 本スクリプトは明示的なログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |

## 備考

- CrossGenは.NET Core/5以前のAOTコンパイルツール。.NET 6以降ではReadyToRunが推奨される
- RID（Runtime Identifier）はプラットフォーム固有の識別子（例：osx-x64、linux-x64）
- -nologoオプションでCrossGenのバナー出力を抑制
- -platform_assemblies_pathsオプションで依存アセンブリの検索パスを指定
- CrossGenはmscorlib.dllと同じディレクトリに配置される必要がある
- 対象ファイル一覧：
  1. mscorlib.dll
  2. System.Collections.Immutable.dll
  3. System.Reflection.Metadata.dll
  4. Microsoft.CodeAnalysis.dll
  5. Microsoft.CodeAnalysis.CSharp.dll
  6. Microsoft.CodeAnalysis.VisualBasic.dll
  7. csc.exe
  8. vbc.exe
