# バッチ設計書 26-generate-compiler-code

## 概要

本ドキュメントは、Roslynコンパイラのソースコードを自動生成するためのスクリプト `eng/generate-compiler-code.cmd` の設計を記述する。

### 本バッチの処理概要

このバッチは、XML定義ファイル（Syntax.xml、BoundNodes.xml、OperationInterfaces.xml等）からC#およびVBコンパイラのソースコードを自動生成する処理を実行する。

**業務上の目的・背景**：Roslynコンパイラは、構文ノード、バウンドノード、IOperation等の多数のクラスを持つ。これらのクラスは定型的なパターンに従っており、手動で記述すると冗長でエラーが発生しやすい。本バッチは、XML定義ファイルから自動的にこれらのクラスを生成することで、コードの一貫性を保ち、開発効率を向上させる。また、構文定義の変更時に関連するすべてのコードを自動的に更新することで、変更漏れを防止する。

**バッチの実行タイミング**：本バッチは以下のタイミングで実行される：
- 構文定義（Syntax.xml）の変更時
- バウンドノード定義（BoundNodes.xml）の変更時
- IOperation定義（OperationInterfaces.xml）の変更時
- CIビルドでの生成コード整合性検証時（-testオプション）

**主要な処理内容**：
1. C#コンパイラソースコード生成
   - 構文ノード（Syntax.xml → Generated）
   - バウンドノード（BoundNodes.xml → Generated）
   - エラーファクト（ErrorCode.cs → ErrorFacts.Generated.cs）
2. VBコンパイラソースコード生成
   - 構文ノード（Syntax.xml → Generated）
   - バウンドノード（BoundNodes.xml → Generated）
   - エラーファクト（Errors.vb → ErrorFacts.Generated.vb）
3. VB GetTextソースコード生成
4. IOperationソースコード生成

**前後の処理との関連**：本バッチは構文定義変更後に実行され、生成されたソースコードはビルドバッチの入力となる。CIでは-testオプションで生成コードの整合性を検証する。

**影響範囲**：本バッチはsrc/Compilers配下のGeneratedディレクトリにソースファイルを生成する。これらのファイルはビルド時にコンパイルされ、コンパイラバイナリに含まれる。

## バッチ種別

コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（定義ファイル変更時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | dotnet runが実行可能であること |
| ジェネレータツール | src/Tools/Source/CompilerGeneratorToolsがビルド可能であること |

### 実行可否判定

特になし。常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -test | switch | No | false | テストモード（生成結果の検証のみ） |
| -configuration | string | No | Debug | ビルド構成 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/Compilers/CSharp/Portable/Syntax/Syntax.xml | XML | C#構文定義 |
| src/Compilers/CSharp/Portable/BoundTree/BoundNodes.xml | XML | C#バウンドノード定義 |
| src/Compilers/CSharp/Portable/Errors/ErrorCode.cs | C# | C#エラーコード定義 |
| src/Compilers/VisualBasic/Portable/Syntax/Syntax.xml | XML | VB構文定義 |
| src/Compilers/VisualBasic/Portable/BoundTree/BoundNodes.xml | XML | VBバウンドノード定義 |
| src/Compilers/VisualBasic/Portable/Errors/Errors.vb | VB | VBエラーコード定義 |
| src/Compilers/Core/Portable/Operations/OperationInterfaces.xml | XML | IOperation定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/Compilers/CSharp/Portable/Generated/ | C# | C#生成コード |
| src/Compilers/CSharp/Test/Syntax/Generated/ | C# | C#テスト用生成コード |
| src/Compilers/VisualBasic/Portable/Generated/ | VB | VB生成コード |
| src/Compilers/VisualBasic/Test/Syntax/Generated/ | VB | VBテスト用生成コード |
| src/ExpressionEvaluator/VisualBasic/Source/ResultProvider/Generated/ | VB | VB GetText生成コード |
| src/Compilers/Core/Portable/Generated/ | C# | IOperation生成コード |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | C#（.cs）、VB（.vb） |
| 文字コード | UTF-8 |
| 命名規則 | {元ファイル名}.Generated.{拡張子} |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ -test、-configurationオプションの処理
2. C#ソースコード生成
   └─ BoundTreeGenerator、CSharpSyntaxGenerator、CSharpErrorFactsGenerator実行
3. VBソースコード生成
   └─ BoundTreeGenerator、VBSyntaxGenerator、VBErrorFactsGenerator実行
4. VB GetTextソースコード生成
   └─ VBSyntaxGenerator（writeSource:false）実行
5. IOperationソースコード生成
   └─ IOperationGenerator実行
6. テストモード時の検証
   └─ 生成結果とリポジトリ内既存ファイルの比較
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[C#コード生成]
    C --> D[VBコード生成]
    D --> E[VB GetTextコード生成]
    E --> F[IOperationコード生成]
    F --> G{テストモード?}
    G -->|はい| H[生成結果検証]
    G -->|いいえ| I[正常終了]
    H --> J{差分あり?}
    J -->|あり| K[エラー終了]
    J -->|なし| I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検証失敗 | 生成コードと既存コードに差分がある | eng/generate-compiler-code.cmd を実行して更新 |
| 1 | 生成エラー | XML定義ファイルが不正 | 定義ファイルを修正 |
| 1 | ファイル不存在 | 生成対象ファイルが存在しない | eng/generate-compiler-code.cmd を実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

生成エラーが発生した場合は、入力XML定義ファイルの構文を確認する。検証失敗の場合は、定義ファイルを変更した後にgenerate-compiler-code.cmdを実行して生成コードを更新し、コミットする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 固定（言語数×ジェネレータ種類） |
| 目標処理時間 | 数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一リポジトリへの同時実行は避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各言語処理開始時 | "Generating C# files..."、"Generating VB files..."等 |
| 検証ログ | テストモード時 | "Verifying {fileName}" |
| エラーログ | 検証失敗時 | "Generated file '{path}' is out of date." |
| 結果ログ | 処理終了時 | "Generation succeeded." または "Generation failed." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |

## 備考

- 本バッチはdotnet runを使用してC#スクリプト（generate-compiler-code.cs）を実行する
- ジェネレータツールは以下のプロジェクトを使用：
  - BoundTreeGenerator
  - IOperationGenerator
  - CSharpSyntaxGenerator
  - CSharpErrorFactsGenerator
  - VisualBasicSyntaxGenerator
  - VisualBasicErrorFactsGenerator
- テストモード（-test）ではartifacts/log配下に一時ファイルを生成し、既存ファイルと比較する
- --no-cacheオプションでdotnetのキャッシュを無効化し、常に最新のコードを実行
- 生成されるファイルには以下が含まれる：
  - 構文ノードクラス
  - 構文ファクトリ
  - 構文ビジター
  - バウンドノードクラス
  - エラーファクトメソッド
  - IOperation実装クラス
