# バッチ設計書 29-sort-unshipped

## 概要

本ドキュメントは、未出荷API一覧ファイルをソートするためのスクリプト `scripts/sort-unshipped.cmd` の設計を記述する。

### 本バッチの処理概要

このバッチは、src配下のすべてのPublicAPI.Unshipped.txtファイルをアルファベット順にソートする処理を実行する。

**業務上の目的・背景**：PublicAPI.Unshipped.txtファイルには、新しく追加されたPublic APIが記録される。開発者が手動でAPIを追加する際、ファイルの末尾に追記されることが多く、ファイル内の順序が乱れがちになる。これにより、PRのレビュー時に差分が見づらくなり、同一APIの重複追加に気づきにくくなる問題がある。本バッチは、すべてのUnshipped.txtファイルをソートすることで、ファイルの一貫性を保ち、レビューを容易にする。

**バッチの実行タイミング**：本バッチは以下のタイミングで実行される：
- 新しいPublic APIを追加した後
- PRを作成する前のクリーンアップとして
- コードレビューでソートの指摘を受けた際

**主要な処理内容**：
1. src配下のすべてのPublicAPI.Unshipped.txtファイルを再帰的に検索
2. 各ファイルの内容を読み込み
3. アルファベット順にソート
4. ソート結果を元のファイルに上書き保存

**前後の処理との関連**：本バッチは独立したユーティリティスクリプトである。関連するバッチとしてmark-shipped.ps1があり、リリース時にはそちらを使用する。

**影響範囲**：本バッチはsrc配下のすべてのPublicAPI.Unshipped.txtファイルを上書き更新する。ファイル内容の順序のみが変更され、内容自体は変わらない（重複行がある場合を除く）。

## バッチ種別

ファイル整形（ソート）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows環境 | cmd.exeとPowerShellが利用可能であること |
| カレントディレクトリ | リポジトリルートで実行されること |

### 実行可否判定

src配下にPublicAPI.Unshipped.txtが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/**/PublicAPI.Unshipped.txt | テキスト | 未出荷API一覧ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/**/PublicAPI.Unshipped.txt | テキスト | ソート済み未出荷API一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（1行1API） |
| ソート順 | アルファベット順（大文字小文字区別） |
| 文字コード | 元ファイルと同じ |

## 処理フロー

### 処理シーケンス

```
1. ファイル検索
   └─ Get-ChildItem -Path src\ -Recurse -Filter PublicAPI.Unshipped.txt
2. 各ファイルに対してソート実行
   └─ Get-Content | Sort-Object | Set-Content
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[PowerShell実行]
    B --> C[src配下のUnshipped.txt検索]
    C --> D{ファイルあり?}
    D -->|なし| E[バッチ終了]
    D -->|あり| F[ファイル内容読み込み]
    F --> G[アルファベット順ソート]
    G --> H[ファイル上書き保存]
    H --> I[次のファイル]
    I --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルアクセスエラー | ファイルがロックされている | ロックを解除して再実行 |
| - | パスエラー | srcディレクトリが存在しない | リポジトリルートで実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はPowerShellからエラーメッセージが出力される。ファイルのアクセス権限やロック状態を確認し、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル単位） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト数（数十〜数百） |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

対象ファイルが他のプロセスによってロックされている場合は処理に失敗する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 本スクリプトはログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 本スクリプトは非常にシンプルな1行スクリプトである
- PowerShellの`Sort-Object`コマンドレットを使用してソートを実行
- Sort-Objectはデフォルトで大文字小文字を区別してソート（Culture依存）
- 空行はソート後にファイルの先頭に集まる
- 重複行がある場合もそのまま保持される（重複除去は行わない）
- REMコメント「Sort the PublicAPI.Unshipped.txt files」がスクリプトの目的を説明
- PowerShellを-Commandオプションで呼び出すワンライナー形式
