# バッチ設計書 3-eng/build.ps1

## 概要

本ドキュメントは、Roslynプロジェクトのメインビルドスクリプト「eng/build.ps1」の設計仕様を記載する。

### 本バッチの処理概要

eng/build.ps1は、Roslynプロジェクトのビルドプロセス全体を制御するPowerShellスクリプトである。リストア、ビルド、署名、パック、テスト、公開の各フェーズを統合的に管理する。

**業務上の目的・背景**：Roslynコンパイラの開発において、複雑なビルドプロセスを統一的に管理する中核スクリプトとして機能する。開発者のローカルビルドからCI/CD環境での公式ビルドまで、様々なシナリオに対応できる柔軟性を持つ。ブートストラップビルド（自身でビルドしたコンパイラを使用してのビルド）にも対応し、コンパイラの自己検証を可能にする。

**バッチの実行タイミング**：開発者による手動実行（Build.cmd経由または直接）、CI/CDパイプラインでの自動実行、公式リリースビルド時の実行など、様々なタイミングで使用される。

**主要な処理内容**：
1. コマンドライン引数の解析と検証（configuration, restore, build, test等）
2. ブートストラップコンパイラの構築（-bootstrapオプション時）
3. MSBuildを使用したソリューションのビルド
4. ユニットテストおよび統合テストの実行（-testDesktop, -testVsi等）
5. NuGetパッケージの作成と署名（-pack, -sign）
6. ビルド成果物の公開（-publish）
7. Visual Studio拡張機能のデプロイ（-deployExtensions）

**前後の処理との関連**：Build.cmd/build.shから呼び出される。build-utils.ps1、common/tools.ps1などのユーティリティスクリプトに依存する。テスト実行時はRunTests.dllを使用する。

**影響範囲**：Roslyn.slnxソリューション全体のビルド成果物、NuGetパッケージ、VSIX拡張機能、テスト結果、ログファイル等に影響を与える。

## バッチ種別

ビルド処理（リストア・コンパイル・テスト・パッケージング・公開）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン / 公式ビルド |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境でのみ実行可能 |
| PowerShell 5+ | PowerShell 5.0以上が必要 |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| Visual Studio | msbuildEngine=vsの場合、Visual Studioがインストールされていること |
| NuGet | NuGetパッケージ復元に必要 |

### 実行可否判定

- PowerShellバージョンが5未満の場合はエラー終了
- -testVsiと-testDesktop/-testCoreClrは同時指定不可
- -testVsiと-helixは同時指定不可
- -buildと-launchを同時指定する場合は-deployExtensionsも必要
- 公式ビルドオプションは-officialBuildIdと併用必須

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -configuration | string | No | Debug | ビルド構成（Debug/Release） |
| -verbosity | string | No | m | MSBuildの詳細度（q/m/n/d/diag） |
| -msbuildEngine | string | No | vs | MSBuildエンジン（dotnet/vs） |
| -restore | switch | No | false | パッケージリストア実行 |
| -build | switch | No | false | ビルド実行 |
| -rebuild | switch | No | false | リビルド実行 |
| -sign | switch | No | false | 署名実行 |
| -pack | switch | No | false | パッケージ作成 |
| -publish | switch | No | false | 成果物公開 |
| -launch | switch | No | false | VS開発者Hiveを起動 |
| -bootstrap | switch | No | false | ブートストラップコンパイラ使用 |
| -bootstrapDir | string | No | "" | ブートストラップコンパイラのパス |
| -binaryLog | switch | No | false | バイナリログ出力 |
| -ci | switch | No | false | CI環境フラグ |
| -testDesktop | switch | No | false | デスクトップユニットテスト実行 |
| -testCoreClr | switch | No | false | CoreClrユニットテスト実行 |
| -testVsi | switch | No | false | 統合テスト実行 |
| -testIOperation | switch | No | false | IOperation検証付きテスト |
| -testCompilerOnly | switch | No | false | コンパイラテストのみ |
| -deployExtensions | switch | No | false | VSIX拡張機能デプロイ |
| -runAnalyzers | switch | No | false | アナライザ実行 |
| -warnAsError | switch | No | false | 警告をエラーとして扱う |
| -solution | string | No | Roslyn.slnx | ビルド対象ソリューション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Roslyn.slnx | Solution | メインソリューションファイル |
| ソースコード | C#/VB | コンパイル対象のソースファイル群 |
| NuGet.config | XML | NuGetパッケージソース設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | DLL/EXE | コンパイル済みバイナリ |
| artifacts/packages | NuGet | 生成されたNuGetパッケージ |
| artifacts/VSSetup | VSIX | Visual Studio拡張機能 |
| artifacts/log | binlog/txt | ビルド・テストログ |
| artifacts/bootstrap | 各種 | ブートストラップコンパイラ |
| artifacts/TestResults | trx/html | テスト結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Build.binlog（バイナリログ時） |
| 出力先 | artifacts/log |
| 文字コード | バイナリ/UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析と検証
   └─ Process-Arguments関数でパラメータ整合性チェック
2. 環境初期化
   └─ build-utils.ps1読み込み、一時ディレクトリ設定
3. CI環境設定（-ci時）
   └─ プレビューSDK有効化、プロセスリスト表示
4. dotnetツール復元（-restore時）
   └─ dotnet tool restore実行
5. ブートストラップビルド（-bootstrap時）
   └─ make-bootstrap.ps1呼び出し
6. メインビルド（-restore/-build/-pack等）
   └─ BuildSolution関数でMSBuild実行
7. テスト実行（-testDesktop/-testVsi等）
   └─ TestUsingRunTests関数でRunTests.dll実行
8. VS起動（-launch時）
   └─ devenv.exeをRoslynDev Hiveで起動
9. 終了処理
   └─ 一時ディレクトリクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[build.ps1開始] --> B[引数解析]
    B --> C{引数検証OK?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[環境初期化]
    E --> F{-ci?}
    F -->|Yes| G[CI環境設定]
    F -->|No| H{-restore?}
    G --> H
    H -->|Yes| I[dotnet tool restore]
    H -->|No| J{-bootstrap?}
    I --> J
    J -->|Yes| K[ブートストラップビルド]
    J -->|No| L{ビルド系オプション?}
    K --> L
    L -->|Yes| M[BuildSolution]
    L -->|No| N{テストオプション?}
    M --> N
    N -->|Yes| O[TestUsingRunTests]
    N -->|No| P{-launch?}
    O --> P
    P -->|Yes| Q[devenv起動]
    P -->|No| R[正常終了]
    Q --> R
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | PowerShellバージョンエラー | PS 5未満 | PowerShell 5以上をインストール |
| 1 | 引数競合エラー | -testVsiと-testDesktopの同時指定等 | 正しい引数の組み合わせを使用 |
| 1 | ビルドエラー | コンパイルエラー | エラーメッセージに従い修正 |
| 1 | テストエラー | テスト失敗 | テスト結果を確認し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. artifacts/log配下のバイナリログを確認
3. CI環境の場合は`(NETCORE_ENGINEERING_TELEMETRY=Test)`タグ付きでエラー報告
4. ServiceHub/VsProjectFaultログを確認（-testVsi時）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ソリューション全体（約200プロジェクト） |
| 目標処理時間 | フルビルド: 10-30分、テスト: 30-60分 |
| メモリ使用量上限 | 環境依存（16GB推奨） |

## 排他制御

- MSBuildノード再利用（-nodeReuse:false推奨）により競合を回避
- 同一ディレクトリでの複数ビルド同時実行は非推奨
- 統合テスト時はVisual Studioプロセスの排他制御あり

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 常時 | ビルド進捗、テスト結果 |
| バイナリログ | -bl時 | MSBuild詳細ログ |
| コンパイラログ | ビルド時 | VBCSCompilerログ |
| テストログ | テスト時 | xUnit結果、HTML レポート |
| ServiceHubログ | -testVsi時 | VS統合テストログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | Azure DevOps |
| ビルド時間 | 環境依存 | Azure DevOps |
| テスト失敗率 | 0% | Azure DevOps |

## 備考

- 本スクリプトはRoslynプロジェクトのビルドの中核を担う
- 公式ビルドでは追加のオプション（-officialBuildId等）が必要
- IBC最適化データの適用は公式ビルド時のみ
- 統合テスト時はVSIXInstallerによる拡張機能のインストールが行われる
