# バッチ設計書 30-common-build

## 概要

本ドキュメントは、dotnet/arcade共通ビルドインフラストラクチャのメインエントリポイントスクリプト `eng/common/build.ps1` の設計を記述する。

### 本バッチの処理概要

このバッチは、.NETエコシステム全体で共有されるArcade SDKのビルドインフラストラクチャを提供し、restore、build、test、pack、sign、publish等のビルドフェーズを統一的に制御する処理を実行する。

**業務上の目的・背景**：.NET Foundationの多くのプロジェクト（Roslyn、Runtime、ASP.NET Core等）は、dotnet/arcadeリポジトリが提供する共通ビルドインフラストラクチャを使用している。これにより、ビルドプロセス、CI設定、パッケージング、署名、公開のプロセスが標準化され、メンテナンスコストが削減される。本バッチは、このArcade SDKのPowerShell版エントリポイントであり、統一されたコマンドラインインターフェースを提供する。

**バッチの実行タイミング**：本バッチは以下のタイミングで実行される：
- ローカル開発でのビルド・テスト実行
- CIパイプラインでのビルド・テスト・パッケージング
- リリースビルドでの署名・公開

**主要な処理内容**：
1. コマンドライン引数の解析
2. ツールセットの初期化（dotnet SDK、MSBuild等）
3. カスタムツールセットの初期化（restore-toolset.ps1があれば実行）
4. MSBuildを使用したビルド実行
5. クリーンアップ（-cleanオプション時）

**前後の処理との関連**：本バッチはArcade SDKのtools.ps1を読み込み、その機能を使用する。また、ビルドツールセット（Arcade.sdk）を初期化し、MSBuildターゲットを実行する。

**影響範囲**：本バッチはソリューション全体のビルドプロセスを制御する。artifactsディレクトリへのビルド成果物の出力、NuGetパッケージの生成、テストの実行等、プロジェクト全体に影響を与える。

## バッチ種別

ビルドインフラストラクチャ（共通ビルドスクリプト）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | dotnetコマンドが利用可能、または自動インストールされること |
| PowerShell | PowerShell実行環境が利用可能であること |

### 実行可否判定

tools.ps1が存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -configuration / -c | string | No | Debug | ビルド構成 |
| -platform | string | No | null | プラットフォーム構成 |
| -projects | string | No | null | ビルド対象プロジェクト（';'区切り） |
| -verbosity / -v | string | No | minimal | MSBuild詳細度 |
| -msbuildEngine | string | No | null | MSBuildエンジン（dotnet/vs） |
| -warnAsError | bool | No | true | 警告をエラーとして扱う |
| -nodeReuse | bool | No | true | MSBuildノード再利用 |
| -buildCheck | switch | No | false | /checkオプション有効化 |
| -restore / -r | switch | No | false | 依存関係のリストア |
| -deployDeps | switch | No | false | 依存関係のデプロイ |
| -build / -b | switch | No | false | ソリューションビルド |
| -rebuild | switch | No | false | ソリューション再ビルド |
| -deploy | switch | No | false | VSIXのデプロイ |
| -test / -t | switch | No | false | ユニットテスト実行 |
| -integrationTest | switch | No | false | 統合テスト実行 |
| -performanceTest | switch | No | false | パフォーマンステスト実行 |
| -sign | switch | No | false | 署名実行 |
| -pack | switch | No | false | NuGetパッケージ作成 |
| -publish | switch | No | false | 成果物公開 |
| -clean | switch | No | false | クリーンアップ |
| -productBuild / -pb | switch | No | false | VMR製品ビルド |
| -fromVMR | switch | No | false | VMRからのビルド |
| -binaryLog / -bl | switch | No | false | バイナリログ出力 |
| -excludeCIBinarylog / -nobl | switch | No | false | CIバイナリログ除外 |
| -ci | switch | No | false | CI環境での実行 |
| -prepareMachine | switch | No | false | マシン準備 |
| -runtimeSourceFeed | string | No | '' | ランタイムソースフィード |
| -runtimeSourceFeedKey | string | No | '' | ランタイムソースフィードキー |
| -excludePrereleaseVS | switch | No | false | プレリリースVS除外 |
| -nativeToolsOnMachine | switch | No | false | ネイティブツール使用 |
| -help | switch | No | false | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソリューションファイル | .sln/.slnx | ビルド対象 |
| プロジェクトファイル | .csproj/.vbproj | ビルド対象 |
| global.json | JSON | SDK設定 |
| eng/Versions.props | XML | バージョン設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | バイナリ | ビルド成果物 |
| artifacts/obj | オブジェクト | 中間ファイル |
| artifacts/log | ログ | ビルドログ |
| artifacts/packages | NuGet | パッケージ |
| artifacts/TestResults | XML/TRX | テスト結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| バイナリログ | artifacts/log/{Configuration}/Build.binlog |
| 配置先 | artifacts/{種類}/{Configuration}/{プロジェクト}/ |

## 処理フロー

### 処理シーケンス

```
1. 環境変数クリーンアップ
   └─ Platform環境変数のクリア
2. 引数解析
   └─ コマンドラインパラメータの処理
3. tools.ps1読み込み
   └─ Arcade共通関数の読み込み
4. ヘルプ/クリーン処理
   └─ -help時はヘルプ表示、-clean時はartifacts削除
5. CI環境設定
   └─ バイナリログ有効化、ノード再利用無効化
6. ネイティブツール初期化
   └─ -nativeToolsOnMachine時に環境変数設定
7. ツールセット初期化
   └─ InitializeToolset、InitializeCustomToolset
8. MSBuildビルド実行
   └─ 各種オプションをMSBuildプロパティとして渡す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Platform環境変数クリア]
    B --> C[tools.ps1読み込み]
    C --> D{-clean?}
    D -->|はい| E[artifactsディレクトリ削除]
    E --> F[終了コード0]
    D -->|いいえ| G{-help?}
    G -->|はい| H[ヘルプ表示]
    H --> F
    G -->|いいえ| I{-ci?}
    I -->|はい| J[バイナリログ有効化]
    J --> K[ノード再利用無効化]
    I -->|いいえ| L[ネイティブツール初期化]
    K --> L
    L --> M[ツールセット初期化]
    M --> N[カスタムツールセット初期化]
    N --> O[MSBuildビルド実行]
    O --> P{成功?}
    P -->|はい| Q[終了コード0]
    P -->|いいえ| R[エラーログ出力]
    R --> S[終了コード1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ツールセット初期化エラー | SDK/MSBuildの取得失敗 | ネットワーク接続確認、SDKバージョン確認 |
| 1 | ビルドエラー | コンパイルエラー | ソースコード修正 |
| 1 | テストエラー | テスト失敗 | テストコード/対象コード修正 |
| 1 | パッケージエラー | パッケージング失敗 | バージョン設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベル） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はスタックトレースとWrite-PipelineTelemetryErrorによるテレメトリが出力される。バイナリログ（-blオプション）を確認して詳細なエラー原因を特定する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト数に依存 |
| 目標処理時間 | プロジェクト規模に依存 |
| メモリ使用量上限 | MSBuild/コンパイラの使用量に依存 |

## 排他制御

-nodeReuseオプションでMSBuildノードの再利用を制御。CI環境では無効化される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | クリーン時 | 'Artifacts directory deleted.' |
| エラーログ | 例外発生時 | スタックトレース、テレメトリ |
| バイナリログ | -bl指定時 | MSBuildバイナリログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |

## 備考

- dotnet/arcadeリポジトリから提供される共通スクリプト
- eng/common/tools.ps1と連携して動作
- Roslynプロジェクト固有のカスタマイズはeng/restore-toolset.ps1で実装可能
- VMR（Virtual Monolithic Repository）ビルドに対応（-productBuild、-fromVMR）
- 主要なMSBuildプロパティ：
  - Configuration：ビルド構成
  - RepoRoot：リポジトリルート
  - Restore/Build/Test/Pack/Sign/Publish：各フェーズの有効化
- CI環境（-ci）では自動的にバイナリログが有効化され、ノード再利用が無効化される
- HP等の一部コンピュータでPlatform環境変数が設定されている問題に対応（行39-41）
- パラメータは省略形が使用可能（-c、-b、-r、-t、-bl等）
