# バッチ設計書 31-eng_common_build.sh

## 概要

本ドキュメントは、dotnet/arcadeフレームワークの共通ビルドスクリプト（Bash版）である `eng/common/build.sh` の設計仕様を定義するものです。

### 本バッチの処理概要

このバッチは、Unix/Linux環境およびmacOS環境において、.NETプロジェクトのビルド・テスト・パッケージング等の各種ビルドタスクを統一的に実行するためのエントリーポイントスクリプトです。dotnet/arcadeフレームワークを採用するすべてのリポジトリで共通して利用される基盤スクリプトであり、CI/CDパイプラインおよびローカル開発環境の両方で使用されます。

**業務上の目的・背景**：.NETエコシステム全体で一貫したビルド体験を提供するため、dotnet/arcadeフレームワークが開発されました。このスクリプトは、各リポジトリが独自のビルドスクリプトを維持する負担を軽減し、ビルドプロセスの標準化と保守性向上を実現します。CIパイプラインとローカル開発環境で同一のビルドロジックを使用することで、「CIでは動くがローカルでは動かない」といった問題を防止します。

**バッチの実行タイミング**：CIパイプラインでの自動実行（プルリクエスト検証、公式ビルド）、開発者によるローカル手動実行の両方で使用されます。

**主要な処理内容**：
1. コマンドライン引数の解析と各種フラグ設定（--restore, --build, --test, --pack等）
2. tools.shの読み込みによるツールセットの初期化
3. .NET CLIおよびMSBuildの初期化
4. ネイティブツールの初期化（restoreフラグが有効な場合）
5. MSBuildを使用したソリューションのビルド実行
6. ビルド結果に基づく適切な終了コードの返却

**前後の処理との関連**：このスクリプトはtools.shに依存しており、tools.shはさらにpipeline-logging-functions.shやinit-tools-native.shなどを呼び出します。cibuild.shからも呼び出されます。

**影響範囲**：ビルド成果物（artifacts）ディレクトリ配下のファイル、NuGetパッケージキャッシュ、.dotnetディレクトリ内のSDKインストール

## バッチ種別

ビルド実行 / リストア / テスト / パッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動/CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Unix/Linux/macOS等のBash実行環境が必要 |
| global.json | リポジトリルートにglobal.jsonが存在すること |
| eng/commonディレクトリ | tools.sh等の依存スクリプトが配置されていること |

### 実行可否判定

- `--clean`オプション指定時はartifactsディレクトリを削除して即座に終了
- それ以外の場合はビルド処理を実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --configuration, -c | string | No | Debug (source-build時はRelease) | ビルド構成（Debug/Release） |
| --verbosity, -v | string | No | minimal | MSBuild詳細度（q/m/n/d/diag） |
| --binaryLog, -bl | switch | No | false | バイナリログ出力有効化 |
| --restore, -r | switch | No | false | 依存関係のリストア |
| --build, -b | switch | No | false | ソリューションのビルド |
| --rebuild | switch | No | false | リビルド実行 |
| --test, -t | switch | No | false | ユニットテスト実行 |
| --integrationTest | switch | No | false | 統合テスト実行 |
| --performanceTest | switch | No | false | パフォーマンステスト実行 |
| --pack | switch | No | false | NuGetパッケージ作成 |
| --sign | switch | No | false | ビルド成果物の署名 |
| --publish | switch | No | false | 成果物の公開 |
| --clean | switch | No | false | クリーン実行 |
| --projects | string | No | 空 | ビルド対象プロジェクト/ソリューション |
| --ci | switch | No | false | CI環境フラグ |
| --prepareMachine | switch | No | false | マシン準備/クリーンアップ有効化 |
| --nodeReuse | bool | No | true | MSBuildノード再利用設定 |
| --warnAsError | bool | No | true | 警告をエラーとして扱う |
| --sourceBuild, -sb | switch | No | false | ソースビルドモード |
| --productBuild, -pb | switch | No | false | 製品ビルドモード |
| --fromVMR | switch | No | false | VMRからのビルドフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDK/ツールバージョン定義 |
| *.sln/*.csproj | MSBuild | ビルド対象ソリューション/プロジェクト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | バイナリファイル | ビルド成果物 |
| artifacts/log | ログファイル | ビルドログ・バイナリログ |
| artifacts/packages | NuGetパッケージ | 生成パッケージ |
| artifacts/tmp | 一時ファイル | ビルド中間ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Build.binlog（バイナリログ有効時） |
| 出力先 | artifacts/log/{configuration}/ |
| 文字コード | バイナリ形式 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. シェルオプション設定
   └─ set -u（未定義変数エラー）、set -e（エラー時停止）
2. コマンドライン引数解析
   └─ 各フラグ・パラメータの値を変数に格納
3. 構成設定の決定
   └─ source_build時はRelease、それ以外はDebug（未指定時）
4. CI環境設定
   └─ pipelines_log有効化、node_reuse無効化、binary_log有効化
5. tools.shの読み込み
   └─ 共通関数・変数の定義
6. cleanフラグ処理
   └─ artifactsディレクトリ削除して終了
7. ネイティブツール初期化（restore時）
   └─ InitializeNativeTools関数呼び出し
8. Build関数実行
   └─ ツールセット初期化、MSBuildによるビルド実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[シェルオプション設定]
    B --> C[コマンドライン引数解析]
    C --> D[構成設定決定]
    D --> E{CI環境?}
    E -->|Yes| F[CI設定適用]
    E -->|No| G[tools.sh読み込み]
    F --> G
    G --> H{cleanフラグ?}
    H -->|Yes| I[artifactsディレクトリ削除]
    I --> J[終了 exit 0]
    H -->|No| K{restoreフラグ?}
    K -->|Yes| L[ネイティブツール初期化]
    K -->|No| M[Build関数実行]
    L --> M
    M --> N[MSBuildビルド実行]
    N --> O[終了 ExitWithExitCode 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了コード | MSBuildエラー | ビルド失敗時 | ビルドログを確認し、エラー原因を特定 |
| 1 | 初期化エラー | dotnet SDKが見つからない場合 | global.jsonのSDKバージョンを確認 |
| 2 | ツールセットエラー | Arcade SDKのリストア失敗 | ネットワーク接続とNuGetソースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（dotnet-install.shダウンロード時） |
| リトライ間隔 | 指数バックオフ（3^n-1秒） |
| リトライ対象エラー | ネットワークエラー、HTTP 429 |

### 障害時対応

1. ビルドログ（Build.binlog）を確認
2. artifacts/tmpディレクトリをクリア
3. `--clean`オプションで再実行
4. global.jsonのSDKバージョンがインストール可能か確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | プロジェクト規模に依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

- 同一ディレクトリでの同時実行は非推奨
- CI環境では`--nodeReuse false`により、MSBuildノードの競合を防止

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | 構成情報 |
| 進捗ログ | 処理中 | MSBuild出力（verbosityに依存） |
| 終了ログ | ビルド終了時 | ビルド結果サマリー |
| エラーログ | エラー発生時 | エラー詳細とスタックトレース |
| バイナリログ | --binaryLog指定時 | Build.binlog |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |
| 処理時間 | プロジェクト固有 | Azure Pipelines |

## 備考

- dotnet/arcadeフレームワークの一部として提供される共通スクリプト
- eng/build.shからも呼び出される（リポジトリ固有のラッパー）
- cibuild.shはこのスクリプトを特定のオプション付きで呼び出すラッパー
