# バッチ設計書 32-eng_common_cibuild.sh

## 概要

本ドキュメントは、dotnet/arcadeフレームワークの共通CIビルドスクリプト（Bash版）である `eng/common/cibuild.sh` の設計仕様を定義するものです。

### 本バッチの処理概要

このバッチは、CI（継続的インテグレーション）環境でのビルドを実行するための薄いラッパースクリプトです。`eng/common/build.sh`を特定のオプション（--restore, --build, --test, --pack, --publish, --ci）付きで呼び出すことで、CI環境に最適化された標準的なビルドプロセスを実行します。

**業務上の目的・背景**：CIパイプラインでのビルド実行において、毎回同じオプションを指定する手間を省くとともに、ビルドオプションの標準化を図ります。dotnet/arcadeを採用するすべてのリポジトリで一貫したCIビルド体験を提供することが目的です。Azure DevOpsやGitHub Actionsなどの各種CIプラットフォームから簡単に呼び出せるエントリーポイントとして機能します。

**バッチの実行タイミング**：CIパイプラインでの自動実行時（プルリクエスト検証ビルド、公式ビルド、定期ビルド等）に使用されます。

**主要な処理内容**：
1. スクリプトパスの解決（シンボリックリンク対応）
2. build.shスクリプトの呼び出し
3. 標準CIオプション（--restore --build --test --pack --publish --ci）の適用
4. 追加の引数のパススルー

**前後の処理との関連**：このスクリプトはeng/common/build.shに依存し、build.shが提供するすべての機能を継承します。Azure Pipelinesのyamlファイルやシェルスクリプトから直接呼び出されることを想定しています。

**影響範囲**：build.shと同等の影響範囲（artifacts配下のファイル、NuGetキャッシュ、.dotnetディレクトリ）

## バッチ種別

CIビルド実行ラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー時） |
| 実行時刻 | CI/CDパイプライン依存 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Unix/Linux/macOS等のBash実行環境が必要 |
| build.shの存在 | 同一ディレクトリにbuild.shが存在すること |
| CI環境 | CI/CDパイプライン環境での実行を想定 |

### 実行可否判定

build.shが存在し、実行可能であれば実行される

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string[] | No | 空 | build.shに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| build.sh | Bash | 依存するビルドスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build.shの出力 | 各種 | build.shが生成するすべての出力 |

### 出力ファイル仕様

build.shの出力仕様に準拠

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの取得
   └─ BASH_SOURCE[0]からソースパス取得
2. シンボリックリンクの解決
   └─ readlinkで実際のパスを解決
3. スクリプトルートの決定
   └─ dirnameでディレクトリパスを取得
4. build.shの呼び出し
   └─ 固定オプション + 追加引数で実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス取得]
    B --> C{シンボリックリンク?}
    C -->|Yes| D[readlinkでパス解決]
    D --> C
    C -->|No| E[スクリプトルート決定]
    E --> F[build.sh呼び出し]
    F --> G[--restore --build --test --pack --publish --ci + 追加引数]
    G --> H[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| build.shの終了コード | ビルドエラー | build.shがエラーで終了 | build.shのエラー内容を確認 |

### リトライ仕様

build.shの仕様に準拠

### 障害時対応

build.shの障害時対応に準拠

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | プロジェクト規模に依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

build.shの仕様に準拠

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| build.shのログ | 実行中 | build.shが出力するすべてのログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- 非常にシンプルなラッパースクリプト（17行のみ）
- 主な機能はbuild.shが提供
- CI環境専用のデフォルトオプションを適用
- 追加の引数はそのままbuild.shに渡される
