# バッチ設計書 33-eng_common_dotnet-install.ps1

## 概要

本ドキュメントは、.NET SDKおよびランタイムのインストールを行うPowerShellスクリプト `eng/common/dotnet-install.ps1` の設計仕様を定義するものです。

### 本バッチの処理概要

このバッチは、指定されたバージョンの.NET SDKまたはランタイムをリポジトリローカルの.dotnetディレクトリにインストールするためのスクリプトです。dotnet/arcadeフレームワークを使用するリポジトリにおいて、ビルドに必要な特定バージョンの.NETツールチェーンを確実にセットアップすることを目的としています。

**業務上の目的・背景**：.NETプロジェクトのビルドには特定バージョンのSDKやランタイムが必要です。開発者のマシンやCIエージェントに適切なバージョンがインストールされていない場合でも、このスクリプトを使用することでビルドに必要な環境を自動的にセットアップできます。これにより、「手元では動くがCIでは動かない」といった環境差異の問題を解消します。

**バッチの実行タイミング**：ビルドプロセスの初期段階（tools.ps1のInitializeDotNetCli関数から呼び出し）、または手動でのSDK/ランタイムインストール時に実行されます。

**主要な処理内容**：
1. tools.ps1の読み込み
2. アーキテクチャに基づくインストールディレクトリの決定
3. InstallDotNet関数の呼び出しによるインストール実行
4. エラー発生時のテレメトリ出力と適切な終了コードの返却

**前後の処理との関連**：tools.ps1に定義されたInstallDotNet関数を使用し、Microsoft公式またはプライベートフィードから.NETをダウンロードしてインストールします。dotnet-install.cmdからも呼び出されます。

**影響範囲**：.dotnetディレクトリ配下のSDK/ランタイムファイル、環境変数DOTNET_INSTALL_DIR

## バッチ種別

SDK/ランタイムインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド初期化時・手動実行時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | ビルドスクリプト/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | Windows PowerShell または PowerShell Core |
| tools.ps1の存在 | 同一ディレクトリにtools.ps1が存在すること |
| ネットワーク接続 | .NETインストーラーダウンロードのため |

### 実行可否判定

常に実行可能（インストール済みの場合はスキップされる場合あり）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -verbosity | string | No | minimal | インストール詳細度 |
| -architecture | string | No | 空（自動検出） | ターゲットアーキテクチャ（x64/x86/arm64等） |
| -version | string | No | Latest | インストールするバージョン |
| -runtime | string | No | dotnet | ランタイム種別（dotnet/aspnetcore/windowsdesktop） |
| -RuntimeSourceFeed | string | No | 空 | 代替ダウンロードフィードURL |
| -RuntimeSourceFeedKey | string | No | 空 | フィード認証用Base64エンコードキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDKバージョン定義（間接参照） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .dotnet/ | ディレクトリ | インストールされたSDK/ランタイム |
| .dotnet/x86/ | ディレクトリ | x86アーキテクチャの場合のインストール先 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | dotnet.exe、各種SDK/ランタイムファイル |
| 出力先 | リポジトリルート/.dotnet/ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. tools.ps1の読み込み
   └─ 共通関数のインポート
2. dotnetRootの設定
   └─ $RepoRoot/.dotnetディレクトリをベースに設定
3. アーキテクチャ判定
   └─ x86指定時は.dotnet/x86サブディレクトリを使用
4. InstallDotNet関数呼び出し
   └─ インストールディレクトリ、バージョン、アーキテクチャ、ランタイム種別を指定
5. エラーハンドリング
   └─ 例外発生時はテレメトリ出力して終了コード1で終了
6. 正常終了
   └─ ExitWithExitCode 0で終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[dotnetRoot設定]
    C --> D{architecture == x86?}
    D -->|Yes| E[installdir = .dotnet/x86]
    D -->|No| F[installdir = .dotnet]
    E --> G[InstallDotNet呼び出し]
    F --> G
    G --> H{成功?}
    H -->|Yes| I[ExitWithExitCode 0]
    H -->|No| J[エラー出力]
    J --> K[ExitWithExitCode 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | InitializeToolset | InstallDotNet関数が例外をスロー | ネットワーク接続確認、フィードURL確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（tools.ps1のRetry関数） |
| リトライ間隔 | 指数バックオフ（2^n-1秒） |
| リトライ対象エラー | ダウンロードエラー |

### 障害時対応

1. ネットワーク接続を確認
2. RuntimeSourceFeedが指定されている場合はフィードURLの有効性を確認
3. RuntimeSourceFeedKeyが正しいBase64エンコードか確認
4. 手動で.dotnetディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1インストール |
| 目標処理時間 | ネットワーク速度に依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

- 同一ディレクトリへの同時インストールは非推奨
- ファイルロックにより競合が発生する可能性

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | インストール中 | ダウンロード・インストール進捗 |
| エラーログ | エラー発生時 | スタックトレース、エラーメッセージ |
| テレメトリ | エラー発生時 | Write-PipelineTelemetryError出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- dotnet-install.cmdからも呼び出し可能
- 複数のフィード（公式、ci.dot.net、プライベート）から順次試行
- 既にインストール済みのバージョンはスキップされる場合あり
