# バッチ設計書 34-eng_common_dotnet-install.sh

## 概要

本ドキュメントは、.NET SDKおよびランタイムのインストールを行うBashスクリプト `eng/common/dotnet-install.sh` の設計仕様を定義するものです。

### 本バッチの処理概要

このバッチは、Unix/Linux/macOS環境において、指定されたバージョンの.NET SDKまたはランタイムをリポジトリローカルの.dotnetディレクトリにインストールするためのスクリプトです。CPU アーキテクチャを自動検出し、適切なバイナリをダウンロード・インストールします。

**業務上の目的・背景**：Unix系環境での.NETプロジェクトビルドにおいて、特定バージョンのSDKやランタイムを確実にセットアップするためのスクリプトです。ARM64、x64、x86、RISC-V、LoongArch64など、多様なアーキテクチャに対応しており、クロスプラットフォーム開発を支援します。Raspberry Piのような32ビットOS on 64ビットCPU環境も正しく検出します。

**バッチの実行タイミング**：ビルドプロセスの初期段階（tools.shのInitializeDotNetCli関数から呼び出し）、または手動でのSDK/ランタイムインストール時に実行されます。

**主要な処理内容**：
1. tools.shの読み込み
2. コマンドライン引数の解析
3. CPUアーキテクチャの自動検出（uname -m使用）
4. インストールディレクトリの決定
5. InstallDotNet関数の呼び出しによるインストール実行
6. エラー発生時のテレメトリ出力と適切な終了コードの返却

**前後の処理との関連**：tools.shに定義されたInstallDotNet関数を使用し、Microsoft公式またはプライベートフィードから.NETをダウンロードしてインストールします。

**影響範囲**：.dotnetディレクトリ配下のSDK/ランタイムファイル、環境変数DOTNET_INSTALL_DIR

## バッチ種別

SDK/ランタイムインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド初期化時・手動実行時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | ビルドスクリプト/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Unix/Linux/macOS等のBash実行環境 |
| tools.shの存在 | 同一ディレクトリにtools.shが存在すること |
| ネットワーク接続 | .NETインストーラーダウンロードのため |
| uname コマンド | アーキテクチャ検出のため |

### 実行可否判定

常に実行可能（インストール済みの場合はスキップされる場合あり）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -version, -v | string | No | Latest | インストールするバージョン |
| -architecture, -a | string | No | 自動検出 | ターゲットアーキテクチャ |
| -runtime, -r | string | No | dotnet | ランタイム種別 |
| -runtimesourcefeed | string | No | 空 | 代替ダウンロードフィードURL |
| -runtimesourcefeedkey | string | No | 空 | フィード認証用Base64エンコードキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| uname -m | コマンド出力 | CPUアーキテクチャ検出 |
| getconf LONG_BIT | コマンド出力 | OS ビット数検出 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .dotnet/ | ディレクトリ | インストールされたSDK/ランタイム |
| .dotnet/{architecture}/ | ディレクトリ | 異なるアーキテクチャの場合のインストール先 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | dotnet、各種SDK/ランタイムファイル |
| 出力先 | リポジトリルート/.dotnet/ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ シンボリックリンク対応
2. tools.shの読み込み
   └─ 共通関数のインポート
3. コマンドライン引数の解析
   └─ バージョン、アーキテクチャ、ランタイム種別の設定
4. CPUアーキテクチャの自動検出
   └─ uname -mの結果に基づき適切なアーキテクチャ名に変換
5. dotnetRootの決定
   └─ 指定アーキテクチャがビルドアーキテクチャと異なる場合はサブディレクトリ使用
6. InstallDotNet関数呼び出し
   └─ インストール実行
7. エラーハンドリング
   └─ 失敗時はテレメトリ出力して終了コード返却
8. 正常終了
   └─ ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[tools.sh読み込み]
    C --> D[コマンドライン引数解析]
    D --> E[uname -mでCPU検出]
    E --> F{アーキテクチャ判定}
    F -->|arm64/aarch64| G[buildarch=arm64]
    F -->|amd64/x86_64| H[buildarch=x64]
    F -->|armv*l| I[buildarch=arm]
    F -->|i386/i686| J[buildarch=x86]
    F -->|loongarch64| K[buildarch=loongarch64]
    F -->|riscv64| L[buildarch=riscv64]
    F -->|その他| M[buildarch=x64として扱う]
    G --> N{32bit OS on 64bit CPU?}
    N -->|Yes| O[buildarch=arm]
    N -->|No| P[dotnetRoot決定]
    H --> P
    I --> P
    J --> P
    K --> P
    L --> P
    M --> P
    O --> P
    P --> Q{architecture != buildarch?}
    Q -->|Yes| R[dotnetRoot/.dotnet/architecture]
    Q -->|No| S[dotnetRoot/.dotnet]
    R --> T[InstallDotNet呼び出し]
    S --> T
    T --> U{成功?}
    U -->|Yes| V[ExitWithExitCode 0]
    U -->|No| W[エラー出力]
    W --> X[ExitWithExitCode error_code]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 無効な引数が指定された | 正しい引数を指定 |
| InstallDotNet終了コード | インストールエラー | ダウンロードまたはインストール失敗 | ネットワーク接続確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（tools.shのwith_retries関数） |
| リトライ間隔 | 指数バックオフ（3^n-1秒） |
| リトライ対象エラー | ダウンロードエラー |

### 障害時対応

1. ネットワーク接続を確認
2. uname -mの出力を確認
3. runtimeSourceFeedが指定されている場合はフィードURLの有効性を確認
4. 手動で.dotnetディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1インストール |
| 目標処理時間 | ネットワーク速度に依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

- 同一ディレクトリへの同時インストールは非推奨
- ファイルロックにより競合が発生する可能性

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | インストール中 | ダウンロード・インストール進捗 |
| エラーログ | エラー発生時 | エラーメッセージ |
| テレメトリ | エラー発生時 | Write-PipelineTelemetryError出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- サポートアーキテクチャ: arm64, x64, arm, x86, loongarch64, riscv64
- Raspberry Pi OS（32bit on 64bit CPU）の特殊ケースに対応
- 未知のCPUはx64として扱い警告を出力
- PowerShell版（dotnet-install.ps1）と同等の機能を提供
