# バッチ設計書 35-eng_common_dotnet-install.cmd

## 概要

本ドキュメントは、Windows コマンドプロンプトから.NET SDKインストールスクリプトを呼び出すためのラッパーバッチファイル `eng/common/dotnet-install.cmd` の設計仕様を定義するものです。

### 本バッチの処理概要

このバッチは、Windows コマンドプロンプト環境から PowerShell スクリプト（dotnet-install.ps1）を呼び出すための薄いラッパーです。コマンドプロンプトから直接.NETのインストールを実行したい場合に使用されます。

**業務上の目的・背景**：Windows環境において、PowerShellを直接起動せずにコマンドプロンプトから.NETインストールを実行できるようにするためのユーティリティです。従来のバッチファイルベースのビルドシステムとの互換性維持や、PowerShell実行ポリシーの制約を回避するために使用されます。

**バッチの実行タイミング**：手動実行時、または従来のバッチファイルベースのビルドスクリプトからの呼び出し時に実行されます。

**主要な処理内容**：
1. PowerShellの起動（ExecutionPolicy ByPass、NoProfile）
2. 同一ディレクトリのdotnet-install.ps1の実行
3. コマンドライン引数のパススルー

**前後の処理との関連**：dotnet-install.ps1に全ての処理を委譲します。このスクリプト自体はロジックを持たない単純なラッパーです。

**影響範囲**：dotnet-install.ps1と同等

## バッチ種別

ラッパースクリプト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動/スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows環境 | Windows OS上で実行 |
| PowerShell | PowerShellがインストールされていること |
| dotnet-install.ps1 | 同一ディレクトリにスクリプトが存在すること |

### 実行可否判定

常に実行可能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | 空 | dotnet-install.ps1に渡す引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| dotnet-install.ps1 | PowerShell | 依存するインストールスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| dotnet-install.ps1の出力 | 各種 | 全てdotnet-install.ps1に依存 |

### 出力ファイル仕様

dotnet-install.ps1の仕様に準拠

## 処理フロー

### 処理シーケンス

```
1. echo offでコマンドエコー無効化
2. PowerShell起動
   └─ -ExecutionPolicy ByPass: 実行ポリシー回避
   └─ -NoProfile: プロファイル読み込みスキップ
3. dotnet-install.ps1実行
   └─ %~dp0で同一ディレクトリを指定
   └─ %*で全引数をパススルー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off]
    B --> C[PowerShell起動]
    C --> D[dotnet-install.ps1実行]
    D --> E[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| dotnet-install.ps1の終了コード | インストールエラー | PowerShellスクリプトがエラーで終了 | dotnet-install.ps1のエラー内容を確認 |

### リトライ仕様

dotnet-install.ps1の仕様に準拠

### 障害時対応

dotnet-install.ps1の障害時対応に準拠

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1実行 |
| 目標処理時間 | dotnet-install.ps1に依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

dotnet-install.ps1の仕様に準拠

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| dotnet-install.ps1のログ | 実行中 | dotnet-install.ps1が出力するすべてのログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元 |

## 備考

- わずか2行の非常にシンプルなラッパースクリプト
- ExecutionPolicy ByPassにより、実行ポリシー制限を回避
- NoProfileにより、ユーザープロファイル読み込みをスキップして高速起動
- %~dp0により、スクリプトの配置場所に依存しない相対パス指定
