# バッチ設計書 36-eng_common_tools.ps1

## 概要

本ドキュメントは、dotnet/arcadeフレームワークの共通ツールユーティリティ（PowerShell版）である `eng/common/tools.ps1` の設計仕様を定義するものです。

### 本バッチの処理概要

このスクリプトは、.NETプロジェクトのビルドに必要な各種ツール（MSBuild、dotnet CLI等）の初期化、設定、実行をサポートする共通ユーティリティライブラリです。dotnet/arcadeフレームワークを使用するすべてのリポジトリのビルドスクリプトから読み込まれ、基盤となる機能を提供します。

**業務上の目的・背景**：.NETエコシステム全体で一貫したビルド体験を提供するため、ビルドツールの初期化・実行に関する共通ロジックを集約しています。このスクリプトにより、各リポジトリが独自にツール初期化ロジックを実装する必要がなくなり、保守性が大幅に向上します。また、CI環境とローカル開発環境で同一のロジックを使用することで、環境差異による問題を防止します。

**バッチの実行タイミング**：build.ps1やeng/build.ps1などのビルドスクリプトからドットソースで読み込まれ、各関数が必要に応じて呼び出されます。

**主要な処理内容**：
1. ビルド変数の初期化（configuration、verbosity、ci等）
2. .NET CLIの初期化とインストール（InitializeDotNetCli）
3. Visual Studio/MSBuildの検出と初期化（InitializeVisualStudioMSBuild）
4. Arcade SDKツールセットの初期化（InitializeToolset）
5. MSBuildコマンドの実行（MSBuild、MSBuild-Core）
6. ディレクトリ・パスユーティリティ関数の提供
7. Azure Pipelinesとの統合（パイプラインロギング）

**前後の処理との関連**：pipeline-logging-functions.ps1を読み込み、configure-toolset.ps1（存在する場合）をインポートします。init-tools-native.ps1やdarc-init.ps1など他の共通スクリプトと連携します。

**影響範囲**：artifacts配下のディレクトリ構造、環境変数（PATH、DOTNET_INSTALL_DIR、NUGET_PACKAGES等）、NuGetパッケージキャッシュ

## バッチ種別

ユーティリティライブラリ / ツール初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | ドットソースでの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | Windows PowerShell または PowerShell Core |
| global.json | リポジトリルートにglobal.jsonが存在すること |
| pipeline-logging-functions.ps1 | 同一ディレクトリに存在すること |

### 実行可否判定

常にロード可能

## 入力仕様

### 入力パラメータ（事前定義変数）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $ci | bool | No | false | CI環境フラグ |
| $configuration | string | No | Debug | ビルド構成 |
| $excludeCIBinarylog | bool | No | false | CIバイナリログ除外フラグ |
| $binaryLog | bool | No | CI時true | バイナリログ有効化 |
| $pipelinesLog | bool | No | CI時true | パイプラインログ有効化 |
| $prepareMachine | bool | No | false | マシン準備/クリーンアップ |
| $restore | bool | No | true | リストア有効化 |
| $verbosity | string | No | minimal | MSBuild詳細度 |
| $nodeReuse | bool | No | !$ci | ノード再利用 |
| $warnAsError | bool | No | true | 警告をエラー扱い |
| $msbuildEngine | string | No | null | MSBuildエンジン（vs/dotnet） |
| $useInstalledDotNetCli | bool | No | true | システムdotnet使用 |
| $useGlobalNuGetCache | bool | No | !$ci | グローバルNuGetキャッシュ使用 |
| $excludePrereleaseVS | bool | No | false | プレリリースVS除外 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDK/ツールバージョン定義 |
| NuGet.config | XML | NuGetソース設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/toolset | ディレクトリ | ツールセット情報 |
| artifacts/log | ディレクトリ | ログファイル |
| artifacts/tmp | ディレクトリ | 一時ファイル |
| .dotnet | ディレクトリ | インストールされたSDK |
| .tools | ディレクトリ | vswhereなどのツール |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ToolsetRestore.binlog、sdk.txt等 |
| 出力先 | artifacts/log、artifacts/toolset |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 変数の初期化
   └─ 各種ビルド設定のデフォルト値設定
2. StrictModeとエラーハンドリング設定
   └─ Set-StrictMode -Version 2.0、$ErrorActionPreference = 'Stop'
3. ディレクトリ構造の作成
   └─ ToolsetDir、TempDir、LogDirの作成
4. pipeline-logging-functions.ps1の読み込み
5. パス変数の設定
   └─ RepoRoot、EngRoot、ArtifactsDir等
6. global.jsonの読み込み
7. configure-toolset.ps1の読み込み（存在する場合）
8. Azure Pipelines変数の設定
   └─ Artifacts、Artifacts.Toolset、Artifacts.Log、TEMP、TMP
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト読み込み] --> B[変数初期化]
    B --> C[StrictMode設定]
    C --> D[ディレクトリ作成]
    D --> E[pipeline-logging-functions.ps1読み込み]
    E --> F[パス変数設定]
    F --> G[global.json読み込み]
    G --> H{configure-toolset.ps1存在?}
    H -->|Yes| I[configure-toolset.ps1読み込み]
    H -->|No| J[Azure Pipelines変数設定]
    I --> J
    J --> K[読み込み完了]
```

## 主要関数一覧

### InitializeDotNetCli
.NET CLIの初期化とインストールを行う。

### InitializeVisualStudioMSBuild
Visual StudioのMSBuildを検出・初期化する。

### InitializeBuildTool
使用するビルドツール（dotnet または vs）を決定する。

### InitializeToolset
Arcade SDKツールセットを初期化する。

### MSBuild / MSBuild-Core
MSBuildコマンドを実行する。

### InstallDotNet / InstallDotNetSdk
.NET SDK/ランタイムをインストールする。

### GetNuGetPackageCachePath
NuGetパッケージキャッシュパスを取得・設定する。

### ExitWithExitCode
適切な終了処理を行って終了する。

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | InitializeToolset | SDK/ツールセット初期化失敗 | global.jsonとネットワーク確認 |
| 1 | Build | MSBuild実行失敗 | ビルドログを確認 |
| 1 | VisualStudio | VS/MSBuild検出失敗 | VS のインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（Retry関数） |
| リトライ間隔 | 指数バックオフ（2^n-1秒） |
| リトライ対象エラー | ダウンロードエラー |

### 障害時対応

1. artifacts/logディレクトリのログを確認
2. global.jsonのSDKバージョンを確認
3. ネットワーク接続を確認
4. artifacts/toolsetディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | N/A（ライブラリ） |
| 目標処理時間 | 関数依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

- sdk.txtファイルへの書き込みで競合防止ロジック実装（ランダムファイル名→Move）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理実行時 | Write-Host出力 |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError |
| バイナリログ | MSBuild実行時 | ToolsetRestore.binlog等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- dotnet/arcadeフレームワークの中核スクリプト（約960行）
- 多数の関数を提供するユーティリティライブラリ
- vswhereを使用したVS検出、xcopy-msbuildによるMSBuildダウンロード対応
- NuGetリトライ設定の自動化（NUGET_ENABLE_ENHANCED_HTTP_RETRY等）
- Darc（dependency flow automation）ツールとの統合
