# バッチ設計書 37-eng_common_tools.sh

## 概要

本ドキュメントは、dotnet/arcadeフレームワークの共通ツールユーティリティ（Bash版）である `eng/common/tools.sh` の設計仕様を定義するものです。

### 本バッチの処理概要

このスクリプトは、Unix/Linux/macOS環境において、.NETプロジェクトのビルドに必要な各種ツール（dotnet CLI、MSBuild等）の初期化、設定、実行をサポートする共通ユーティリティライブラリです。dotnet/arcadeフレームワークを使用するすべてのリポジトリのビルドスクリプト（build.sh）からソースされ、基盤となる機能を提供します。

**業務上の目的・背景**：Unix系環境での.NETプロジェクトビルドにおいて、ツール初期化・実行に関する共通ロジックを集約しています。PowerShell版（tools.ps1）と同等の機能をBash環境で提供し、クロスプラットフォーム開発を可能にします。

**バッチの実行タイミング**：build.shなどのビルドスクリプトからsource（.）コマンドで読み込まれ、各関数が必要に応じて呼び出されます。

**主要な処理内容**：
1. ビルド変数の初期化（configuration、verbosity、ci等）
2. .NET CLIの初期化とインストール（InitializeDotNetCli）
3. ビルドツールの初期化（InitializeBuildTool）
4. Arcade SDKツールセットの初期化（InitializeToolset）
5. MSBuildコマンドの実行（MSBuild、MSBuild-Core）
6. パスユーティリティ関数の提供
7. Azure Pipelinesとの統合

**前後の処理との関連**：pipeline-logging-functions.shを読み込み、configure-toolset.sh（存在する場合）をインポートします。init-tools-native.shやdarc-init.shなど他の共通スクリプトと連携します。

**影響範囲**：artifacts配下のディレクトリ構造、環境変数（PATH、DOTNET_INSTALL_DIR、NUGET_PACKAGES等）、NuGetパッケージキャッシュ

## バッチ種別

ユーティリティライブラリ / ツール初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | sourceコマンドでの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Unix/Linux/macOS等のBash実行環境 |
| global.json | リポジトリルートにglobal.jsonが存在すること |
| pipeline-logging-functions.sh | 同一ディレクトリに存在すること |

### 実行可否判定

常にロード可能

## 入力仕様

### 入力パラメータ（事前定義変数）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ci | bool | No | false | CI環境フラグ |
| source_build | bool | No | false | ソースビルドモード |
| configuration | string | No | Debug | ビルド構成 |
| exclude_ci_binary_log | bool | No | false | CIバイナリログ除外 |
| binary_log | bool | No | CI時true | バイナリログ有効化 |
| pipelines_log | bool | No | CI時true | パイプラインログ有効化 |
| prepare_machine | bool | No | false | マシン準備/クリーンアップ |
| restore | bool | No | true | リストア有効化 |
| verbosity | string | No | minimal | MSBuild詳細度 |
| node_reuse | bool | No | !ci | ノード再利用 |
| warn_as_error | bool | No | true | 警告をエラー扱い |
| use_installed_dotnet_cli | bool | No | true | システムdotnet使用 |
| use_global_nuget_cache | bool | No | !ci | グローバルNuGetキャッシュ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDK/ツールバージョン定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/toolset | ディレクトリ | ツールセット情報 |
| artifacts/log | ディレクトリ | ログファイル |
| artifacts/tmp | ディレクトリ | 一時ファイル |
| .dotnet | ディレクトリ | インストールされたSDK |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ToolsetRestore.binlog等 |
| 出力先 | artifacts/log/$configuration |
| 文字コード | バイナリ/UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 変数の初期化
   └─ 各種ビルド設定のデフォルト値設定（${var:-default}構文）
2. ResolvePath関数の定義
   └─ シンボリックリンク解決ユーティリティ
3. 各種関数の定義
   └─ InitializeDotNetCli、InstallDotNet、MSBuild等
4. スクリプトパスの解決
   └─ _script_dir変数の設定
5. pipeline-logging-functions.shの読み込み
6. パス変数の設定
   └─ eng_root、repo_root、artifacts_dir等
7. global.jsonの解析
   └─ runtimesセクションの有無確認
8. ディレクトリ構造の作成
   └─ toolset_dir、temp_dir、log_dir
9. Azure Pipelines変数の設定
10. configure-toolset.shの読み込み（存在する場合）
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト読み込み] --> B[変数初期化]
    B --> C[関数定義]
    C --> D[スクリプトパス解決]
    D --> E[pipeline-logging-functions.sh読み込み]
    E --> F[パス変数設定]
    F --> G[global.json解析]
    G --> H[ディレクトリ作成]
    H --> I[Azure Pipelines変数設定]
    I --> J{configure-toolset.sh存在?}
    J -->|Yes| K[configure-toolset.sh読み込み]
    J -->|No| L[読み込み完了]
    K --> L
```

## 主要関数一覧

### ResolvePath
シンボリックリンクを解決して実際のパスを取得する。

### ReadGlobalVersion
global.jsonから指定されたキーの値を読み取る。

### InitializeDotNetCli
.NET CLIの初期化とインストールを行う。

### InstallDotNet / InstallDotNetSdk
.NET SDK/ランタイムをインストールする。

### with_retries
コマンドを最大5回リトライして実行する。

### GetDotNetInstallScript
dotnet-install.shスクリプトをダウンロード・取得する。

### InitializeBuildTool
使用するビルドツール（dotnet）を決定する。

### GetNuGetPackageCachePath
NuGetパッケージキャッシュパスを取得・設定する。

### InitializeNativeTools
ネイティブツール（CMake等）を初期化する。

### InitializeToolset
Arcade SDKツールセットを初期化する。

### ExitWithExitCode
適切な終了処理を行って終了する。

### StopProcesses
実行中のビルドプロセスを停止する。

### MSBuild / MSBuild-Core
MSBuildコマンドを実行する。

### GetDarc
Darcツールを初期化して取得する。

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | InitializeToolset | SDK/ツールセット初期化失敗 | global.jsonとネットワーク確認 |
| 2 | InitializeToolset | ツールセットリストア未実行 | --restore指定で再実行 |
| 3 | Build | ツールセットパス無効 | artifacts/toolset削除して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（with_retries関数） |
| リトライ間隔 | 指数バックオフ（3^n-1秒） |
| リトライ対象エラー | ダウンロードエラー |

### 障害時対応

1. artifacts/logディレクトリのログを確認
2. global.jsonのSDKバージョンを確認
3. ネットワーク接続を確認
4. artifacts/toolsetディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | N/A（ライブラリ） |
| 目標処理時間 | 関数依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

特になし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理実行時 | echo出力 |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError |
| バイナリログ | MSBuild実行時 | ToolsetRestore.binlog等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- dotnet/arcadeフレームワークのBash版中核スクリプト（約600行）
- PowerShell版（tools.ps1）と同等の機能を提供
- jqコマンドが利用可能な場合はJSON解析に使用、なければBash正規表現で解析
- HOMEが未定義の場合はartifacts/.home/を使用
- dotnet-install.shスクリプトは30日経過で再ダウンロード
