# バッチ設計書 38-eng_common_SetupNugetSources.ps1

## 概要

本ドキュメントは、NuGetソース設定を行うPowerShellスクリプト `eng/common/SetupNugetSources.ps1` の設計仕様を定義するものです。

### 本バッチの処理概要

このスクリプトは、内部NuGetフィードをNuGet.configファイルに追加・有効化し、オプションで認証情報を設定するためのユーティリティです。dotnet/arcadeフレームワークを使用するリポジトリにおいて、内部パッケージソースへのアクセスを可能にします。

**業務上の目的・背景**：.NETの大規模開発では、パブリックNuGetフィードに加えて、内部の開発ビルドやプレリリースパッケージを格納する内部フィードが使用されます。このスクリプトは、CIパイプラインやローカル開発環境で、これらの内部フィードを自動的に設定することで、ビルドの再現性と開発効率を向上させます。特にMaestro（darc）による依存関係管理で自動生成される darc-int-* フィードの有効化に重要な役割を果たします。

**バッチの実行タイミング**：Azure PipelinesのCI/CDパイプラインの初期段階、NuGetAuthenticateタスクの前に実行されます。

**主要な処理内容**：
1. NuGet.configファイルの読み込み
2. 既存パッケージソースの確認（dotnet5〜10）
3. 対応する内部フィード（*-internal、*-internal-transport）の追加
4. 無効化されたdarc-int-*フィードの有効化
5. オプションでパッケージソース認証情報の設定

**前後の処理との関連**：このスクリプトはNuGetAuthenticateタスクの前に実行する必要があります。tools.ps1を読み込み、その機能を使用します。

**影響範囲**：NuGet.configファイルの内容（パッケージソースおよび認証情報セクション）

## バッチ種別

設定ファイル編集 / 認証設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDパイプライン実行時 |
| 実行時刻 | パイプライン依存 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | Windows PowerShell または PowerShell Core |
| NuGet.config | 対象の設定ファイルが存在すること |
| tools.ps1 | 同一ディレクトリにtools.ps1が存在すること |

### 実行可否判定

NuGet.configファイルが存在し、packageSourcesセクションを含む場合に実行可能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -ConfigFile | string | Yes | なし | NuGet.configファイルのパス |
| -Password | string | No | なし | 認証用パスワード（アクセストークン） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | NuGetパッケージソース設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| NuGet.config | XML | 更新されたNuGet設定ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ（上書き） |
| 出力先 | 入力と同じパス |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. パラメータ検証
   └─ ConfigFileの存在確認
2. tools.ps1の読み込み
3. NuGet.configの読み込み
   └─ XMLとしてパース
4. packageSourcesセクションの取得
   └─ 存在しない場合はエラー
5. packageSourceCredentialsセクションの取得/作成
   └─ Passwordが指定された場合のみ
6. disabledPackageSourcesの処理
   └─ darc-int-*フィードの有効化
7. 各dotnetバージョン（5〜10）のチェック
   └─ 対応するパブリックフィードが存在する場合、内部フィードを追加
8. 設定ファイルの保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ConfigFile存在?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[tools.ps1読み込み]
    D --> E[NuGet.config読み込み]
    E --> F{packageSources存在?}
    F -->|No| G[エラー終了]
    F -->|Yes| H{Password指定?}
    H -->|Yes| I[packageSourceCredentials取得/作成]
    H -->|No| J[disabledPackageSources確認]
    I --> J
    J --> K[darc-int-*フィード有効化]
    K --> L[dotnet5-10ループ]
    L --> M{dotnetXフィード存在?}
    M -->|Yes| N[dotnetX-internal追加]
    N --> O[dotnetX-internal-transport追加]
    M -->|No| P[次のバージョンへ]
    O --> P
    P --> L
    L --> Q[NuGet.config保存]
    Q --> R[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Build | ConfigFileが見つからない | 正しいパスを指定 |
| 1 | Build | packageSourcesセクションがない | NuGet.configの形式を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. NuGet.configファイルの存在と形式を確認
2. packageSourcesセクションの存在を確認
3. 手動でNuGet.configを編集して必要なソースを追加

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | ファイル保存時 |
| ロールバック条件 | N/A（元ファイルのバックアップなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特になし（単一ファイルへの書き込み）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ソース追加時 | "Adding package source..." |
| 進捗ログ | ソース有効化時 | "Enabling internal source..." |
| 進捗ログ | 認証追加時 | "Inserting credential for feed..." |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- 対応するdotnetバージョン: 5, 6, 7, 8, 9, 10
- 追加されるフィード形式: dotnetX-internal, dotnetX-internal-transport
- フィードURL: https://pkgs.dev.azure.com/dnceng/internal/_packaging/{feedname}/nuget/{version}
- パスワード指定時はv2フォーマット、未指定時はv3/index.jsonフォーマット
- darc-int-*フィードはNuGet issue #10291の回避のため、無効エントリを削除して有効化
- NuGetAuthenticateタスクの前に実行する必要がある
