# バッチ設計書 39-eng_common_SetupNugetSources.sh

## 概要

本ドキュメントは、NuGetソース設定を行うBashスクリプト `eng/common/SetupNugetSources.sh` の設計仕様を定義するものです。

### 本バッチの処理概要

このスクリプトは、Unix/Linux/macOS環境において、内部NuGetフィードをNuGet.configファイルに追加・有効化し、オプションで認証情報を設定するためのユーティリティです。PowerShell版（SetupNugetSources.ps1）と同等の機能をBash環境で提供します。

**業務上の目的・背景**：Unix系環境でのCI/CDパイプラインにおいて、内部NuGetフィードへのアクセスを設定する必要があります。このスクリプトにより、Linux/macOSのビルドエージェントでも内部パッケージソースを利用したビルドが可能になります。

**バッチの実行タイミング**：Azure PipelinesのCI/CDパイプラインの初期段階、NuGetAuthenticateタスクの前に実行されます。

**主要な処理内容**：
1. NuGet.configファイルの存在確認
2. macOSとLinuxでのsed構文の違いに対応
3. 無効化されたdarc-int-*フィードの有効化
4. 各dotnetバージョン（5〜10）の内部フィード追加
5. オプションでパッケージソース認証情報の設定

**前後の処理との関連**：このスクリプトはNuGetAuthenticateタスクの前に実行する必要があります。tools.shを読み込み、その機能を使用します。

**影響範囲**：NuGet.configファイルの内容

## バッチ種別

設定ファイル編集 / 認証設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDパイプライン実行時 |
| 実行時刻 | パイプライン依存 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Unix/Linux/macOS等のBash実行環境 |
| NuGet.config | 対象の設定ファイルが存在すること |
| tools.sh | 同一ディレクトリにtools.shが存在すること |
| sed | テキスト編集用のsedコマンド |
| grep | パターン検索用のgrepコマンド |

### 実行可否判定

NuGet.configファイルが存在し、packageSourcesセクションを含む場合に実行可能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (ConfigFile) | string | Yes | なし | NuGet.configファイルのパス |
| $2 (CredToken) | string | No | なし | 認証用トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | NuGetパッケージソース設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| NuGet.config | XML | 更新されたNuGet設定ファイル |
| NuGet.config.bak | XML | sed編集時のバックアップファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ（上書き） |
| 出力先 | 入力と同じパス |
| 文字コード | 元のファイルに依存 |
| 区切り文字 | N/A（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. 変数初期化
   └─ ConfigFile、CredToken、改行/タブ文字設定
2. スクリプトパスの解決
3. tools.shの読み込み
4. ConfigFileの存在確認
   └─ 存在しない場合はエラー終了
5. macOS判定
   └─ macOSの場合はsed構文を調整（改行の扱い）
6. packageSourcesセクションの確認
   └─ 存在しない場合はエラー終了
7. PackageSources配列の初期化
8. FeedSuffix設定
   └─ CredToken有無でv2/v3を切り替え
9. CredToken指定時のpackageSourceCredentialsセクション確認/作成
10. disabledPackageSourcesのdarc-int-*処理
11. 各dotnetバージョン（5〜10）のループ
    └─ 対応するパブリックフィード存在確認
    └─ 内部フィードの追加または有効化
12. darc-int-*フィードの検出
13. CredToken指定時の認証情報追加
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C[スクリプトパス解決]
    C --> D[tools.sh読み込み]
    D --> E{ConfigFile存在?}
    E -->|No| F[エラー終了]
    E -->|Yes| G{macOS?}
    G -->|Yes| H[NL/TB調整]
    G -->|No| I[packageSources確認]
    H --> I
    I --> J{packageSources存在?}
    J -->|No| K[エラー終了]
    J -->|Yes| L{CredToken指定?}
    L -->|Yes| M[FeedSuffix=v2]
    L -->|No| N[FeedSuffix=v3/index.json]
    M --> O[packageSourceCredentials確認/作成]
    N --> P[darc-int-*有効化]
    O --> P
    P --> Q[dotnet5-10ループ]
    Q --> R{dotnetXフィード存在?}
    R -->|Yes| S[内部フィード追加/有効化]
    R -->|No| T[次のバージョンへ]
    S --> T
    T --> Q
    Q --> U[darc-int-*フィード検出]
    U --> V{CredToken指定?}
    V -->|Yes| W[認証情報追加]
    V -->|No| X[終了]
    W --> X
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Build | ConfigFileが見つからない | 正しいパスを指定 |
| 1 | Build | packageSourcesセクションがない | NuGet.configの形式を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. NuGet.configファイルの存在と形式を確認
2. packageSourcesセクションの存在を確認
3. .bakファイルから復元して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | 各sed実行時 |
| ロールバック条件 | .bakファイルから復元可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特になし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ソース追加時 | "Adding package source..." |
| 進捗ログ | ソース有効化時 | "Enabling internal source..." |
| 進捗ログ | 認証追加時 | "Inserting credential for feed..." |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- macOSとLinuxでsed構文が異なるため、uname -sで判定して対応
- macOSではNL変数に$'\\\n'、TB変数に''を設定
- sed -i.bakオプションでバックアップファイルを作成
- 対応するdotnetバージョン: 5, 6, 7, 8, 9, 10
- 追加されるフィード形式: dotnetX-internal, dotnetX-internal-transport
- PowerShell版と同等の機能をBash環境で提供
